/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;

@FileStatefulCheck
public final class MethodCountCheck
extends AbstractCheck {
    public static final String MSG_PRIVATE_METHODS = "too.many.privateMethods";
    public static final String MSG_PACKAGE_METHODS = "too.many.packageMethods";
    public static final String MSG_PROTECTED_METHODS = "too.many.protectedMethods";
    public static final String MSG_PUBLIC_METHODS = "too.many.publicMethods";
    public static final String MSG_MANY_METHODS = "too.many.methods";
    private static final int DEFAULT_MAX_METHODS = 100;
    private final Deque<MethodCounter> counters = new ArrayDeque<MethodCounter>();
    private int maxPrivate = 100;
    private int maxPackage = 100;
    private int maxProtected = 100;
    private int maxPublic = 100;
    private int maxTotal = 100;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 155, 154, 15, 157, 9, 199};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 9) {
            if (this.isInLatestScopeDefinition(ast)) {
                this.raiseCounter(ast);
            }
        } else {
            this.counters.push(new MethodCounter(ast));
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        if (ast.getType() != 9) {
            MethodCounter counter = this.counters.pop();
            this.checkCounters(counter, ast);
        }
    }

    private boolean isInLatestScopeDefinition(DetailAST methodDef) {
        boolean result = false;
        if (!this.counters.isEmpty()) {
            DetailAST latestDefinition = this.counters.peek().getScopeDefinition();
            result = latestDefinition == methodDef.getParent().getParent();
        }
        return result;
    }

    private void raiseCounter(DetailAST method) {
        MethodCounter actualCounter = this.counters.peek();
        Scope scope = ScopeUtil.getScope(method);
        actualCounter.increment(scope);
    }

    private void checkCounters(MethodCounter counter, DetailAST ast) {
        this.checkMax(this.maxPrivate, counter.value(Scope.PRIVATE), MSG_PRIVATE_METHODS, ast);
        this.checkMax(this.maxPackage, counter.value(Scope.PACKAGE), MSG_PACKAGE_METHODS, ast);
        this.checkMax(this.maxProtected, counter.value(Scope.PROTECTED), MSG_PROTECTED_METHODS, ast);
        this.checkMax(this.maxPublic, counter.value(Scope.PUBLIC), MSG_PUBLIC_METHODS, ast);
        this.checkMax(this.maxTotal, counter.getTotal(), MSG_MANY_METHODS, ast);
    }

    private void checkMax(int max, int value, String msg, DetailAST ast) {
        if (max < value) {
            this.log(ast, msg, value, max);
        }
    }

    public void setMaxPrivate(int value) {
        this.maxPrivate = value;
    }

    public void setMaxPackage(int value) {
        this.maxPackage = value;
    }

    public void setMaxProtected(int value) {
        this.maxProtected = value;
    }

    public void setMaxPublic(int value) {
        this.maxPublic = value;
    }

    public void setMaxTotal(int value) {
        this.maxTotal = value;
    }

    private static class MethodCounter {
        private final Map<Scope, Integer> counts = new EnumMap<Scope, Integer>(Scope.class);
        private final DetailAST scopeDefinition;
        private int total;

        MethodCounter(DetailAST scopeDefinition) {
            this.scopeDefinition = scopeDefinition;
        }

        private void increment(Scope scope) {
            ++this.total;
            this.counts.put(scope, 1 + this.value(scope));
        }

        private int value(Scope scope) {
            Integer value = this.counts.get((Object)scope);
            if (value == null) {
                value = 0;
            }
            return value;
        }

        private DetailAST getScopeDefinition() {
            return this.scopeDefinition;
        }

        private int getTotal() {
            return this.total;
        }
    }
}

