/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;
import java.util.regex.Pattern;

public class LocalVariableNameCheck
extends AbstractNameCheck {
    private boolean allowOneCharVarInForLoop;
    private static Pattern sSingleChar = Pattern.compile("^[a-z]$");

    public LocalVariableNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public final void setAllowOneCharVarInForLoop(boolean allow) {
        this.allowOneCharVarInForLoop = allow;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{10, 21};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 21};
    }

    @Override
    protected final boolean mustCheckName(DetailAST ast) {
        boolean isFinal;
        DetailAST modifiersAST = ast.findFirstToken(5);
        boolean bl = isFinal = modifiersAST != null && modifiersAST.branchContains(39);
        if (this.allowOneCharVarInForLoop && this.isForLoopVariable(ast)) {
            String variableName = ast.findFirstToken(58).getText();
            return !sSingleChar.matcher(variableName).find();
        }
        return !isFinal && ScopeUtils.isLocalVariableDef(ast);
    }

    private boolean isForLoopVariable(DetailAST variableDef) {
        int parentType = variableDef.getParent().getType();
        return parentType == 35 || parentType == 156;
    }
}

