/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.BlockParentHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.CaseHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;

public class SlistHandler
extends BlockParentHandler {
    private static final int[] PARENT_TOKEN_TYPES = new int[]{8, 9, 12, 67, 83, 84, 85, 91, 92, 95, 96, 97};

    public SlistHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "block", ast, parent);
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        IndentLevel result = this.getParent() instanceof BlockParentHandler && !(this.getParent() instanceof SlistHandler) || child instanceof SlistHandler && this.getParent() instanceof CaseHandler ? this.getParent().getSuggestedChildIndent(child) : super.getSuggestedChildIndent(child);
        return result;
    }

    @Override
    protected DetailAST getListChild() {
        return this.getMainAst();
    }

    @Override
    protected DetailAST getLeftCurly() {
        return this.getMainAst();
    }

    @Override
    protected DetailAST getRightCurly() {
        return this.getMainAst().findFirstToken(73);
    }

    @Override
    protected DetailAST getTopLevelAst() {
        return null;
    }

    private boolean hasBlockParent() {
        int parentType = this.getMainAst().getParent().getType();
        return Arrays.binarySearch(PARENT_TOKEN_TYPES, parentType) >= 0;
    }

    @Override
    public void checkIndentation() {
        if (!this.hasBlockParent() && !this.isSameLineCaseGroup()) {
            super.checkIndentation();
        }
    }

    private boolean isSameLineCaseGroup() {
        DetailAST parentNode = this.getMainAst().getParent();
        return parentNode.getType() == 33 && TokenUtil.areOnSameLine(this.getMainAst(), parentNode);
    }

    static {
        Arrays.sort(PARENT_TOKEN_TYPES);
    }
}

