/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.collections;

import com.querydsl.collections.FunctionalHelpers;
import com.querydsl.core.types.Path;
import java.util.function.Function;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.IsNull;

public class PathMatcher<T, V>
extends TypeSafeDiagnosingMatcher<T> {
    private final Function<T, V> accessor;
    private final Matcher<? super V> matcher;
    private final Path<V> path;

    public PathMatcher(Path<V> path, Matcher<? super V> matcher) {
        this(path, matcher, FunctionalHelpers.wrap(path));
    }

    public PathMatcher(Path<V> path, Matcher<? super V> matcher, Function<T, V> accessor) {
        this.path = path;
        this.matcher = matcher;
        this.accessor = accessor;
    }

    public static <T, P> Matcher<T> hasValue(Path<P> path) {
        return new PathMatcher<T, P>(path, IsNull.notNullValue());
    }

    public static <T, P> Matcher<T> hasValue(Path<P> path, Matcher<? super P> matcher) {
        return new PathMatcher<T, P>(path, matcher);
    }

    protected boolean matchesSafely(T bean, Description mismatchDescription) {
        V value = this.accessor.apply(bean);
        boolean valueMatches = this.matcher.matches(value);
        if (!valueMatches) {
            mismatchDescription.appendText("value \"" + this.path.toString() + "\" ");
            this.matcher.describeMismatch(value, mismatchDescription);
        }
        return valueMatches;
    }

    public void describeTo(Description description) {
        description.appendText("valueOf(");
        description.appendValue((Object)this.path.toString());
        description.appendText(", ");
        description.appendDescriptionOf(this.matcher);
        description.appendText(")");
    }
}

