/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.alias;

import com.querydsl.core.alias.Alias;
import com.querydsl.core.alias.ComparableEntity;
import com.querydsl.core.alias.DomainType;
import com.querydsl.core.alias.Gender;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.StringPath;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.junit.Assert;
import org.junit.Test;

public class AliasTest {
    @Test
    public void alias() {
        DomainType domainType = (DomainType)Alias.alias(DomainType.class);
        Alias.alias(DomainType.class, (Expression)Alias.$(domainType.getCollection()).any());
    }

    @Test
    public void comparableEntity() {
        ComparableEntity entity = (ComparableEntity)Alias.alias(ComparableEntity.class);
        ComparablePath path = Alias.$((Comparable)entity);
        Assert.assertEquals(ComparableEntity.class, (Object)path.getType());
    }

    @Test
    public void comparableEntity_property() {
        ComparableEntity entity = (ComparableEntity)Alias.alias(ComparableEntity.class);
        StringPath propertyPath = Alias.$((String)entity.getProperty());
        Assert.assertEquals(String.class, (Object)propertyPath.getType());
        Assert.assertEquals((Object)"property", (Object)propertyPath.getMetadata().getName());
    }

    @Test
    public void basicUsage() {
        DomainType domainType = (DomainType)Alias.alias(DomainType.class);
        Assert.assertEquals((Object)"lower(domainType.firstName)", (Object)Alias.$((String)domainType.getFirstName()).lower().toString());
        Assert.assertEquals((Object)"domainType.age", (Object)Alias.$((Integer)domainType.getAge()).toString());
        Assert.assertEquals((Object)"domainType.map.get(a)", (Object)Alias.$((Object)domainType.getMap().get("a")).toString());
        Assert.assertEquals((Object)"domainType.list.get(0)", (Object)Alias.$((Object)domainType.getList().get(0)).toString());
        Assert.assertEquals((Object)"domainType.bigDecimal", (Object)Alias.$((BigDecimal)domainType.getBigDecimal()).toString());
        Assert.assertEquals((Object)"domainType.bigInteger", (Object)Alias.$((BigInteger)domainType.getBigInteger()).toString());
        Assert.assertEquals((Object)"domainType.byte", (Object)Alias.$((Byte)domainType.getByte()).toString());
        Assert.assertEquals((Object)"domainType.collection", (Object)Alias.$(domainType.getCollection()).toString());
        Assert.assertEquals((Object)"domainType.double", (Object)Alias.$((Double)domainType.getDouble()).toString());
        Assert.assertEquals((Object)"domainType.float", (Object)Alias.$((Float)domainType.getFloat()).toString());
        Assert.assertEquals((Object)"domainType.date", (Object)Alias.$((Date)domainType.getDate()).toString());
        Assert.assertEquals((Object)"domainType.date2", (Object)Alias.$((java.util.Date)domainType.getDate2()).toString());
        Assert.assertEquals((Object)"domainType.set", (Object)Alias.$(domainType.getSet()).toString());
        Assert.assertEquals((Object)"domainType.short", (Object)Alias.$((Short)domainType.getShort()).toString());
        Assert.assertEquals((Object)"domainType.time", (Object)Alias.$((Time)domainType.getTime()).toString());
        Assert.assertEquals((Object)"domainType.timestamp", (Object)Alias.$((Timestamp)domainType.getTimestamp()).toString());
        Assert.assertEquals((Object)"domainType.gender", (Object)Alias.$((Enum)domainType.getGender()).toString());
    }

    @Test
    public void getAny() {
        DomainType domainType = (DomainType)Alias.alias(DomainType.class);
        Assert.assertEquals(DomainType.class, (Object)Alias.getAny((Object)domainType).getType());
        Assert.assertEquals(String.class, (Object)Alias.getAny((Object)domainType.getFirstName()).getType());
    }

    @Test
    public void otherMethods() {
        DomainType domainType = (DomainType)Alias.alias(DomainType.class);
        Assert.assertEquals((Object)"domainType", (Object)domainType.toString());
    }

    @Test
    public void var() {
        Assert.assertEquals((Object)"it", (Object)Alias.var().toString());
        Assert.assertEquals((Object)"varInteger1", (Object)Alias.var((Number)1).toString());
        Assert.assertEquals((Object)"X", (Object)Alias.var((String)"X").toString());
        Assert.assertEquals((Object)"varMALE", (Object)Alias.var((Comparable)((Object)Gender.MALE)).toString());
        Assert.assertEquals((Object)"varAliasTest_XXX", (Object)Alias.var((Object)new AliasTest()).toString());
    }

    public String toString() {
        return "XXX";
    }
}

