/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.SubQueryExpressionImpl;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.ValidatingVisitor;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.Param;
import java.util.HashSet;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;

public class ValidatingVisitorTest {
    private final Set<Expression<?>> known = new HashSet();
    private final ValidatingVisitor validator = ValidatingVisitor.DEFAULT;

    @Before
    public void setUp() {
        this.known.add((Expression<?>)ExpressionUtils.path(Object.class, (String)"path"));
    }

    @Test
    public void visitConstantOfQVoid() {
        this.validator.visit(ConstantImpl.create((Object)"XXX"), this.known);
    }

    @Test
    public void visitFactoryExpressionOfQVoid() {
        this.validator.visit((FactoryExpression)new QBean(Object.class, new Expression[]{ExpressionUtils.path(String.class, (String)"path")}), this.known);
    }

    @Test
    public void visitOperationOfQVoid() {
        this.validator.visit((Operation)Expressions.path(Object.class, (String)"path").isNull(), this.known);
    }

    @Test
    public void visitParamExpressionOfQVoid() {
        this.validator.visit((ParamExpression)new Param(Object.class, "prop"), this.known);
    }

    @Test
    public void visitPathOfQVoid() {
        this.validator.visit(ExpressionUtils.path(Object.class, (String)"path"), this.known);
    }

    @Test
    public void visitSubQueryExpressionOfQVoid() {
        this.validator.visit((SubQueryExpression)new SubQueryExpressionImpl(Object.class, (QueryMetadata)new DefaultQueryMetadata()), this.known);
    }

    @Test
    public void visitTemplateExpressionOfQVoid() {
        this.validator.visit((TemplateExpression)Expressions.template(Object.class, (String)"XXX", (Object[])new Object[0]), this.known);
    }
}

