/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.alias.Alias;
import com.querydsl.core.annotations.QueryEntity;
import com.querydsl.core.annotations.QueryTransient;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathMetadataFactory;
import com.querydsl.core.types.Templates;
import com.querydsl.core.types.ToStringVisitor;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.ArrayPath;
import com.querydsl.core.types.dsl.BeanPath;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.CollectionPath;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.DatePath;
import com.querydsl.core.types.dsl.DateTimePath;
import com.querydsl.core.types.dsl.EnumPath;
import com.querydsl.core.types.dsl.ListPath;
import com.querydsl.core.types.dsl.MapPath;
import com.querydsl.core.types.dsl.NumberPath;
import com.querydsl.core.types.dsl.SetPath;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.TimePath;
import com.querydsl.core.util.Annotations;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

public class PathTest {
    @Test
    public void getAnnotatedElement() {
        Entity entity = (Entity)Alias.alias(Entity.class);
        AnnotatedElement element = Alias.$((Object)entity).getAnnotatedElement();
        Assert.assertEquals(Entity.class, (Object)element);
    }

    @Test
    public void getAnnotatedElement_for_property() {
        Entity entity = (Entity)Alias.alias(Entity.class);
        AnnotatedElement property1 = Alias.$((String)entity.getProperty1()).getAnnotatedElement();
        AnnotatedElement property2 = Alias.$((String)entity.getProperty2()).getAnnotatedElement();
        AnnotatedElement property3 = Alias.$((String)entity.getProperty3()).getAnnotatedElement();
        AnnotatedElement property4 = Alias.$((String)entity.getProperty4()).getAnnotatedElement();
        Assert.assertEquals(Annotations.class, property1.getClass());
        Assert.assertEquals(Annotations.class, property2.getClass());
        Assert.assertEquals(Field.class, property3.getClass());
        Assert.assertTrue((boolean)property3.isAnnotationPresent(QueryTransient.class));
        Assert.assertNotNull((Object)property3.getAnnotation(QueryTransient.class));
        Assert.assertEquals(Annotations.class, property4.getClass());
    }

    @Test
    public void equals() {
        Assert.assertEquals((Object)new StringPath("s"), (Object)new StringPath("s"));
        Assert.assertEquals((Object)new BooleanPath("b"), (Object)new BooleanPath("b"));
        Assert.assertEquals((Object)new NumberPath(Integer.class, "n"), (Object)new NumberPath(Integer.class, "n"));
        Assert.assertEquals((Object)new ArrayPath(String[].class, "p"), (Object)ExpressionUtils.path(String.class, (String)"p"));
        Assert.assertEquals((Object)new BooleanPath("p"), (Object)ExpressionUtils.path(Boolean.class, (String)"p"));
        Assert.assertEquals((Object)new ComparablePath(String.class, "p"), (Object)ExpressionUtils.path(String.class, (String)"p"));
        Assert.assertEquals((Object)new DatePath(Date.class, "p"), (Object)ExpressionUtils.path(Date.class, (String)"p"));
        Assert.assertEquals((Object)new DateTimePath(Date.class, "p"), (Object)ExpressionUtils.path(Date.class, (String)"p"));
        Assert.assertEquals((Object)new EnumPath(ExampleEnum.class, "p"), (Object)ExpressionUtils.path(ExampleEnum.class, (String)"p"));
        Assert.assertEquals((Object)new NumberPath(Integer.class, "p"), (Object)ExpressionUtils.path(Integer.class, (String)"p"));
        Assert.assertEquals((Object)new StringPath("p"), (Object)ExpressionUtils.path(String.class, (String)"p"));
        Assert.assertEquals((Object)new TimePath(Time.class, "p"), (Object)ExpressionUtils.path(Time.class, (String)"p"));
    }

    @Test
    public void various_properties() {
        Path parent = ExpressionUtils.path(Object.class, (String)"parent");
        ArrayList<Object> paths = new ArrayList<Object>();
        paths.add(new ArrayPath(String[].class, parent, "p"));
        paths.add(new BeanPath(Object.class, parent, "p"));
        paths.add(new BooleanPath(parent, "p"));
        paths.add(new CollectionPath(String.class, StringPath.class, parent, "p"));
        paths.add(new ComparablePath(String.class, parent, "p"));
        paths.add(new DatePath(Date.class, parent, "p"));
        paths.add(new DateTimePath(Date.class, parent, "p"));
        paths.add(new EnumPath(ExampleEnum.class, parent, "p"));
        paths.add(new ListPath(String.class, StringPath.class, parent, "p"));
        paths.add(new MapPath(String.class, String.class, StringPath.class, parent, "p"));
        paths.add(new NumberPath(Integer.class, parent, "p"));
        paths.add(new SetPath(String.class, StringPath.class, parent, "p"));
        paths.add(new SimplePath(String.class, parent, "p"));
        paths.add(new StringPath(parent, "p"));
        paths.add(new TimePath(Time.class, parent, "p"));
        for (Path path : paths) {
            Path other = ExpressionUtils.path((Class)path.getType(), (PathMetadata)PathMetadataFactory.forProperty((Path)parent, (String)"p"));
            Assert.assertEquals((Object)path.toString(), (Object)path.accept((Visitor)ToStringVisitor.DEFAULT, (Object)Templates.DEFAULT));
            Assert.assertEquals((long)path.hashCode(), (long)other.hashCode());
            Assert.assertEquals((Object)path, (Object)other);
            Assert.assertNotNull((Object)path.getMetadata());
            Assert.assertNotNull((Object)path.getType());
            Assert.assertEquals((Object)parent, (Object)path.getRoot());
        }
    }

    @Test
    public void various() {
        ArrayList<Object> paths = new ArrayList<Object>();
        paths.add(new ArrayPath(String[].class, "p"));
        paths.add(new BeanPath(Object.class, "p"));
        paths.add(new BooleanPath("p"));
        paths.add(new CollectionPath(String.class, StringPath.class, "p"));
        paths.add(new ComparablePath(String.class, "p"));
        paths.add(new DatePath(Date.class, "p"));
        paths.add(new DateTimePath(Date.class, "p"));
        paths.add(new EnumPath(ExampleEnum.class, "p"));
        paths.add(new ListPath(String.class, StringPath.class, "p"));
        paths.add(new MapPath(String.class, String.class, StringPath.class, "p"));
        paths.add(new NumberPath(Integer.class, "p"));
        paths.add(new SetPath(String.class, StringPath.class, "p"));
        paths.add(new SimplePath(String.class, "p"));
        paths.add(new StringPath("p"));
        paths.add(new TimePath(Time.class, "p"));
        for (Path path : paths) {
            Path other = ExpressionUtils.path((Class)path.getType(), (String)"p");
            Assert.assertEquals((Object)path.toString(), (Object)path.accept((Visitor)ToStringVisitor.DEFAULT, null));
            Assert.assertEquals((long)path.hashCode(), (long)other.hashCode());
            Assert.assertEquals((Object)path, (Object)other);
            Assert.assertNotNull((Object)path.getMetadata());
            Assert.assertNotNull((Object)path.getType());
            Assert.assertEquals((Object)path, (Object)path.getRoot());
        }
    }

    @Test
    public void parent_path() {
        Path person = ExpressionUtils.path(Object.class, (String)"person");
        Path name = ExpressionUtils.path(String.class, (Path)person, (String)"name");
        Assert.assertEquals((Object)"person.name", (Object)name.toString());
    }

    @QueryEntity
    public static class Entity
    extends Superclass {
        @Nullable
        private String property1;
        private String property2;
        @QueryTransient
        private String property3;

        public String getProperty1() {
            return this.property1;
        }

        @NotNull
        public String getProperty2() {
            return this.property2;
        }

        @NotNull
        public String getProperty3() {
            return this.property3;
        }
    }

    static enum ExampleEnum {
        A,
        B;

    }

    public static class Superclass {
        @Nullable
        public String getProperty4() {
            return null;
        }
    }
}

