/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.Tuple;
import com.querydsl.core.annotations.Immutable;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionBase;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.util.CollectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Unmodifiable;

@Immutable
public class QTuple
extends FactoryExpressionBase<Tuple> {
    private static final long serialVersionUID = -2640616030595420465L;
    private final @Unmodifiable List<Expression<?>> args;
    private final Map<Expression<?>, Integer> bindings;

    private static Map<Expression<?>, Integer> createBindings(List<Expression<?>> exprs) {
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < exprs.size(); ++i) {
            Expression<?> e = exprs.get(i);
            if (e instanceof Operation && ((Operation)e).getOperator() == Ops.ALIAS) {
                map.put(((Operation)e).getArg(1), i);
            }
            map.put(e, i);
        }
        return Collections.unmodifiableMap(map);
    }

    protected QTuple(Expression<?> ... args) {
        this(Arrays.asList(args));
    }

    protected QTuple(List<Expression<?>> args) {
        super(Tuple.class);
        this.args = CollectionUtils.unmodifiableList(args);
        this.bindings = QTuple.createBindings(this.args);
    }

    protected QTuple(Expression<?>[] ... args) {
        super(Tuple.class);
        ArrayList builder = new ArrayList();
        for (Expression<?>[] exprs : args) {
            Collections.addAll(builder, exprs);
        }
        this.args = CollectionUtils.unmodifiableList(builder);
        this.bindings = QTuple.createBindings(this.args);
    }

    @Override
    public Tuple newInstance(Object ... a) {
        return new TupleImpl(a);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return v.visit(this, context);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FactoryExpression) {
            FactoryExpression c = (FactoryExpression)obj;
            return this.args.equals(c.getArgs()) && this.getType().equals(c.getType());
        }
        return false;
    }

    @Override
    public @Unmodifiable List<Expression<?>> getArgs() {
        return this.args;
    }

    private final class TupleImpl
    implements Tuple,
    Serializable {
        private static final long serialVersionUID = 6635924689293325950L;
        private final Object[] a;

        private TupleImpl(Object[] a) {
            this.a = a;
        }

        @Override
        public <T> T get(int index, Class<T> type) {
            return (T)this.a[index];
        }

        @Override
        public <T> T get(Expression<T> expr) {
            Integer idx = QTuple.this.bindings.get(expr);
            if (idx != null) {
                return (T)this.a[idx];
            }
            return null;
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return this.a;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Tuple) {
                return Arrays.equals(this.a, ((Tuple)obj).toArray());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.a);
        }

        public String toString() {
            return Arrays.toString(this.a);
        }
    }
}

