/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.group.guava;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultimap;
import com.querydsl.core.ResultTransformer;
import com.querydsl.core.group.Group;
import com.querydsl.core.group.GroupByBuilder;
import com.querydsl.core.group.guava.GroupByMultimap;
import com.querydsl.core.group.guava.GroupByTable;
import com.querydsl.core.types.Expression;
import java.util.Comparator;
import java.util.Map;

public class GuavaGroupByBuilder<K>
extends GroupByBuilder<K> {
    public GuavaGroupByBuilder(Expression<K> key) {
        super(key);
    }

    public <V> ResultTransformer<Multimap<K, V>> asMultimap(Expression<V> expression) {
        final Expression lookup = this.getLookup(expression);
        return new GroupByMultimap<K, V, Multimap<K, V>>(this.key, new Expression[]{expression}){

            @Override
            protected Multimap<K, V> transform(Multimap<K, Group> groups) {
                LinkedHashMultimap results = LinkedHashMultimap.create();
                for (Map.Entry entry : groups.entries()) {
                    results.put(entry.getKey(), ((Group)entry.getValue()).getOne(lookup));
                }
                return results;
            }
        };
    }

    public <V extends Comparable<? super V>> ResultTransformer<TreeMultimap<K, V>> asSortedSetMultimap(Expression<V> expression) {
        final Expression lookup = this.getLookup(expression);
        return new GroupByMultimap<K, V, TreeMultimap<K, V>>(this.key, new Expression[]{expression}){

            @Override
            protected TreeMultimap<K, V> transform(Multimap<K, Group> groups) {
                TreeMultimap results = TreeMultimap.create();
                for (Map.Entry entry : groups.entries()) {
                    results.put(entry.getKey(), ((Group)entry.getValue()).getOne(lookup));
                }
                return results;
            }
        };
    }

    public <V> ResultTransformer<TreeMultimap<K, V>> asSortedSetMultimap(Expression<V> expression, final Comparator<? super K> comparator, final Comparator<? super V> valueComparator) {
        final Expression lookup = this.getLookup(expression);
        return new GroupByMultimap<K, V, TreeMultimap<K, V>>(this.key, new Expression[]{expression}){

            @Override
            protected TreeMultimap<K, V> transform(Multimap<K, Group> groups) {
                TreeMultimap results = TreeMultimap.create((Comparator)comparator, (Comparator)valueComparator);
                for (Map.Entry entry : groups.entries()) {
                    results.put(entry.getKey(), ((Group)entry.getValue()).getOne(lookup));
                }
                return results;
            }
        };
    }

    public <C, V> ResultTransformer<Table<K, C, V>> asTable(Expression<C> column, Expression<V> expression) {
        final Expression columnKeyLookup = this.getLookup(column);
        final Expression lookup = this.getLookup(expression);
        return new GroupByTable<K, C, V, Table<K, C, V>>(this.key, column, new Expression[]{expression}){

            @Override
            protected Table<K, C, V> transform(Table<K, ?, Group> groups) {
                HashBasedTable results = HashBasedTable.create();
                for (Table.Cell cell : groups.cellSet()) {
                    Object rowKey = cell.getRowKey();
                    Object columnKey = ((Group)cell.getValue()).getOne(columnKeyLookup);
                    Object value = ((Group)cell.getValue()).getOne(lookup);
                    results.put(rowKey, columnKey, value);
                }
                return results;
            }
        };
    }

    public <C extends Comparable<? super C>, V> ResultTransformer<TreeBasedTable<K, C, V>> asSortedTable(Expression<C> column, Expression<V> expression) {
        final Expression columnKeyLookup = this.getLookup(column);
        final Expression lookup = this.getLookup(expression);
        return new GroupByTable<K, C, V, TreeBasedTable<K, C, V>>(this.key, column, new Expression[]{expression}){

            @Override
            protected TreeBasedTable<K, C, V> transform(Table<K, ?, Group> groups) {
                TreeBasedTable results = TreeBasedTable.create();
                for (Table.Cell cell : groups.cellSet()) {
                    Object rowKey = cell.getRowKey();
                    Comparable columnKey = (Comparable)((Group)cell.getValue()).getOne(columnKeyLookup);
                    Object value = ((Group)cell.getValue()).getOne(lookup);
                    results.put(rowKey, (Object)columnKey, value);
                }
                return results;
            }
        };
    }

    public <C, V> ResultTransformer<TreeBasedTable<K, C, V>> asSortedTable(Expression<C> column, Expression<V> expression, final Comparator<? super K> rowComparator, final Comparator<? super C> columnComparator) {
        final Expression columnKeyLookup = this.getLookup(column);
        final Expression lookup = this.getLookup(expression);
        return new GroupByTable<K, C, V, TreeBasedTable<K, C, V>>(this.key, column, new Expression[]{expression}){

            @Override
            protected TreeBasedTable<K, C, V> transform(Table<K, ?, Group> groups) {
                TreeBasedTable results = TreeBasedTable.create((Comparator)rowComparator, (Comparator)columnComparator);
                for (Table.Cell cell : groups.cellSet()) {
                    Object rowKey = cell.getRowKey();
                    Object columnKey = ((Group)cell.getValue()).getOne(columnKeyLookup);
                    Object value = ((Group)cell.getValue()).getOne(lookup);
                    results.put(rowKey, columnKey, value);
                }
                return results;
            }
        };
    }
}

