/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.jdo;

import com.querydsl.core.QueryFactory;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.jdo.JDOQuery;
import com.querydsl.jdo.dml.JDODeleteClause;
import java.util.function.Supplier;
import javax.jdo.PersistenceManager;

public class JDOQueryFactory
implements QueryFactory<JDOQuery<?>> {
    private final Supplier<PersistenceManager> persistenceManager;

    public JDOQueryFactory(Supplier<PersistenceManager> persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public JDODeleteClause delete(EntityPath<?> path) {
        return new JDODeleteClause(this.persistenceManager.get(), path);
    }

    public <T> JDOQuery<T> select(Expression<T> expr) {
        return this.query().select((Expression)expr);
    }

    public JDOQuery<Tuple> select(Expression<?> ... exprs) {
        return this.query().select((Expression[])exprs);
    }

    public <T> JDOQuery<T> selectDistinct(Expression<T> expr) {
        return (JDOQuery)this.query().select((Expression)expr).distinct();
    }

    public JDOQuery<Tuple> selectDistinct(Expression<?> ... exprs) {
        return (JDOQuery)this.query().select((Expression[])exprs).distinct();
    }

    public JDOQuery<Integer> selectZero() {
        return this.select((Expression<T>)((Expression)Expressions.ZERO));
    }

    public JDOQuery<Integer> selectOne() {
        return this.select((Expression<T>)((Expression)Expressions.ONE));
    }

    public <T> JDOQuery<T> selectFrom(EntityPath<T> expr) {
        return (JDOQuery)this.select((Expression<T>)expr).from(new EntityPath[]{expr});
    }

    public JDOQuery<?> from(EntityPath<?> from) {
        return (JDOQuery)this.query().from(new EntityPath[]{from});
    }

    public JDOQuery<?> query() {
        return new JDOQuery(this.persistenceManager.get());
    }
}

