/*
 * Copyright 2021, The Querydsl Team (http://www.querydsl.com/team)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.querydsl.kotlin.codegen

import com.querydsl.codegen.AbstractModule
import com.querydsl.codegen.EmbeddableSerializer
import com.querydsl.codegen.EntitySerializer
import com.querydsl.codegen.Extension
import com.querydsl.codegen.Filer
import com.querydsl.codegen.ProjectionSerializer
import com.querydsl.codegen.SupertypeSerializer
import com.querydsl.codegen.TypeMappings

class KotlinAptExtension : Extension {
    override fun addSupport(module: AbstractModule) {
        module.bind(EntitySerializer::class.java, KotlinEntitySerializer::class.java)
        module.bind(EmbeddableSerializer::class.java, KotlinEmbeddableSerializer::class.java)
        module.bind(SupertypeSerializer::class.java, KotlinSuperSerializer::class.java)
        module.bind(ProjectionSerializer::class.java, KotlinProjectionSerializer::class.java)
        module.bind(TypeMappings::class.java, KotlinTypeMappings::class.java)
        module.bind(Filer::class.java, KotlinFiler::class.java)
    }
}