/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.FactoryExpressionBase;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.util.ArrayUtils;
import com.querydsl.core.util.CollectionUtils;
import com.querydsl.sql.Beans;
import com.querydsl.sql.RelationalPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class QBeans
extends FactoryExpressionBase<Beans> {
    private static final long serialVersionUID = -4411839816134215923L;
    private final Map<RelationalPath<?>, QBean<?>> qBeans;
    private final List<Expression<?>> expressions;

    public QBeans(RelationalPath<?> ... beanPaths) {
        super(Beans.class);
        try {
            ArrayList listBuilder = new ArrayList();
            HashMap mapBuilder = new HashMap();
            for (RelationalPath<?> path : beanPaths) {
                LinkedHashMap bindings = new LinkedHashMap();
                for (Path<?> column : path.getColumns()) {
                    bindings.put(column.getMetadata().getName(), column);
                    listBuilder.add(column);
                }
                mapBuilder.put(path, Projections.bean((Class)path.getType(), bindings));
            }
            this.expressions = CollectionUtils.unmodifiableList(listBuilder);
            this.qBeans = Collections.unmodifiableMap(mapBuilder);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public <R, C> R accept(Visitor<R, C> v, C context) {
        return (R)v.visit((FactoryExpression)this, context);
    }

    public List<Expression<?>> getArgs() {
        return this.expressions;
    }

    public Beans newInstance(Object ... args) {
        int offset = 0;
        HashMap beans = new HashMap();
        for (Map.Entry<RelationalPath<?>, QBean<?>> entry : this.qBeans.entrySet()) {
            RelationalPath<?> path = entry.getKey();
            QBean<?> qBean = entry.getValue();
            int argsSize = qBean.getArgs().size();
            Object[] subArgs = ArrayUtils.subarray((Object[])args, (int)offset, (int)(offset + argsSize));
            beans.put(path, qBean.newInstance(subArgs));
            offset += argsSize;
        }
        return new Beans(beans);
    }
}

