/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client.impl;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.MessageProperties;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.client.UnexpectedMethodError;
import com.rabbitmq.client.impl.AMQChannel;
import com.rabbitmq.client.impl.AMQCommand;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.AMQImpl;
import com.rabbitmq.client.impl.Method;
import com.rabbitmq.utility.Utility;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelN
extends AMQChannel
implements Channel {
    private static final String UNSPECIFIED_OUT_OF_BAND = "";
    @Deprecated
    private static final int TICKET = 1;
    public final Map<String, Consumer> _consumers = Collections.synchronizedMap(new HashMap());
    public volatile ReturnListener returnListener = null;
    public volatile FlowListener flowListener = null;
    public volatile Consumer defaultConsumer = null;

    public ChannelN(AMQConnection connection, int channelNumber) {
        super(connection, channelNumber);
    }

    public void open() throws IOException {
        AMQImpl.Channel.OpenOk openOk = (AMQImpl.Channel.OpenOk)this.exnWrappingRpc(new AMQImpl.Channel.Open(UNSPECIFIED_OUT_OF_BAND)).getMethod();
        Utility.use(openOk);
    }

    @Override
    public ReturnListener getReturnListener() {
        return this.returnListener;
    }

    @Override
    public void setReturnListener(ReturnListener listener) {
        this.returnListener = listener;
    }

    @Override
    public FlowListener getFlowListener() {
        return this.flowListener;
    }

    @Override
    public void setFlowListener(FlowListener listener) {
        this.flowListener = listener;
    }

    @Override
    public Consumer getDefaultConsumer() {
        return this.defaultConsumer;
    }

    @Override
    public void setDefaultConsumer(Consumer consumer) {
        this.defaultConsumer = consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastShutdownSignal(ShutdownSignalException signal) {
        HashMap<String, Consumer> snapshotConsumers;
        Map<String, Consumer> map = this._consumers;
        synchronized (map) {
            snapshotConsumers = new HashMap<String, Consumer>(this._consumers);
        }
        for (Map.Entry entry : snapshotConsumers.entrySet()) {
            Consumer callback = (Consumer)entry.getValue();
            try {
                callback.handleShutdownSignal((String)entry.getKey(), signal);
            }
            catch (Throwable ex) {
                this._connection.getExceptionHandler().handleConsumerException(this, ex, callback, (String)entry.getKey(), "handleShutdownSignal");
            }
        }
    }

    @Override
    public void processShutdownSignal(ShutdownSignalException signal, boolean ignoreClosed, boolean notifyRpc) {
        super.processShutdownSignal(signal, ignoreClosed, notifyRpc);
        this.broadcastShutdownSignal(signal);
    }

    public void releaseChannelNumber() {
        this._connection.disconnectChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processAsync(Command command) throws IOException {
        Method method = command.getMethod();
        if (this.isOpen()) {
            if (method instanceof AMQImpl.Channel.Close) {
                this.releaseChannelNumber();
                ShutdownSignalException signal = new ShutdownSignalException(false, false, command, this);
                Object object = this._channelMutex;
                synchronized (object) {
                    try {
                        this.processShutdownSignal(signal, true, false);
                        this.quiescingTransmit(new AMQImpl.Channel.CloseOk());
                    }
                    finally {
                        this.notifyOutstandingRpc(signal);
                    }
                }
                this.notifyListeners();
                return true;
            }
            if (method instanceof AMQImpl.Basic.Deliver) {
                AMQImpl.Basic.Deliver m = (AMQImpl.Basic.Deliver)method;
                Consumer callback = this._consumers.get(m.consumerTag);
                if (callback == null) {
                    if (this.defaultConsumer == null) {
                        throw new IllegalStateException("Unsolicited delivery - see Channel.setDefaultConsumer to handle this case.");
                    }
                    callback = this.defaultConsumer;
                }
                Envelope envelope = new Envelope(m.deliveryTag, m.redelivered, m.exchange, m.routingKey);
                try {
                    callback.handleDelivery(m.consumerTag, envelope, (AMQP.BasicProperties)command.getContentHeader(), command.getContentBody());
                }
                catch (Throwable ex) {
                    this._connection.getExceptionHandler().handleConsumerException(this, ex, callback, m.consumerTag, "handleDelivery");
                }
                return true;
            }
            if (method instanceof AMQImpl.Basic.Return) {
                ReturnListener l = this.getReturnListener();
                if (l != null) {
                    AMQImpl.Basic.Return basicReturn = (AMQImpl.Basic.Return)method;
                    try {
                        l.handleBasicReturn(basicReturn.replyCode, basicReturn.replyText, basicReturn.exchange, basicReturn.routingKey, (AMQP.BasicProperties)command.getContentHeader(), command.getContentBody());
                    }
                    catch (Throwable ex) {
                        this._connection.getExceptionHandler().handleReturnListenerException(this, ex);
                    }
                }
                return true;
            }
            if (method instanceof AMQImpl.Channel.Flow) {
                AMQImpl.Channel.Flow channelFlow = (AMQImpl.Channel.Flow)method;
                Object basicReturn = this._channelMutex;
                synchronized (basicReturn) {
                    this._blockContent = !channelFlow.active;
                    this.transmit(new AMQImpl.Channel.FlowOk(channelFlow.active));
                    this._channelMutex.notifyAll();
                }
                FlowListener l = this.getFlowListener();
                if (l != null) {
                    try {
                        l.handleFlow(channelFlow.active);
                    }
                    catch (Throwable ex) {
                        this._connection.getExceptionHandler().handleFlowListenerException(this, ex);
                    }
                }
                return true;
            }
            if (method instanceof AMQImpl.Basic.RecoverOk) {
                for (Consumer callback : this._consumers.values()) {
                    callback.handleRecoverOk();
                }
                return false;
            }
            return false;
        }
        if (method instanceof AMQImpl.Channel.Close) {
            Object object = this._channelMutex;
            synchronized (object) {
                this.quiescingTransmit(new AMQImpl.Channel.CloseOk());
            }
            return true;
        }
        return !(method instanceof AMQImpl.Channel.CloseOk);
    }

    @Override
    public void close() throws IOException {
        this.close(200, "OK");
    }

    @Override
    public void close(int closeCode, String closeMessage) throws IOException {
        this.close(closeCode, closeMessage, true, null, false);
    }

    @Override
    public void abort() throws IOException {
        this.abort(200, "OK");
    }

    @Override
    public void abort(int closeCode, String closeMessage) throws IOException {
        this.close(closeCode, closeMessage, true, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int closeCode, String closeMessage, boolean initiatedByApplication, Throwable cause, boolean abort) throws IOException {
        AMQImpl.Channel.Close reason = new AMQImpl.Channel.Close(closeCode, closeMessage, 0, 0);
        ShutdownSignalException signal = new ShutdownSignalException(false, initiatedByApplication, reason, this);
        if (cause != null) {
            signal.initCause(cause);
        }
        AMQChannel.SimpleBlockingRpcContinuation k = new AMQChannel.SimpleBlockingRpcContinuation();
        boolean notify = false;
        try {
            Object object = this._channelMutex;
            synchronized (object) {
                this.processShutdownSignal(signal, !initiatedByApplication, true);
                this.quiescingRpc(reason, k);
            }
            notify = true;
            k.getReply(-1);
        }
        catch (TimeoutException ise) {
        }
        catch (ShutdownSignalException sse) {
            if (!abort) {
                throw sse;
            }
        }
        catch (IOException ioe) {
            if (!abort) {
                throw ioe;
            }
        }
        finally {
            if (abort || notify) {
                this.releaseChannelNumber();
                this.notifyListeners();
            }
        }
    }

    @Override
    public void basicQos(int prefetchSize, int prefetchCount, boolean global) throws IOException {
        this.exnWrappingRpc(new AMQImpl.Basic.Qos(prefetchSize, prefetchCount, global));
    }

    @Override
    public void basicQos(int prefetchCount) throws IOException {
        this.basicQos(0, prefetchCount, false);
    }

    @Override
    public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
        this.basicPublish(exchange, routingKey, false, false, props, body);
    }

    @Override
    public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
        AMQP.BasicProperties useProps = props;
        if (props == null) {
            useProps = MessageProperties.MINIMAL_BASIC;
        }
        this.transmit(new AMQCommand(new AMQImpl.Basic.Publish(1, exchange, routingKey, mandatory, immediate), useProps, body));
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Exchange.DeclareOk)this.exnWrappingRpc(new AMQImpl.Exchange.Declare(1, exchange, type, false, durable, autoDelete, false, false, arguments)).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
        return this.exchangeDeclare(exchange, type, durable, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
        return this.exchangeDeclare(exchange, type, false, false, (Map)null);
    }

    @Override
    public AMQImpl.Exchange.DeclareOk exchangeDeclarePassive(String exchange) throws IOException {
        return (AMQImpl.Exchange.DeclareOk)this.exnWrappingRpc(new AMQImpl.Exchange.Declare(1, exchange, UNSPECIFIED_OUT_OF_BAND, true, false, false, false, false, null)).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) throws IOException {
        return (AMQImpl.Exchange.DeleteOk)this.exnWrappingRpc(new AMQImpl.Exchange.Delete(1, exchange, ifUnused, false)).getMethod();
    }

    @Override
    public AMQImpl.Exchange.DeleteOk exchangeDelete(String exchange) throws IOException {
        return this.exchangeDelete(exchange, false);
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Queue.DeclareOk)this.exnWrappingRpc(new AMQImpl.Queue.Declare(1, queue, false, durable, exclusive, autoDelete, false, arguments)).getMethod();
    }

    @Override
    public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
        return this.queueDeclare(UNSPECIFIED_OUT_OF_BAND, false, true, true, (Map)null);
    }

    @Override
    public AMQImpl.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
        return (AMQImpl.Queue.DeclareOk)this.exnWrappingRpc(new AMQImpl.Queue.Declare(1, queue, true, false, true, true, false, null)).getMethod();
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
        return (AMQImpl.Queue.DeleteOk)this.exnWrappingRpc(new AMQImpl.Queue.Delete(1, queue, ifUnused, ifEmpty, false)).getMethod();
    }

    @Override
    public AMQImpl.Queue.DeleteOk queueDelete(String queue) throws IOException {
        return this.queueDelete(queue, false, false);
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Queue.BindOk)this.exnWrappingRpc(new AMQImpl.Queue.Bind(1, queue, exchange, routingKey, false, arguments)).getMethod();
    }

    @Override
    public AMQImpl.Queue.BindOk queueBind(String queue, String exchange, String routingKey) throws IOException {
        return this.queueBind(queue, exchange, routingKey, (Map)null);
    }

    @Override
    public AMQImpl.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
        return (AMQImpl.Queue.UnbindOk)this.exnWrappingRpc(new AMQImpl.Queue.Unbind(1, queue, exchange, routingKey, arguments)).getMethod();
    }

    @Override
    public AMQImpl.Queue.PurgeOk queuePurge(String queue) throws IOException {
        return this.queuePurge(queue, false);
    }

    @Override
    public AMQImpl.Queue.PurgeOk queuePurge(String queue, boolean nowait) throws IOException {
        return (AMQImpl.Queue.PurgeOk)this.exnWrappingRpc(new AMQImpl.Queue.Purge(1, queue, nowait)).getMethod();
    }

    @Override
    public AMQImpl.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) throws IOException {
        return this.queueUnbind(queue, exchange, routingKey, (Map)null);
    }

    @Override
    public GetResponse basicGet(String queue, boolean noAck) throws IOException {
        AMQCommand replyCommand = this.exnWrappingRpc(new AMQImpl.Basic.Get(1, queue, noAck));
        Method method = replyCommand.getMethod();
        if (method instanceof AMQImpl.Basic.GetOk) {
            AMQImpl.Basic.GetOk getOk = (AMQImpl.Basic.GetOk)method;
            Envelope envelope = new Envelope(getOk.deliveryTag, getOk.redelivered, getOk.exchange, getOk.routingKey);
            AMQP.BasicProperties props = (AMQP.BasicProperties)replyCommand.getContentHeader();
            byte[] body = replyCommand.getContentBody();
            int messageCount = getOk.messageCount;
            return new GetResponse(envelope, props, body, messageCount);
        }
        if (method instanceof AMQImpl.Basic.GetEmpty) {
            return null;
        }
        throw new UnexpectedMethodError(method);
    }

    @Override
    public void basicAck(long deliveryTag, boolean multiple) throws IOException {
        this.transmit(new AMQImpl.Basic.Ack(deliveryTag, multiple));
    }

    @Override
    public String basicConsume(String queue, Consumer callback) throws IOException {
        return this.basicConsume(queue, false, callback);
    }

    @Override
    public String basicConsume(String queue, boolean noAck, Consumer callback) throws IOException {
        return this.basicConsume(queue, noAck, UNSPECIFIED_OUT_OF_BAND, callback);
    }

    @Override
    public String basicConsume(String queue, boolean noAck, String consumerTag, Consumer callback) throws IOException {
        return this.basicConsume(queue, noAck, consumerTag, false, false, callback);
    }

    @Override
    public String basicConsume(String queue, boolean noAck, String consumerTag, boolean noLocal, boolean exclusive, final Consumer callback) throws IOException {
        AMQChannel.BlockingRpcContinuation<String> k = new AMQChannel.BlockingRpcContinuation<String>(){

            @Override
            public String transformReply(AMQCommand replyCommand) {
                String actualConsumerTag = ((AMQImpl.Basic.ConsumeOk)replyCommand.getMethod()).consumerTag;
                ChannelN.this._consumers.put(actualConsumerTag, callback);
                try {
                    callback.handleConsumeOk(actualConsumerTag);
                }
                catch (Throwable ex) {
                    ChannelN.this._connection.getExceptionHandler().handleConsumerException(ChannelN.this, ex, callback, actualConsumerTag, "handleConsumeOk");
                }
                return actualConsumerTag;
            }
        };
        this.rpc(new AMQImpl.Basic.Consume(1, queue, consumerTag, noLocal, noAck, exclusive, false), k);
        try {
            return (String)k.getReply();
        }
        catch (ShutdownSignalException ex) {
            throw ChannelN.wrap(ex);
        }
    }

    @Override
    public void basicCancel(final String consumerTag) throws IOException {
        AMQChannel.BlockingRpcContinuation<Consumer> k = new AMQChannel.BlockingRpcContinuation<Consumer>(){

            @Override
            public Consumer transformReply(AMQCommand replyCommand) {
                AMQImpl.Basic.CancelOk dummy = (AMQImpl.Basic.CancelOk)replyCommand.getMethod();
                Utility.use(dummy);
                Consumer callback = ChannelN.this._consumers.remove(consumerTag);
                try {
                    callback.handleCancelOk(consumerTag);
                }
                catch (Throwable ex) {
                    ChannelN.this._connection.getExceptionHandler().handleConsumerException(ChannelN.this, ex, callback, consumerTag, "handleCancelOk");
                }
                return callback;
            }
        };
        this.rpc(new AMQImpl.Basic.Cancel(consumerTag, false), k);
        try {
            Consumer callback = (Consumer)k.getReply();
            Utility.use(callback);
        }
        catch (ShutdownSignalException ex) {
            throw ChannelN.wrap(ex);
        }
    }

    @Override
    public AMQImpl.Basic.RecoverOk basicRecover(boolean requeue) throws IOException {
        return (AMQImpl.Basic.RecoverOk)this.exnWrappingRpc(new AMQImpl.Basic.Recover(requeue)).getMethod();
    }

    @Override
    public void basicRecoverAsync(boolean requeue) throws IOException {
        this.transmit(new AMQImpl.Basic.RecoverAsync(requeue));
    }

    @Override
    public AMQImpl.Tx.SelectOk txSelect() throws IOException {
        return (AMQImpl.Tx.SelectOk)this.exnWrappingRpc(new AMQImpl.Tx.Select()).getMethod();
    }

    @Override
    public AMQImpl.Tx.CommitOk txCommit() throws IOException {
        return (AMQImpl.Tx.CommitOk)this.exnWrappingRpc(new AMQImpl.Tx.Commit()).getMethod();
    }

    @Override
    public AMQImpl.Tx.RollbackOk txRollback() throws IOException {
        return (AMQImpl.Tx.RollbackOk)this.exnWrappingRpc(new AMQImpl.Tx.Rollback()).getMethod();
    }

    @Override
    public AMQImpl.Channel.FlowOk flow(final boolean a) throws IOException {
        return (AMQImpl.Channel.FlowOk)this.exnWrappingRpc(new AMQImpl.Channel.Flow(){
            {
                this.active = a;
            }
        }).getMethod();
    }

    @Override
    public AMQImpl.Channel.FlowOk getFlow() {
        return new AMQImpl.Channel.FlowOk(!this._blockContent);
    }
}

