/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.perf;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import com.rabbitmq.stream.perf.PerformanceMetrics;
import com.rabbitmq.stream.perf.Utils;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.HistogramSupport;
import io.micrometer.core.instrument.distribution.ValueAtPercentile;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultPerformanceMetrics
implements PerformanceMetrics {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPerformanceMetrics.class);
    private final String metricsPrefix;
    private final CompositeMeterRegistry meterRegistry;
    private final Timer latency;
    private final Timer confirmLatency;
    private final boolean summaryFile;
    private final PrintWriter out;
    private final boolean includeByteRates;
    private final Supplier<String> memoryReportSupplier;
    private volatile Closeable closingSequence = () -> {};
    private volatile long lastPublishedCount = 0L;
    private volatile long lastConsumedCount = 0L;
    private volatile long offset;

    DefaultPerformanceMetrics(CompositeMeterRegistry meterRegistry, String metricsPrefix, boolean summaryFile, boolean includeByteRates, boolean confirmLatency, Supplier<String> memoryReportSupplier, PrintWriter out) {
        this.summaryFile = summaryFile;
        this.includeByteRates = includeByteRates;
        this.memoryReportSupplier = memoryReportSupplier;
        this.out = out;
        this.metricsPrefix = metricsPrefix;
        this.meterRegistry = meterRegistry;
        this.latency = Timer.builder((String)(metricsPrefix + ".latency")).description("message latency").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).distributionStatisticExpiry(Duration.ofSeconds(1L)).serviceLevelObjectives(new Duration[0]).register((MeterRegistry)meterRegistry);
        this.confirmLatency = confirmLatency ? Timer.builder((String)(metricsPrefix + ".confirm_latency")).description("publish confirm latency").publishPercentiles(new double[]{0.5, 0.75, 0.95, 0.99}).distributionStatisticExpiry(Duration.ofSeconds(1L)).serviceLevelObjectives(new Duration[0]).register((MeterRegistry)meterRegistry) : null;
    }

    private long getPublishedCount() {
        return (long)this.meterRegistry.get(this.metricsName("published")).counter().count();
    }

    private long getConsumedCount() {
        return (long)this.meterRegistry.get(this.metricsName("consumed")).counter().count();
    }

    @Override
    public void start(String description) throws Exception {
        long startTime = System.nanoTime();
        String metricPublished = this.metricsName("published");
        String metricProducerConfirmed = this.metricsName("confirmed");
        String metricConsumed = this.metricsName("consumed");
        String metricChunkSize = this.metricsName("chunk_size");
        String metricLatency = this.metricsName("latency");
        String metricConfirmLatency = this.metricsName("confirm_latency");
        String metricWrittenBytes = this.metricsName("written_bytes");
        String metricReadBytes = this.metricsName("read_bytes");
        HashSet<String> allMetrics = new HashSet<String>(Arrays.asList(metricPublished, metricProducerConfirmed, metricConsumed, metricChunkSize, metricLatency));
        if (this.confirmLatency()) {
            allMetrics.add(metricConfirmLatency);
        }
        LinkedHashMap<String, String> countersNamesAndLabels = new LinkedHashMap<String, String>();
        countersNamesAndLabels.put(metricPublished, "published");
        countersNamesAndLabels.put(metricProducerConfirmed, "confirmed");
        countersNamesAndLabels.put(metricConsumed, "consumed");
        if (this.includeByteRates) {
            allMetrics.add(metricWrittenBytes);
            allMetrics.add(metricReadBytes);
            countersNamesAndLabels.put(metricWrittenBytes, "written bytes");
            countersNamesAndLabels.put(metricReadBytes, "read bytes");
        }
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Closeable summaryFileClosingSequence = this.maybeSetSummaryFile(description, allMetrics, scheduledExecutorService);
        LinkedHashMap counters = new LinkedHashMap(countersNamesAndLabels.size());
        countersNamesAndLabels.entrySet().forEach(entry -> counters.put(entry.getValue(), this.meterRegistry.get((String)entry.getKey()).counter()));
        HashMap formatCounter = new HashMap();
        countersNamesAndLabels.entrySet().stream().filter(entry -> !((String)entry.getKey()).contains("bytes")).forEach(entry -> formatCounter.put(entry.getValue(), (lastValue, currentValue, duration) -> {
            long rate = 1000L * (currentValue - lastValue) / duration.toMillis();
            return String.format("%s %d msg/s, ", entry.getValue(), rate);
        }));
        countersNamesAndLabels.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains("bytes")).forEach(entry -> formatCounter.put(entry.getValue(), (lastValue, currentValue, duration) -> {
            long rate = 1000L * (currentValue - lastValue) / duration.toMillis();
            return DefaultPerformanceMetrics.formatByteRate((String)entry.getValue(), rate) + ", ";
        }));
        DistributionSummary chunkSize = this.meterRegistry.get(metricChunkSize).summary();
        Function<HistogramSupport, String> formatChunkSize = histogram -> String.format("chunk size %.0f", histogram.takeSnapshot().mean());
        Function<Number, Number> convertDuration = in -> in instanceof Long ? (double)(in.longValue() / 1000000L) : in.doubleValue() / 1000000.0;
        BiFunction<String, Timer, String> formatLatency = (name, timer) -> {
            HistogramSnapshot snapshot = timer.takeSnapshot();
            return String.format(name + " median/75th/95th/99th %.0f/%.0f/%.0f/%.0f ms", convertDuration.apply(DefaultPerformanceMetrics.percentile(snapshot, 0.5).value()), convertDuration.apply(DefaultPerformanceMetrics.percentile(snapshot, 0.75).value()), convertDuration.apply(DefaultPerformanceMetrics.percentile(snapshot, 0.95).value()), convertDuration.apply(DefaultPerformanceMetrics.percentile(snapshot, 0.99).value()));
        };
        AtomicInteger reportCount = new AtomicInteger(1);
        AtomicLong lastTick = new AtomicLong(startTime);
        ConcurrentHashMap lastMetersValues = new ConcurrentHashMap(counters.size());
        counters.entrySet().forEach(e -> lastMetersValues.put(e.getKey(), (long)((Counter)e.getValue()).count()));
        ScheduledFuture<?> consoleReportingTask = scheduledExecutorService.scheduleAtFixedRate(() -> this.lambda$start$13(lastTick, reportCount, counters, lastMetersValues, formatCounter, formatLatency, formatChunkSize, (HistogramSupport)chunkSize), 1L, 1L, TimeUnit.SECONDS);
        this.closingSequence = () -> this.lambda$start$17(consoleReportingTask, summaryFileClosingSequence, scheduledExecutorService, startTime, convertDuration, counters, formatChunkSize, (HistogramSupport)chunkSize);
    }

    static String formatByteRate(String label, double bytes) {
        if (-1000.0 < bytes && bytes < 1000.0) {
            return bytes + " B/s";
        }
        StringCharacterIterator ci = new StringCharacterIterator("kMGTPE");
        while (bytes <= -999950.0 || bytes >= 999950.0) {
            bytes /= 1000.0;
            ci.next();
        }
        return String.format("%s %.1f %cB/s", label, bytes / 1000.0, Character.valueOf(ci.current()));
    }

    private Closeable maybeSetSummaryFile(String description, Set<String> allMetrics, ScheduledExecutorService scheduledExecutorService) throws IOException {
        Closeable summaryFileClosingSequence;
        if (this.summaryFile) {
            String currentFilename = "stream-perf-test-current.txt";
            String finalFilename = "stream-perf-test-" + new SimpleDateFormat("yyyy-MM-dd-HHmmss").format(new Date()) + ".txt";
            Path currentFile = Paths.get(currentFilename, new String[0]);
            if (Files.exists(currentFile, new LinkOption[0]) && !Files.deleteIfExists(Paths.get(currentFilename, new String[0]))) {
                LOGGER.warn("Could not delete file {}", (Object)currentFilename);
            }
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(currentFilename));
            PrintStream printStream = new PrintStream(outputStream);
            if (description != null && !description.trim().isEmpty()) {
                printStream.println(description);
            }
            DropwizardMeterRegistry dropwizardMeterRegistry = this.meterRegistry.getRegistries().stream().filter(r -> r instanceof DropwizardMeterRegistry).map(r -> (DropwizardMeterRegistry)r).findAny().orElseGet(() -> Utils.dropwizardMeterRegistry());
            if (!this.meterRegistry.getRegistries().contains(dropwizardMeterRegistry)) {
                this.meterRegistry.add((MeterRegistry)dropwizardMeterRegistry);
            }
            ConsoleReporter fileReporter = ConsoleReporter.forRegistry((MetricRegistry)dropwizardMeterRegistry.getDropwizardRegistry()).filter((name, metric) -> allMetrics.contains(name)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).outputTo(printStream).scheduleOn(scheduledExecutorService).shutdownExecutorOnStop(false).build();
            fileReporter.start(1L, TimeUnit.SECONDS);
            summaryFileClosingSequence = () -> {
                fileReporter.stop();
                printStream.close();
                Files.move(currentFile, currentFile.resolveSibling(finalFilename), new CopyOption[0]);
            };
        } else {
            summaryFileClosingSequence = () -> {};
        }
        return summaryFileClosingSequence;
    }

    boolean checkActivity() {
        long currentPublishedCount = this.getPublishedCount();
        long currentConsumedCount = this.getConsumedCount();
        boolean activity = this.lastPublishedCount != currentPublishedCount || this.lastConsumedCount != currentConsumedCount;
        LOGGER.debug("Activity check: published {} vs {}, consumed {} vs {}, activity {}, offset {}", new Object[]{this.lastPublishedCount, currentPublishedCount, this.lastConsumedCount, currentConsumedCount, activity, this.offset});
        if (activity) {
            this.lastPublishedCount = currentPublishedCount;
            this.lastConsumedCount = currentConsumedCount;
        }
        return activity;
    }

    @Override
    public void latency(long latency, TimeUnit unit) {
        this.latency.record(latency, unit);
    }

    @Override
    public void confirmLatency(long latency, TimeUnit unit) {
        this.confirmLatency.record(latency, unit);
    }

    @Override
    public void offset(long offset) {
        this.offset = offset;
    }

    @Override
    public void close() throws Exception {
        this.closingSequence.close();
    }

    private boolean confirmLatency() {
        return this.confirmLatency != null;
    }

    private String metricsName(String name) {
        return this.metricsPrefix + "." + name;
    }

    private static ValueAtPercentile percentile(HistogramSnapshot snapshot, double expected) {
        for (ValueAtPercentile percentile : snapshot.percentileValues()) {
            if (percentile.percentile() != expected) continue;
            return percentile;
        }
        return null;
    }

    private /* synthetic */ void lambda$start$17(ScheduledFuture consoleReportingTask, Closeable summaryFileClosingSequence, ScheduledExecutorService scheduledExecutorService, long startTime, Function convertDuration, Map counters, Function formatChunkSize, HistogramSupport chunkSize) throws IOException {
        consoleReportingTask.cancel(true);
        summaryFileClosingSequence.close();
        scheduledExecutorService.shutdownNow();
        Duration d = Duration.ofNanos(System.nanoTime() - startTime);
        Duration duration = d.getSeconds() <= 0L ? Duration.ofSeconds(1L) : d;
        Function<Map.Entry, String> formatMeterSummary = entry -> {
            if (((String)entry.getKey()).contains("bytes")) {
                return DefaultPerformanceMetrics.formatByteRate((String)entry.getKey(), 1000L * (long)((Counter)entry.getValue()).count() / duration.toMillis()) + ", ";
            }
            return String.format("%s %d msg/s, ", entry.getKey(), 1000L * (long)((Counter)entry.getValue()).count() / duration.toMillis());
        };
        BiFunction<String, HistogramSupport, String> formatLatencySummary = (name, histogram) -> String.format(name + " 95th %.0f ms", convertDuration.apply(DefaultPerformanceMetrics.percentile(histogram.takeSnapshot(), 0.95).value()));
        StringBuilder builder = new StringBuilder("Summary: ");
        counters.entrySet().forEach(entry -> builder.append((String)formatMeterSummary.apply((Map.Entry)entry)));
        if (this.confirmLatency()) {
            builder.append(formatLatencySummary.apply("confirm latency", (HistogramSupport)this.confirmLatency)).append(", ");
        }
        builder.append(formatLatencySummary.apply("latency", (HistogramSupport)this.latency)).append(", ");
        builder.append((String)formatChunkSize.apply(chunkSize));
        this.out.println();
        this.out.println(builder);
    }

    private /* synthetic */ void lambda$start$13(AtomicLong lastTick, AtomicInteger reportCount, Map counters, Map lastMetersValues, Map formatCounter, BiFunction formatLatency, Function formatChunkSize, HistogramSupport chunkSize) {
        try {
            if (this.checkActivity()) {
                long currentTime = System.nanoTime();
                Duration duration = Duration.ofNanos(currentTime - lastTick.get());
                lastTick.set(currentTime);
                StringBuilder builder = new StringBuilder();
                builder.append(reportCount.get()).append(", ");
                counters.entrySet().forEach(entry -> {
                    String meterName = (String)entry.getKey();
                    Counter counter = (Counter)entry.getValue();
                    long lastValue = (Long)lastMetersValues.get(meterName);
                    long currentValue = (long)counter.count();
                    builder.append(((FormatCallback)formatCounter.get(meterName)).compute(lastValue, currentValue, duration));
                    lastMetersValues.put(meterName, currentValue);
                });
                if (this.confirmLatency()) {
                    builder.append((String)formatLatency.apply("confirm latency", this.confirmLatency)).append(", ");
                }
                builder.append((String)formatLatency.apply("latency", this.latency)).append(", ");
                builder.append((String)formatChunkSize.apply(chunkSize));
                this.out.println(builder);
                String memoryReport = this.memoryReportSupplier.get();
                if (!memoryReport.isEmpty()) {
                    this.out.println(memoryReport);
                }
            }
            reportCount.incrementAndGet();
        }
        catch (Exception e) {
            LOGGER.warn("Error while computing metrics report: {}", (Object)e.getMessage());
        }
    }

    private static interface FormatCallback {
        public String compute(long var1, long var3, Duration var5);
    }
}

