/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.EqualityHelper;
import org.apache.xerces.impl.validation.ValidationManager;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.ElementPSVImpl;
import org.apache.xerces.impl.xs.IDContext;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSDAssertionValidator;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.impl.xs.XSDTypeAlternativeValidator;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSElementDeclHelper;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSValidationState;
import org.apache.xerces.impl.xs.identity.Field;
import org.apache.xerces.impl.xs.identity.FieldActivator;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.KeyRef;
import org.apache.xerces.impl.xs.identity.Selector;
import org.apache.xerces.impl.xs.identity.UniqueOrKey;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.CMNodeFactory;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.URI;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSTypeAlternative;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.datatypes.ObjectList;

public class SchemaValidatorHelper
implements XSElementDeclHelper,
FieldActivator {
    protected static final boolean DEBUG = false;
    protected static final String VALIDATION = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NORMALIZE_DATA = "http://apache.org/xml/features/validation/schema/normalized-value";
    protected static final String SCHEMA_ELEMENT_DEFAULT = "http://apache.org/xml/features/validation/schema/element-default";
    protected static final String SCHEMA_AUGMENT_PSVI = "http://apache.org/xml/features/validation/schema/augment-psvi";
    protected static final String ALLOW_JAVA_ENCODINGS = "http://apache.org/xml/features/allow-java-encodings";
    protected static final String STANDARD_URI_CONFORMANT_FEATURE = "http://apache.org/xml/features/standard-uri-conformant";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String VALIDATE_ANNOTATIONS = "http://apache.org/xml/features/validate-annotations";
    protected static final String HONOUR_ALL_SCHEMALOCATIONS = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String USE_GRAMMAR_POOL_ONLY = "http://apache.org/xml/features/internal/validation/schema/use-grammar-pool-only";
    protected static final String CONTINUE_AFTER_FATAL_ERROR = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected static final String NAMESPACE_GROWTH = "http://apache.org/xml/features/namespace-growth";
    protected static final String TOLERATE_DUPLICATES = "http://apache.org/xml/features/internal/tolerate-duplicates";
    protected static final String IGNORE_XSI_TYPE = "http://apache.org/xml/features/validation/schema/ignore-xsi-type-until-elemdecl";
    protected static final String ID_IDREF_CHECKING = "http://apache.org/xml/features/validation/id-idref-checking";
    protected static final String UNPARSED_ENTITY_CHECKING = "http://apache.org/xml/features/validation/unparsed-entity-checking";
    protected static final String IDENTITY_CONSTRAINT_CHECKING = "http://apache.org/xml/features/validation/identity-constraint-checking";
    protected static final String TYPE_ALTERNATIVES_CHECKING = "http://apache.org/xml/features/validation/type-alternative-checking";
    protected static final String ASSERT_COMMENT_PI_CHECKING = "http://apache.org/xml/features/validation/assert-comments-and-pi-checking";
    public static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    public static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    public static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    public static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    protected static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    protected static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    protected static final String SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    protected static final String SCHEMA_NONS_LOCATION = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    protected static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    protected static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    protected static final String ROOT_TYPE_DEF = "http://apache.org/xml/properties/validation/schema/root-type-definition";
    protected static final String ROOT_ELEMENT_DECL = "http://apache.org/xml/properties/validation/schema/root-element-declaration";
    protected static final String SCHEMA_DV_FACTORY = "http://apache.org/xml/properties/internal/validation/schema/dv-factory";
    protected static final String XML_SCHEMA_VERSION = "http://apache.org/xml/properties/validation/schema/version";
    protected static final String DATATYPE_XML_VERSION = "http://apache.org/xml/properties/validation/schema/datatype-xml-version";
    protected static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/validation", "http://apache.org/xml/features/validation/schema", "http://apache.org/xml/features/validation/dynamic", "http://apache.org/xml/features/validation/schema-full-checking", "http://apache.org/xml/features/allow-java-encodings", "http://apache.org/xml/features/continue-after-fatal-error", "http://apache.org/xml/features/standard-uri-conformant", "http://apache.org/xml/features/generate-synthetic-annotations", "http://apache.org/xml/features/validate-annotations", "http://apache.org/xml/features/honour-all-schemaLocations", "http://apache.org/xml/features/internal/validation/schema/use-grammar-pool-only", "http://apache.org/xml/features/validation/schema/ignore-xsi-type-until-elemdecl", "http://apache.org/xml/features/validation/id-idref-checking", "http://apache.org/xml/features/validation/identity-constraint-checking", "http://apache.org/xml/features/validation/unparsed-entity-checking", "http://apache.org/xml/features/namespace-growth", "http://apache.org/xml/features/internal/tolerate-duplicates", "http://apache.org/xml/features/validation/type-alternative-checking", "http://apache.org/xml/features/validation/assert-comments-and-pi-checking"};
    protected static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    protected static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter", "http://apache.org/xml/properties/internal/entity-resolver", "http://apache.org/xml/properties/internal/validation-manager", "http://apache.org/xml/properties/schema/external-schemaLocation", "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "http://java.sun.com/xml/jaxp/properties/schemaSource", "http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://apache.org/xml/properties/validation/schema/root-type-definition", "http://apache.org/xml/properties/validation/schema/root-element-declaration", "http://apache.org/xml/properties/internal/validation/schema/dv-factory", "http://apache.org/xml/properties/validation/schema/version", "http://apache.org/xml/properties/validation/schema/datatype-xml-version"};
    protected static final Object[] PROPERTY_DEFAULTS = new Object[]{null, null, null, null, null, null, null, null, null, null, null, null, null};
    protected static final int ID_CONSTRAINT_NUM = 1;
    static final XSAttributeDecl XSI_TYPE = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_TYPE);
    static final XSAttributeDecl XSI_NIL = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NIL);
    static final XSAttributeDecl XSI_SCHEMALOCATION = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_SCHEMALOCATION);
    static final XSAttributeDecl XSI_NONAMESPACESCHEMALOCATION = SchemaGrammar.SG_XSI.getGlobalAttributeDecl(SchemaSymbols.XSI_NONAMESPACESCHEMALOCATION);
    protected static final Hashtable EMPTY_TABLE = new Hashtable();
    protected ElementPSVImpl fCurrentPSVI = new ElementPSVImpl();
    protected final AugmentationsImpl fAugmentations = new AugmentationsImpl();
    protected XMLString fDefaultValue;
    protected boolean fDynamicValidation = false;
    protected boolean fSchemaDynamicValidation = false;
    protected boolean fDoValidation = false;
    protected boolean fFullChecking = false;
    protected boolean fNormalizeData = true;
    protected boolean fSchemaElementDefault = true;
    protected boolean fAugPSVI = true;
    protected boolean fIdConstraint = false;
    protected boolean fUseGrammarPoolOnly = false;
    protected boolean fNamespaceGrowth = false;
    protected String fSchemaType = null;
    protected boolean fEntityRef = false;
    protected boolean fInCDATA = false;
    protected SymbolTable fSymbolTable;
    protected XMLLocator fLocator;
    protected ArrayList fXSITypeErrors = new ArrayList(4);
    protected IDContext fIDContext = null;
    protected String fDatatypeXMLVersion = null;
    protected NamespaceContext fNamespaceContext = null;
    protected final XSIErrorReporter fXSIErrorReporter = new XSIErrorReporter();
    protected XMLEntityResolver fEntityResolver;
    protected ValidationManager fValidationManager = null;
    protected XSValidationState fValidationState = new XSValidationState();
    protected XMLGrammarPool fGrammarPool;
    protected String fExternalSchemas = null;
    protected String fExternalNoNamespaceSchema = null;
    protected Object fJaxpSchemaSource = null;
    protected final XSDDescription fXSDDescription = new XSDDescription();
    protected final Hashtable fLocationPairs = new Hashtable();
    protected final Hashtable fExpandedLocationPairs = new Hashtable();
    protected final ArrayList fUnparsedLocations = new ArrayList();
    short fSchemaVersion;
    XSConstraints fXSConstraints;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    static final int INITIAL_STACK_SIZE = 8;
    static final int INC_STACK_SIZE = 8;
    protected static final boolean DEBUG_NORMALIZATION = false;
    protected final XMLString fEmptyXMLStr = new XMLString(null, 0, -1);
    protected static final int BUFFER_SIZE = 20;
    protected final XMLString fNormalizedStr = new XMLString();
    protected boolean fFirstChunk = true;
    protected boolean fTrailing = false;
    protected short fWhiteSpace = (short)-1;
    protected boolean fUnionType = false;
    protected final XSGrammarBucket fGrammarBucket = new XSGrammarBucket();
    protected final SubstitutionGroupHandler fSubGroupHandler = new SubstitutionGroupHandler(this);
    protected final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.getS4SGrammar((short)1).getGlobalTypeDecl("QName");
    protected final CMNodeFactory nodeFactory = new CMNodeFactory();
    protected final CMBuilder fCMBuilder = new CMBuilder(this.nodeFactory);
    protected final XMLSchemaLoader fSchemaLoader;
    protected String fValidationRoot;
    protected int fSkipValidationDepth;
    protected int fNFullValidationDepth;
    protected int fNNoneValidationDepth;
    protected int fElementDepth;
    protected boolean fSubElement;
    protected boolean[] fSubElementStack;
    protected XSElementDecl fCurrentElemDecl;
    protected XSElementDecl[] fElemDeclStack;
    protected boolean fNil;
    protected boolean[] fNilStack;
    protected XSNotationDecl fNotation;
    protected XSNotationDecl[] fNotationStack;
    protected XSTypeDefinition fCurrentType;
    protected ObjectList fFailedAssertions;
    protected XSTypeAlternative fTypeAlternative;
    protected XSTypeDefinition[] fTypeStack;
    protected XSCMValidator fCurrentCM;
    protected XSCMValidator[] fCMStack;
    protected int[] fCurrCMState;
    protected int[][] fCMStateStack;
    protected boolean fStrictAssess;
    protected boolean[] fStrictAssessStack;
    protected final StringBuffer fBuffer;
    protected boolean fAppendBuffer;
    protected boolean fSawText;
    protected boolean[] fSawTextStack;
    protected boolean fSawCharacters;
    protected boolean[] fStringContent;
    protected final org.apache.xerces.xni.QName fTempQName;
    protected QName fRootTypeQName;
    protected XSTypeDefinition fRootTypeDefinition;
    protected QName fRootElementDeclQName;
    protected XSElementDecl fRootElementDeclaration;
    protected int fIgnoreXSITypeDepth;
    protected boolean fIDCChecking;
    protected boolean fTypeAlternativesChecking;
    protected boolean fCommentsAndPIsForAssert;
    protected ValidatedInfo fValidatedInfo;
    protected ValidationState fState4XsiType;
    protected ValidationState fState4ApplyDefault;
    protected XPathMatcherStack fMatcherStack;
    protected ValueStoreCache fValueStoreCache;
    protected XSDAssertionValidator fAssertionValidator;
    boolean fIsAssertProcessingNeededForSTUnionElem;
    List fIsAssertProcessingNeededForSTUnionAttrs;
    protected XSDTypeAlternativeValidator fTypeAlternativeValidator;
    Vector fInheritableAttrList;
    protected IntStack fInhrAttrCountStack;

    protected SchemaValidatorHelper() {
        this.fSchemaLoader = new XMLSchemaLoader(this.fXSIErrorReporter.fErrorReporter, this.fGrammarBucket, this.fSubGroupHandler, this.fCMBuilder);
        this.fSubElementStack = new boolean[8];
        this.fElemDeclStack = new XSElementDecl[8];
        this.fNilStack = new boolean[8];
        this.fNotationStack = new XSNotationDecl[8];
        this.fTypeStack = new XSTypeDefinition[8];
        this.fCMStack = new XSCMValidator[8];
        this.fCMStateStack = new int[8][];
        this.fStrictAssess = true;
        this.fStrictAssessStack = new boolean[8];
        this.fBuffer = new StringBuffer();
        this.fAppendBuffer = true;
        this.fSawText = false;
        this.fSawTextStack = new boolean[8];
        this.fSawCharacters = false;
        this.fStringContent = new boolean[8];
        this.fTempQName = new org.apache.xerces.xni.QName();
        this.fRootTypeQName = null;
        this.fRootTypeDefinition = null;
        this.fRootElementDeclQName = null;
        this.fRootElementDeclaration = null;
        this.fValidatedInfo = new ValidatedInfo();
        this.fState4XsiType = new ValidationState();
        this.fState4ApplyDefault = new ValidationState();
        this.fMatcherStack = new XPathMatcherStack();
        this.fValueStoreCache = new ValueStoreCache();
        this.fAssertionValidator = null;
        this.fIsAssertProcessingNeededForSTUnionElem = true;
        this.fIsAssertProcessingNeededForSTUnionAttrs = new ArrayList();
        this.fTypeAlternativeValidator = null;
        this.fInheritableAttrList = new Vector();
        this.fInhrAttrCountStack = new IntStack();
    }

    @Override
    public XSElementDecl getGlobalElementDecl(org.apache.xerces.xni.QName element) {
        SchemaGrammar sGrammar = this.findSchemaGrammar((short)5, element.uri, null, element, null);
        if (sGrammar != null) {
            return sGrammar.getGlobalElementDecl(element.localpart);
        }
        return null;
    }

    SchemaGrammar findSchemaGrammar(short contextType, String namespace, org.apache.xerces.xni.QName enclosingElement, org.apache.xerces.xni.QName triggeringComponent, XMLAttributes attributes) {
        SchemaGrammar grammar = null;
        grammar = this.fGrammarBucket.getGrammar(namespace);
        if (grammar == null) {
            this.fXSDDescription.setNamespace(namespace);
            if (this.fGrammarPool != null && (grammar = (SchemaGrammar)this.fGrammarPool.retrieveGrammar(this.fXSDDescription)) != null && !this.fGrammarBucket.putGrammar(grammar, true, this.fNamespaceGrowth)) {
                this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "GrammarConflict", null, (short)0);
                grammar = null;
            }
        }
        if (!this.fUseGrammarPoolOnly && (grammar == null || this.fNamespaceGrowth && !this.hasSchemaComponent(grammar, contextType, triggeringComponent))) {
            String[] temp;
            Hashtable locationPairs;
            Object locationArray;
            this.fXSDDescription.reset();
            this.fXSDDescription.fContextType = contextType;
            this.fXSDDescription.setNamespace(namespace);
            this.fXSDDescription.fEnclosedElementName = enclosingElement;
            this.fXSDDescription.fTriggeringComponent = triggeringComponent;
            this.fXSDDescription.fAttributes = attributes;
            if (this.fLocator != null) {
                this.fXSDDescription.setBaseSystemId(this.fLocator.getExpandedSystemId());
            }
            if ((locationArray = (locationPairs = this.fLocationPairs).get(namespace == null ? XMLSymbols.EMPTY_STRING : namespace)) != null && (temp = ((XMLSchemaLoader.LocationArray)locationArray).getLocationArray()).length != 0) {
                this.setLocationHints(this.fXSDDescription, temp, grammar);
            }
            if (grammar == null || this.fXSDDescription.fLocationHints != null) {
                boolean toParseSchema = true;
                if (grammar != null) {
                    locationPairs = EMPTY_TABLE;
                }
                try {
                    XMLInputSource xis = XMLSchemaLoader.resolveDocument(this.fXSDDescription, locationPairs, this.fEntityResolver);
                    if (grammar != null && this.fNamespaceGrowth) {
                        try {
                            if (grammar.getDocumentLocations().contains(XMLEntityManager.expandSystemId(xis.getSystemId(), xis.getBaseSystemId(), false))) {
                                toParseSchema = false;
                            }
                        }
                        catch (URI.MalformedURIException e) {
                            // empty catch block
                        }
                    }
                    if (toParseSchema) {
                        grammar = this.fSchemaLoader.loadSchema(this.fXSDDescription, xis, this.fLocationPairs);
                    }
                }
                catch (IOException ex) {
                    String[] locationHints = this.fXSDDescription.getLocationHints();
                    this.fXSIErrorReporter.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "schema_reference.4", new Object[]{locationHints != null ? locationHints[0] : XMLSymbols.EMPTY_STRING}, (short)0, ex);
                }
            }
        }
        return grammar;
    }

    private boolean hasSchemaComponent(SchemaGrammar grammar, short contextType, org.apache.xerces.xni.QName triggeringComponent) {
        String localName;
        if (grammar != null && triggeringComponent != null && (localName = triggeringComponent.localpart) != null && localName.length() > 0) {
            switch (contextType) {
                case 5: {
                    return grammar.getElementDeclaration(localName) != null;
                }
                case 6: {
                    return grammar.getAttributeDeclaration(localName) != null;
                }
                case 7: {
                    return grammar.getTypeDefinition(localName) != null;
                }
            }
        }
        return false;
    }

    private void setLocationHints(XSDDescription desc, String[] locations, SchemaGrammar grammar) {
        int length = locations.length;
        if (grammar == null) {
            this.fXSDDescription.fLocationHints = new String[length];
            System.arraycopy(locations, 0, this.fXSDDescription.fLocationHints, 0, length);
        } else {
            this.setLocationHints(desc, locations, grammar.getDocumentLocations());
        }
    }

    private void setLocationHints(XSDDescription desc, String[] locations, StringList docLocations) {
        int length = locations.length;
        String[] hints = new String[length];
        int counter = 0;
        for (int i = 0; i < length; ++i) {
            if (docLocations.contains(locations[i])) continue;
            hints[counter++] = locations[i];
        }
        if (counter > 0) {
            if (counter == length) {
                this.fXSDDescription.fLocationHints = hints;
            } else {
                this.fXSDDescription.fLocationHints = new String[counter];
                System.arraycopy(hints, 0, this.fXSDDescription.fLocationHints, 0, counter);
            }
        }
    }

    void reportSchemaError(String key, Object[] arguments) {
        if (this.fDoValidation) {
            this.fXSIErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, arguments, (short)1);
        }
    }

    private void activateSelectorFor(IdentityConstraint ic) {
        Selector selector = ic.getSelector();
        SchemaValidatorHelper activator = this;
        if (selector == null) {
            return;
        }
        XPathMatcher matcher = selector.createMatcher(activator, this.fElementDepth);
        if (this.fSchemaVersion == 4) {
            matcher.setXPathDefaultNamespace(selector.getXPathDefaultNamespace());
        }
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment();
    }

    @Override
    public XPathMatcher activateField(Field field, int initialDepth) {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(field.getIdentityConstraint(), initialDepth);
        XPathMatcher matcher = field.createMatcher(valueStore);
        if (this.fSchemaVersion == 4) {
            matcher.setXPathDefaultNamespace(field.getXPathDefaultNamespace());
        }
        this.fMatcherStack.addMatcher(matcher);
        matcher.startDocumentFragment();
        return matcher;
    }

    @Override
    public void startValueScopeFor(IdentityConstraint identityConstraint, int initialDepth) {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(identityConstraint, initialDepth);
        valueStore.startValueScope();
    }

    @Override
    public void endValueScopeFor(IdentityConstraint identityConstraint, int initialDepth) {
        ValueStoreBase valueStore = this.fValueStoreCache.getValueStoreFor(identityConstraint, initialDepth);
        valueStore.endValueScope();
    }

    XSDAssertionValidator getAssertionValidator() {
        return this.fAssertionValidator;
    }

    void setIsAssertProcessingNeededForSTUnionElem(boolean isAssertProcessingNeededForSTUnionElem) {
        this.fIsAssertProcessingNeededForSTUnionElem = isAssertProcessingNeededForSTUnionElem;
    }

    List getIsAssertProcessingNeededForSTUnionAttrs() {
        return this.fIsAssertProcessingNeededForSTUnionAttrs;
    }

    Vector getInheritableAttrList() {
        return this.fInheritableAttrList;
    }

    protected static final class ShortVector {
        private int fLength;
        private short[] fData;

        public ShortVector() {
        }

        public ShortVector(int initialCapacity) {
            this.fData = new short[initialCapacity];
        }

        public int length() {
            return this.fLength;
        }

        public void add(short value) {
            this.ensureCapacity(this.fLength + 1);
            this.fData[this.fLength++] = value;
        }

        public short valueAt(int position) {
            return this.fData[position];
        }

        public void clear() {
            this.fLength = 0;
        }

        public boolean contains(short value) {
            for (int i = 0; i < this.fLength; ++i) {
                if (this.fData[i] != value) continue;
                return true;
            }
            return false;
        }

        private void ensureCapacity(int size) {
            if (this.fData == null) {
                this.fData = new short[8];
            } else if (this.fData.length <= size) {
                short[] newdata = new short[this.fData.length * 2];
                System.arraycopy(this.fData, 0, newdata, 0, this.fData.length);
                this.fData = newdata;
            }
        }
    }

    protected class ValueStoreCache {
        final LocalIDKey fLocalId = new LocalIDKey();
        protected final ArrayList fValueStores = new ArrayList();
        protected final HashMap fIdentityConstraint2ValueStoreMap = new HashMap();
        protected final Stack fGlobalMapStack = new Stack();
        protected final HashMap fGlobalIDConstraintMap = new HashMap();

        public void startDocument() {
            this.fValueStores.clear();
            this.fIdentityConstraint2ValueStoreMap.clear();
            this.fGlobalIDConstraintMap.clear();
            this.fGlobalMapStack.removeAllElements();
        }

        public void startElement() {
            if (this.fGlobalIDConstraintMap.size() > 0) {
                this.fGlobalMapStack.push(this.fGlobalIDConstraintMap.clone());
            } else {
                this.fGlobalMapStack.push(null);
            }
            this.fGlobalIDConstraintMap.clear();
        }

        public void endElement() {
            if (this.fGlobalMapStack.isEmpty()) {
                return;
            }
            HashMap oldMap = (HashMap)this.fGlobalMapStack.pop();
            if (oldMap == null) {
                return;
            }
            for (Map.Entry entry : oldMap.entrySet()) {
                IdentityConstraint id = (IdentityConstraint)entry.getKey();
                ValueStoreBase oldVal = (ValueStoreBase)entry.getValue();
                if (oldVal == null) continue;
                ValueStoreBase currVal = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
                if (currVal == null) {
                    this.fGlobalIDConstraintMap.put(id, oldVal);
                    continue;
                }
                if (currVal == oldVal) continue;
                currVal.append(oldVal);
            }
        }

        public void initValueStoresFor(XSElementDecl eDecl, FieldActivator activator) {
            IdentityConstraint[] icArray = eDecl.fIDConstraints;
            int icCount = eDecl.fIDCPos;
            block5: for (int i = 0; i < icCount; ++i) {
                switch (icArray[i].getCategory()) {
                    case 3: {
                        UniqueOrKey unique = (UniqueOrKey)icArray[i];
                        LocalIDKey toHash = new LocalIDKey(unique, SchemaValidatorHelper.this.fElementDepth);
                        UniqueValueStore uniqueValueStore = (UniqueValueStore)this.fIdentityConstraint2ValueStoreMap.get(toHash);
                        if (uniqueValueStore == null) {
                            uniqueValueStore = new UniqueValueStore(unique, eDecl.getName());
                            this.fIdentityConstraint2ValueStoreMap.put(toHash, uniqueValueStore);
                        } else {
                            uniqueValueStore.clear();
                            uniqueValueStore.setElementName(eDecl.getName());
                        }
                        this.fValueStores.add(uniqueValueStore);
                        SchemaValidatorHelper.this.activateSelectorFor(icArray[i]);
                        continue block5;
                    }
                    case 1: {
                        UniqueOrKey key = (UniqueOrKey)icArray[i];
                        LocalIDKey toHash = new LocalIDKey(key, SchemaValidatorHelper.this.fElementDepth);
                        KeyValueStore keyValueStore = (KeyValueStore)this.fIdentityConstraint2ValueStoreMap.get(toHash);
                        if (keyValueStore == null) {
                            keyValueStore = new KeyValueStore(key, eDecl.getName());
                            this.fIdentityConstraint2ValueStoreMap.put(toHash, keyValueStore);
                        } else {
                            keyValueStore.clear();
                            keyValueStore.setElementName(eDecl.getName());
                        }
                        this.fValueStores.add(keyValueStore);
                        SchemaValidatorHelper.this.activateSelectorFor(icArray[i]);
                        continue block5;
                    }
                    case 2: {
                        KeyRef keyRef = (KeyRef)icArray[i];
                        LocalIDKey toHash = new LocalIDKey(keyRef, SchemaValidatorHelper.this.fElementDepth);
                        KeyRefValueStore keyRefValueStore = (KeyRefValueStore)this.fIdentityConstraint2ValueStoreMap.get(toHash);
                        if (keyRefValueStore == null) {
                            keyRefValueStore = new KeyRefValueStore(keyRef, null, eDecl.getName());
                            this.fIdentityConstraint2ValueStoreMap.put(toHash, keyRefValueStore);
                        } else {
                            keyRefValueStore.clear();
                            keyRefValueStore.setElementName(eDecl.getName());
                        }
                        this.fValueStores.add(keyRefValueStore);
                        SchemaValidatorHelper.this.activateSelectorFor(icArray[i]);
                    }
                }
            }
        }

        public ValueStoreBase getValueStoreFor(IdentityConstraint id, int initialDepth) {
            this.fLocalId.fDepth = initialDepth;
            this.fLocalId.fId = id;
            return (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(this.fLocalId);
        }

        public ValueStoreBase getGlobalValueStoreFor(IdentityConstraint id) {
            return (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
        }

        public void transplant(IdentityConstraint id, int initialDepth) {
            this.fLocalId.fDepth = initialDepth;
            this.fLocalId.fId = id;
            ValueStoreBase newVals = (ValueStoreBase)this.fIdentityConstraint2ValueStoreMap.get(this.fLocalId);
            if (id.getCategory() == 2) {
                return;
            }
            ValueStoreBase currVals = (ValueStoreBase)this.fGlobalIDConstraintMap.get(id);
            if (currVals != null) {
                currVals.append(newVals);
                this.fGlobalIDConstraintMap.put(id, currVals);
            } else {
                this.fGlobalIDConstraintMap.put(id, newVals);
            }
        }

        public void endDocument() {
            int count = this.fValueStores.size();
            for (int i = 0; i < count; ++i) {
                ValueStoreBase valueStore = (ValueStoreBase)this.fValueStores.get(i);
                valueStore.endDocument();
            }
        }

        public String toString() {
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                return s.substring(index1 + 1);
            }
            int index2 = s.lastIndexOf(46);
            if (index2 != -1) {
                return s.substring(index2 + 1);
            }
            return s;
        }
    }

    protected class UniqueValueStore
    extends ValueStoreBase {
        public UniqueValueStore(UniqueOrKey unique, String elementName) {
            super(unique, elementName);
        }

        @Override
        protected void checkDuplicateValues() {
            if (this.contains()) {
                String code = "DuplicateUnique";
                String value = this.toString(this.fLocalValues);
                String cName = this.fIdentityConstraint.getIdentityConstraintName();
                SchemaValidatorHelper.this.reportSchemaError(code, new Object[]{value, this.fElementName, cName});
            }
        }
    }

    protected class KeyRefValueStore
    extends ValueStoreBase {
        protected ValueStoreBase fKeyValueStore;

        public KeyRefValueStore(KeyRef keyRef, KeyValueStore keyValueStore, String elementName) {
            super(keyRef, elementName);
            this.fKeyValueStore = keyValueStore;
        }

        @Override
        public void endDocumentFragment() {
            super.endDocumentFragment();
            this.fKeyValueStore = (ValueStoreBase)SchemaValidatorHelper.this.fValueStoreCache.fGlobalIDConstraintMap.get(((KeyRef)this.fIdentityConstraint).getKey());
            if (this.fKeyValueStore == null) {
                String code = "KeyRefOutOfScope";
                String value = this.fIdentityConstraint.getName();
                SchemaValidatorHelper.this.reportSchemaError(code, new Object[]{value});
                return;
            }
            int errorIndex = this.fKeyValueStore.contains(this);
            if (errorIndex != -1) {
                String code = "KeyNotFound";
                String values = this.toString(this.fValues, errorIndex, this.fFieldCount);
                String name = this.fIdentityConstraint.getName();
                SchemaValidatorHelper.this.reportSchemaError(code, new Object[]{name, values, this.fElementName});
            }
        }

        @Override
        public void endDocument() {
            super.endDocument();
        }
    }

    protected class KeyValueStore
    extends ValueStoreBase {
        public KeyValueStore(UniqueOrKey key, String elementName) {
            super(key, elementName);
        }

        @Override
        protected void checkDuplicateValues() {
            if (this.contains()) {
                String code = "DuplicateKey";
                String value = this.toString(this.fLocalValues);
                String cName = this.fIdentityConstraint.getIdentityConstraintName();
                SchemaValidatorHelper.this.reportSchemaError(code, new Object[]{value, this.fElementName, cName});
            }
        }
    }

    protected abstract class ValueStoreBase
    implements ValueStore {
        protected IdentityConstraint fIdentityConstraint;
        protected int fFieldCount = 0;
        protected Field[] fFields = null;
        protected String fElementName;
        protected Object[] fLocalValues = null;
        protected short[] fLocalValueTypes = null;
        protected ShortList[] fLocalItemValueTypes = null;
        protected int fValuesCount;
        public final Vector fValues = new Vector();
        public ShortVector fValueTypes = null;
        public Vector fItemValueTypes = null;
        private boolean fUseValueTypeVector = false;
        private int fValueTypesLength = 0;
        private short fValueType = 0;
        private boolean fUseItemValueTypeVector = false;
        private int fItemValueTypesLength = 0;
        private ShortList fItemValueType = null;
        final StringBuffer fTempBuffer = new StringBuffer();

        protected ValueStoreBase(IdentityConstraint identityConstraint, String elementName) {
            this.fElementName = elementName;
            this.fIdentityConstraint = identityConstraint;
            this.fFieldCount = this.fIdentityConstraint.getFieldCount();
            this.fFields = new Field[this.fFieldCount];
            this.fLocalValues = new Object[this.fFieldCount];
            this.fLocalValueTypes = new short[this.fFieldCount];
            this.fLocalItemValueTypes = new ShortList[this.fFieldCount];
            for (int i = 0; i < this.fFieldCount; ++i) {
                this.fFields[i] = this.fIdentityConstraint.getFieldAt(i);
            }
        }

        public void clear() {
            this.fValuesCount = 0;
            this.fUseValueTypeVector = false;
            this.fValueTypesLength = 0;
            this.fValueType = 0;
            this.fUseItemValueTypeVector = false;
            this.fItemValueTypesLength = 0;
            this.fItemValueType = null;
            this.fValues.setSize(0);
            if (this.fValueTypes != null) {
                this.fValueTypes.clear();
            }
            if (this.fItemValueTypes != null) {
                this.fItemValueTypes.setSize(0);
            }
        }

        public void append(ValueStoreBase newVal) {
            for (int i = 0; i < newVal.fValues.size(); ++i) {
                this.fValues.addElement(newVal.fValues.elementAt(i));
                this.addValueType(newVal.getValueTypeAt(i));
                this.addItemValueType(newVal.getItemValueTypeAt(i));
            }
        }

        public void startValueScope() {
            this.fValuesCount = 0;
            for (int i = 0; i < this.fFieldCount; ++i) {
                this.fLocalValues[i] = null;
                this.fLocalValueTypes[i] = 0;
                this.fLocalItemValueTypes[i] = null;
            }
        }

        public void endValueScope() {
            if (this.fValuesCount == 0) {
                if (this.fIdentityConstraint.getCategory() == 1) {
                    String code = "AbsentKeyValue";
                    String cName = this.fIdentityConstraint.getIdentityConstraintName();
                    SchemaValidatorHelper.this.reportSchemaError(code, new Object[]{this.fElementName, cName});
                }
                return;
            }
            if (this.fValuesCount != this.fFieldCount) {
                if (this.fIdentityConstraint.getCategory() == 1) {
                    String code = "KeyNotEnoughValues";
                    UniqueOrKey key = (UniqueOrKey)this.fIdentityConstraint;
                    String cName = key.getIdentityConstraintName();
                    SchemaValidatorHelper.this.reportSchemaError(code, new Object[]{this.fElementName, cName});
                }
                return;
            }
        }

        public void endDocumentFragment() {
        }

        public void endDocument() {
        }

        @Override
        public void reportError(String key, Object[] args) {
            SchemaValidatorHelper.this.reportSchemaError(key, args);
        }

        @Override
        public void addValue(Field field, boolean mayMatch, Object actualValue, short valueType, ShortList itemValueType) {
            int i;
            for (i = this.fFieldCount - 1; i > -1 && this.fFields[i] != field; --i) {
            }
            if (i == -1) {
                String code = "UnknownField";
                String cName = this.fIdentityConstraint.getIdentityConstraintName();
                SchemaValidatorHelper.this.reportSchemaError(code, new Object[]{field.toString(), this.fElementName, cName});
                return;
            }
            if (!mayMatch) {
                String code = "FieldMultipleMatch";
                String cName = this.fIdentityConstraint.getIdentityConstraintName();
                SchemaValidatorHelper.this.reportSchemaError(code, new Object[]{field.toString(), cName});
            } else {
                ++this.fValuesCount;
            }
            this.fLocalValues[i] = actualValue;
            this.fLocalValueTypes[i] = valueType;
            this.fLocalItemValueTypes[i] = itemValueType;
            if (this.fValuesCount == this.fFieldCount) {
                this.checkDuplicateValues();
                for (i = 0; i < this.fFieldCount; ++i) {
                    this.fValues.addElement(this.fLocalValues[i]);
                    this.addValueType(this.fLocalValueTypes[i]);
                    this.addItemValueType(this.fLocalItemValueTypes[i]);
                }
            }
        }

        @Override
        public void setElementName(String elementName) {
            this.fElementName = elementName;
        }

        @Override
        public String getElementName() {
            return this.fElementName;
        }

        public boolean contains() {
            int next = 0;
            int size = this.fValues.size();
            int i = 0;
            while (i < size) {
                block3: {
                    next = i + this.fFieldCount;
                    for (int j = 0; j < this.fFieldCount; ++j) {
                        ShortList typeList2;
                        Object value1 = this.fLocalValues[j];
                        Object value2 = this.fValues.elementAt(i);
                        short valueType1 = this.fLocalValueTypes[j];
                        short valueType2 = this.getValueTypeAt(i);
                        ShortList typeList1 = this.isListType(valueType1) ? this.fLocalItemValueTypes[j] : null;
                        ShortList shortList = typeList2 = this.isListType(valueType2) ? this.getItemValueTypeAt(i) : null;
                        if (EqualityHelper.isEqual(value1, value2, valueType1, valueType2, typeList1, typeList2, SchemaValidatorHelper.this.fSchemaVersion)) {
                            ++i;
                            continue;
                        }
                        break block3;
                    }
                    return true;
                }
                i = next;
            }
            return false;
        }

        public int contains(ValueStoreBase vsb) {
            Vector values = vsb.fValues;
            int size1 = values.size();
            if (this.fFieldCount <= 1) {
                block0: for (int i = 0; i < size1; ++i) {
                    Object value1 = values.elementAt(i);
                    short valueType1 = vsb.getValueTypeAt(i);
                    ShortList typeList1 = this.isListType(valueType1) ? vsb.getItemValueTypeAt(i) : null;
                    for (int j = 0; j < this.fValues.size(); ++j) {
                        ShortList typeList2;
                        Object value2 = this.fValues.elementAt(j);
                        short valueType2 = this.getValueTypeAt(j);
                        ShortList shortList = typeList2 = this.isListType(valueType2) ? this.getItemValueTypeAt(j) : null;
                        if (EqualityHelper.isEqual(value1, value2, valueType1, valueType2, typeList1, typeList2, SchemaValidatorHelper.this.fSchemaVersion)) continue block0;
                    }
                    return i;
                }
            } else {
                int size2 = this.fValues.size();
                block2: for (int i = 0; i < size1; i += this.fFieldCount) {
                    block3: for (int j = 0; j < size2; j += this.fFieldCount) {
                        for (int k = 0; k < this.fFieldCount; ++k) {
                            ShortList typeList2;
                            Object value1 = values.elementAt(i + k);
                            Object value2 = this.fValues.elementAt(j + k);
                            short valueType1 = vsb.getValueTypeAt(i + k);
                            short valueType2 = this.getValueTypeAt(j + k);
                            ShortList typeList1 = this.isListType(valueType1) ? vsb.getItemValueTypeAt(i + k) : null;
                            ShortList shortList = typeList2 = this.isListType(valueType2) ? this.getItemValueTypeAt(j + k) : null;
                            if (!EqualityHelper.isEqual(value1, value2, valueType1, valueType2, typeList1, typeList2, SchemaValidatorHelper.this.fSchemaVersion)) continue block3;
                        }
                        continue block2;
                    }
                    return i;
                }
            }
            return -1;
        }

        protected void checkDuplicateValues() {
        }

        protected String toString(Object[] values) {
            int size = values.length;
            if (size == 0) {
                return "";
            }
            this.fTempBuffer.setLength(0);
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    this.fTempBuffer.append(',');
                }
                this.fTempBuffer.append(values[i]);
            }
            return this.fTempBuffer.toString();
        }

        protected String toString(Vector values, int start, int length) {
            if (length == 0) {
                return "";
            }
            if (length == 1) {
                return String.valueOf(values.elementAt(start));
            }
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(values.elementAt(start + i));
            }
            return str.toString();
        }

        public String toString() {
            int index2;
            String s = super.toString();
            int index1 = s.lastIndexOf(36);
            if (index1 != -1) {
                s = s.substring(index1 + 1);
            }
            if ((index2 = s.lastIndexOf(46)) != -1) {
                s = s.substring(index2 + 1);
            }
            return s + '[' + this.fIdentityConstraint + ']';
        }

        private boolean isListType(short type) {
            return type == 44 || type == 43;
        }

        private void addValueType(short type) {
            if (this.fUseValueTypeVector) {
                this.fValueTypes.add(type);
            } else if (this.fValueTypesLength++ == 0) {
                this.fValueType = type;
            } else if (this.fValueType != type) {
                this.fUseValueTypeVector = true;
                if (this.fValueTypes == null) {
                    this.fValueTypes = new ShortVector(this.fValueTypesLength * 2);
                }
                for (int i = 1; i < this.fValueTypesLength; ++i) {
                    this.fValueTypes.add(this.fValueType);
                }
                this.fValueTypes.add(type);
            }
        }

        private short getValueTypeAt(int index) {
            if (this.fUseValueTypeVector) {
                return this.fValueTypes.valueAt(index);
            }
            return this.fValueType;
        }

        private void addItemValueType(ShortList itemValueType) {
            if (this.fUseItemValueTypeVector) {
                this.fItemValueTypes.add(itemValueType);
            } else if (this.fItemValueTypesLength++ == 0) {
                this.fItemValueType = itemValueType;
            } else if (!(this.fItemValueType == itemValueType || this.fItemValueType != null && this.fItemValueType.equals(itemValueType))) {
                this.fUseItemValueTypeVector = true;
                if (this.fItemValueTypes == null) {
                    this.fItemValueTypes = new Vector(this.fItemValueTypesLength * 2);
                }
                for (int i = 1; i < this.fItemValueTypesLength; ++i) {
                    this.fItemValueTypes.add(this.fItemValueType);
                }
                this.fItemValueTypes.add(itemValueType);
            }
        }

        private ShortList getItemValueTypeAt(int index) {
            if (this.fUseItemValueTypeVector) {
                return (ShortList)this.fItemValueTypes.elementAt(index);
            }
            return this.fItemValueType;
        }
    }

    protected static final class LocalIDKey {
        public IdentityConstraint fId;
        public int fDepth;

        public LocalIDKey() {
        }

        public LocalIDKey(IdentityConstraint id, int depth) {
            this.fId = id;
            this.fDepth = depth;
        }

        public int hashCode() {
            return this.fId.hashCode() + this.fDepth;
        }

        public boolean equals(Object localIDKey) {
            if (localIDKey instanceof LocalIDKey) {
                LocalIDKey lIDKey = (LocalIDKey)localIDKey;
                return lIDKey.fId == this.fId && lIDKey.fDepth == this.fDepth;
            }
            return false;
        }
    }

    protected static class XPathMatcherStack {
        protected XPathMatcher[] fMatchers = new XPathMatcher[4];
        protected int fMatchersCount;
        protected IntStack fContextStack = new IntStack();

        public void clear() {
            for (int i = 0; i < this.fMatchersCount; ++i) {
                this.fMatchers[i] = null;
            }
            this.fMatchersCount = 0;
            this.fContextStack.clear();
        }

        public int size() {
            return this.fContextStack.size();
        }

        public int getMatcherCount() {
            return this.fMatchersCount;
        }

        public void addMatcher(XPathMatcher matcher) {
            this.ensureMatcherCapacity();
            this.fMatchers[this.fMatchersCount++] = matcher;
        }

        public XPathMatcher getMatcherAt(int index) {
            return this.fMatchers[index];
        }

        public void pushContext() {
            this.fContextStack.push(this.fMatchersCount);
        }

        public void popContext() {
            this.fMatchersCount = this.fContextStack.pop();
        }

        private void ensureMatcherCapacity() {
            if (this.fMatchersCount == this.fMatchers.length) {
                XPathMatcher[] array = new XPathMatcher[this.fMatchers.length * 2];
                System.arraycopy(this.fMatchers, 0, array, 0, this.fMatchers.length);
                this.fMatchers = array;
            }
        }
    }

    protected final class XSIErrorReporter {
        XMLErrorReporter fErrorReporter;
        Vector fErrors = new Vector();
        int[] fContext = new int[8];
        int fContextCount;

        protected XSIErrorReporter() {
        }

        public void reset(XMLErrorReporter errorReporter) {
            this.fErrorReporter = errorReporter;
            this.fErrors.removeAllElements();
            this.fContextCount = 0;
        }

        public void pushContext() {
            if (!SchemaValidatorHelper.this.fAugPSVI) {
                return;
            }
            if (this.fContextCount == this.fContext.length) {
                int newSize = this.fContextCount + 8;
                int[] newArray = new int[newSize];
                System.arraycopy(this.fContext, 0, newArray, 0, this.fContextCount);
                this.fContext = newArray;
            }
            this.fContext[this.fContextCount++] = this.fErrors.size();
        }

        public String[] popContext() {
            if (!SchemaValidatorHelper.this.fAugPSVI) {
                return null;
            }
            int contextPos = this.fContext[--this.fContextCount];
            int size = this.fErrors.size() - contextPos;
            if (size == 0) {
                return null;
            }
            String[] errors = new String[size];
            for (int i = 0; i < size; ++i) {
                errors[i] = (String)this.fErrors.elementAt(contextPos + i);
            }
            this.fErrors.setSize(contextPos);
            return errors;
        }

        public String[] mergeContext() {
            if (!SchemaValidatorHelper.this.fAugPSVI) {
                return null;
            }
            int contextPos = this.fContext[--this.fContextCount];
            int size = this.fErrors.size() - contextPos;
            if (size == 0) {
                return null;
            }
            String[] errors = new String[size];
            for (int i = 0; i < size; ++i) {
                errors[i] = (String)this.fErrors.elementAt(contextPos + i);
            }
            return errors;
        }

        public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
            String message = this.fErrorReporter.reportError(domain, key, arguments, severity);
            if (SchemaValidatorHelper.this.fAugPSVI) {
                this.fErrors.addElement(key);
                this.fErrors.addElement(message);
            }
        }

        public void reportError(XMLLocator location, String domain, String key, Object[] arguments, short severity) throws XNIException {
            String message = this.fErrorReporter.reportError(location, domain, key, arguments, severity);
            if (SchemaValidatorHelper.this.fAugPSVI) {
                this.fErrors.addElement(key);
                this.fErrors.addElement(message);
            }
        }
    }
}

