/*
 * Decompiled with CFR 0.152.
 */
package com.rameshkp.openapi.merger.maven.plugin;

import com.rameshkp.openapi.merger.app.OpenApiMergerApp;
import com.rameshkp.openapi.merger.app.models.OpenApi;
import com.rameshkp.openapi.merger.maven.models.OpenApiFileFormat;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="merge")
public class OpenApiMergerMojo
extends AbstractMojo {
    @Parameter
    private File inputDir;
    @Parameter(defaultValue="target/open-api")
    private File outputDir;
    @Parameter(defaultValue="openapi")
    private String outputFileName;
    @Parameter(defaultValue="YAML")
    private OpenApiFileFormat outputFileFormat;
    @Parameter
    private OpenApi openApi;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.debug((CharSequence)"Starting validation");
        this.validate();
        File outputFile = this.getOutputFile(log);
        log.debug((CharSequence)"Attempting to merge the open api schema files");
        OpenApiMergerApp apiMergerApp = new OpenApiMergerApp();
        try {
            apiMergerApp.merge(this.inputDir, outputFile, this.openApi);
            log.info((CharSequence)("Completed Open API file merging. output " + outputFile.getAbsolutePath()));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private File getOutputFile(Log log) {
        boolean created = this.outputDir.mkdirs();
        log.debug((CharSequence)("Create the output directory " + created));
        String fileExtension = "";
        fileExtension = this.outputFileFormat == OpenApiFileFormat.JSON ? ".json" : ".yaml";
        String outFileWithExtension = this.outputFileName + fileExtension;
        return new File(this.outputDir, outFileWithExtension);
    }

    private void validate() throws MojoFailureException {
        if (this.inputDir == null || !this.inputDir.isDirectory()) {
            throw new MojoFailureException("Invalid InputDir: Provide a valid directory containing open api schema files");
        }
    }
}

