/*
 * Decompiled with CFR 0.152.
 */
package com.redis.enterprise;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.redis.enterprise.Command;
import com.redis.enterprise.Database;
import com.redis.enterprise.rest.Bootstrap;
import com.redis.enterprise.rest.CommandResponse;
import com.redis.enterprise.rest.InstalledModule;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.awaitility.Awaitility;

public class Admin
implements AutoCloseable {
    public static final String DEFAULT_USER_NAME = "admin@redis.com";
    public static final String DEFAULT_PASSWORD = "redis123";
    public static final String DEFAULT_PROTOCOL = "https";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 9443;
    private static final String BOOTSTRAP = "bootstrap";
    private static final String MODULES = "modules";
    private static final String BDBS = "bdbs";
    private static final String COMMAND = "command";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String V1 = "/v1/";
    private static final CharSequence PATH_SEPARATOR = "/";
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private String userName = "admin@redis.com";
    private String password = "redis123";
    private CloseableHttpClient client;
    private String protocol = "https";
    private String host = "localhost";
    private int port = 9443;

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public Admin withHost(String host) {
        this.host = host;
        return this;
    }

    public Admin withProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public Admin withPort(int port) {
        this.port = port;
        return this;
    }

    public Admin withUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public Admin withPassword(String password) {
        this.password = password;
        return this;
    }

    private static String v1(String ... segments) {
        return Admin.join(V1, segments);
    }

    private static String join(String path, String[] segments) {
        return path + String.join(PATH_SEPARATOR, segments);
    }

    private URI uri(String path) {
        try {
            return new URI(this.protocol, null, this.host, this.port, path, null, null);
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x.getMessage(), x);
        }
    }

    private <T> T get(String path, Class<T> type) throws IOException, GeneralSecurityException {
        return this.get(path, (JavaType)SimpleType.constructUnsafe(type));
    }

    private <T> T get(String path, JavaType type) throws IOException, GeneralSecurityException {
        return this.read(this.header((ClassicHttpRequest)new HttpGet(this.uri(path))), type, 200);
    }

    private <T> T delete(String path, Class<T> type) throws IOException, GeneralSecurityException {
        return this.delete(path, (JavaType)SimpleType.constructUnsafe(type));
    }

    private <T> T delete(String path, JavaType type) throws IOException, GeneralSecurityException {
        return this.read(this.header((ClassicHttpRequest)new HttpDelete(this.uri(path))), type, 200);
    }

    private ClassicHttpRequest header(ClassicHttpRequest request) {
        request.setHeader("Content-Type", (Object)CONTENT_TYPE_JSON);
        return request;
    }

    private <T> T post(String path, Object request, Class<T> responseType) throws IOException, GeneralSecurityException {
        return this.post(path, request, (JavaType)SimpleType.constructUnsafe(responseType));
    }

    private <T> T post(String path, Object request, JavaType responseType) throws IOException, GeneralSecurityException {
        HttpPost post = new HttpPost(this.uri(path));
        String json = this.objectMapper.writeValueAsString(request);
        post.setEntity((HttpEntity)new StringEntity(json));
        return this.read(this.header((ClassicHttpRequest)post), responseType, 200);
    }

    private <T> T read(ClassicHttpRequest request, JavaType type, int successCode) throws IOException, GeneralSecurityException {
        String json;
        HttpHost target = new HttpHost(this.protocol, this.host, this.port);
        HttpClientContext localContext = HttpClientContext.create();
        BasicScheme basicAuth = new BasicScheme();
        basicAuth.initPreemptive((Credentials)new UsernamePasswordCredentials(this.userName, this.password.toCharArray()));
        localContext.resetAuthExchange(target, (AuthScheme)basicAuth);
        CloseableHttpResponse response = this.client().execute(request, (HttpContext)localContext);
        try {
            json = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (ParseException e) {
            throw new HttpResponseParsingException("Could not parse response", e);
        }
        if (response.getCode() == successCode) {
            return (T)this.objectMapper.readValue(json, type);
        }
        throw new HttpResponseException(response.getCode(), response.getReasonPhrase() + " " + json);
    }

    private CloseableHttpClient client() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        if (this.client == null) {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
            SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(sslcontext).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
            PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
            HttpClientBuilder clientBuilder = HttpClients.custom();
            clientBuilder.setConnectionManager((HttpClientConnectionManager)cm);
            this.client = clientBuilder.build();
        }
        return this.client;
    }

    public List<InstalledModule> getModules() throws IOException, GeneralSecurityException {
        return (List)this.get(Admin.v1(MODULES), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, InstalledModule.class));
    }

    public Database createDatabase(Database database) throws IOException, GeneralSecurityException {
        HashMap<String, InstalledModule> installedModules = new HashMap<String, InstalledModule>();
        for (InstalledModule module : this.getModules()) {
            installedModules.put(module.getName(), module);
        }
        for (Database.ModuleConfig moduleConfig : database.getModules()) {
            if (!installedModules.containsKey(moduleConfig.getName())) {
                throw new IllegalArgumentException(String.format("Module %s not installed", moduleConfig.getName()));
            }
            moduleConfig.setId(((InstalledModule)installedModules.get(moduleConfig.getName())).getId());
        }
        Database response = this.post(Admin.v1(BDBS), (Object)database, Database.class);
        long uid = response.getUid();
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).ignoreExceptions().until(() -> this.executeCommand(uid, new Command("PING")).getResponse().asBoolean());
        return response;
    }

    public List<Database> getDatabases() throws IOException, GeneralSecurityException {
        return (List)this.get(Admin.v1(BDBS), (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, Database.class));
    }

    public void deleteAllDatabases() throws IOException, GeneralSecurityException {
        this.getDatabases().stream().map(Database::getUid).forEach(this::deleteDatabase);
        Awaitility.await().until(() -> this.getDatabases().isEmpty());
    }

    public void deleteDatabase(long uid) {
        Awaitility.await().pollInterval(Duration.ofSeconds(1L)).until(() -> {
            try {
                this.delete(Admin.v1(BDBS, String.valueOf(uid)), Database.class);
                return true;
            }
            catch (HttpResponseException e) {
                if (e.getStatusCode() == 409) {
                    return false;
                }
                throw e;
            }
        });
    }

    public void waitForBoostrap() {
        Awaitility.await().timeout(Duration.ofMinutes(1L)).pollInterval(Duration.ofSeconds(1L)).ignoreExceptions().until(() -> "idle".equals(this.getBootstrap().getStatus().getState()));
    }

    private Bootstrap getBootstrap() throws IOException, GeneralSecurityException {
        return this.get(Admin.v1(BOOTSTRAP), Bootstrap.class);
    }

    public CommandResponse executeCommand(long bdb, Command command) throws IOException, GeneralSecurityException {
        return this.post(Admin.v1(BDBS, String.valueOf(bdb), COMMAND), (Object)command, CommandResponse.class);
    }

    public static Admin create(String host) {
        Admin admin = new Admin();
        admin.withHost(host);
        return admin;
    }

    public static Admin create(String host, int port) {
        Admin admin = new Admin();
        admin.withHost(host);
        admin.withPort(port);
        return admin;
    }

    private static class HttpResponseParsingException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public HttpResponseParsingException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

