/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsConnectionListener;
import com.relayrides.pushy.apns.ApnsEnvironment;
import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.KnownBadPushNotification;
import com.relayrides.pushy.apns.RejectedNotification;
import com.relayrides.pushy.apns.RejectedNotificationReason;
import com.relayrides.pushy.apns.SendableApnsPushNotification;
import com.relayrides.pushy.apns.SentNotificationBuffer;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApnsConnection<T extends ApnsPushNotification> {
    private final ApnsEnvironment environment;
    private final SSLContext sslContext;
    private final NioEventLoopGroup eventLoopGroup;
    private final ApnsConnectionListener<T> listener;
    private static final AtomicInteger connectionCounter = new AtomicInteger(0);
    private final String name;
    private ChannelFuture connectFuture;
    private volatile boolean handshakeCompleted = false;
    private boolean closeOnRegistration;
    private int sequenceNumber = 0;
    private final Object pendingWriteMonitor = new Object();
    private int pendingWriteCount = 0;
    private SendableApnsPushNotification<KnownBadPushNotification> shutdownNotification;
    private boolean rejectionReceived = false;
    private final SentNotificationBuffer<T> sentNotificationBuffer = new SentNotificationBuffer(4096);
    private static final Logger log = LoggerFactory.getLogger(ApnsConnection.class);

    public ApnsConnection(ApnsEnvironment environment, SSLContext sslContext, NioEventLoopGroup eventLoopGroup, ApnsConnectionListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("Listener must not be null.");
        }
        this.environment = environment;
        this.sslContext = sslContext;
        this.eventLoopGroup = eventLoopGroup;
        this.listener = listener;
        this.name = String.format("ApnsConnection-%d", connectionCounter.getAndIncrement());
    }

    public synchronized void connect() {
        final ApnsConnection apnsConnection = this;
        if (this.connectFuture != null) {
            throw new IllegalStateException(String.format("%s already started a connection attempt.", this.name));
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group((EventLoopGroup)this.eventLoopGroup);
        bootstrap.channel(NioSocketChannel.class);
        bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.option(ChannelOption.AUTO_CLOSE, (Object)false);
        bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                SSLEngine sslEngine = apnsConnection.sslContext.createSSLEngine();
                sslEngine.setUseClientMode(true);
                pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                pipeline.addLast("decoder", (ChannelHandler)new RejectedNotificationDecoder());
                pipeline.addLast("encoder", (ChannelHandler)new ApnsPushNotificationEncoder());
                pipeline.addLast("handler", (ChannelHandler)new ApnsConnectionHandler(apnsConnection));
            }
        });
        log.debug("{} beginning connection process.", (Object)apnsConnection.name);
        this.connectFuture = bootstrap.connect(this.environment.getApnsGatewayHost(), this.environment.getApnsGatewayPort());
        this.connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(final ChannelFuture connectFuture) {
                if (connectFuture.isSuccess()) {
                    log.debug("{} connected; waiting for TLS handshake.", (Object)apnsConnection.name);
                    SslHandler sslHandler = (SslHandler)connectFuture.channel().pipeline().get(SslHandler.class);
                    try {
                        sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                            public void operationComplete(Future<Channel> handshakeFuture) {
                                if (handshakeFuture.isSuccess()) {
                                    log.debug("{} successfully completed TLS handshake.", (Object)apnsConnection.name);
                                    apnsConnection.handshakeCompleted = true;
                                    apnsConnection.listener.handleConnectionSuccess(apnsConnection);
                                } else {
                                    log.debug("{} failed to complete TLS handshake with APNs gateway.", (Object)apnsConnection.name, (Object)handshakeFuture.cause());
                                    connectFuture.channel().close();
                                    apnsConnection.listener.handleConnectionFailure(apnsConnection, handshakeFuture.cause());
                                }
                            }
                        });
                    }
                    catch (NullPointerException e) {
                        log.warn("{} failed to get SSL handler and could not wait for a TLS handshake.", (Object)apnsConnection.name);
                        connectFuture.channel().close();
                        apnsConnection.listener.handleConnectionFailure(apnsConnection, e);
                    }
                } else {
                    log.debug("{} failed to connect to APNs gateway.", (Object)apnsConnection.name, (Object)connectFuture.cause());
                    apnsConnection.listener.handleConnectionFailure(apnsConnection, connectFuture.cause());
                }
            }
        });
    }

    public synchronized void sendNotification(T notification) {
        ApnsConnection apnsConnection = this;
        if (!this.handshakeCompleted) {
            throw new IllegalStateException(String.format("%s has not completed handshake.", this.name));
        }
        this.connectFuture.channel().eventLoop().execute(new Runnable((ApnsPushNotification)notification, apnsConnection){
            final /* synthetic */ ApnsPushNotification val$notification;
            final /* synthetic */ ApnsConnection val$apnsConnection;
            {
                this.val$notification = apnsPushNotification;
                this.val$apnsConnection = apnsConnection2;
            }

            public void run() {
                final SendableApnsPushNotification<ApnsPushNotification> sendableNotification = new SendableApnsPushNotification<ApnsPushNotification>(this.val$notification, this.val$apnsConnection.sequenceNumber++);
                log.trace("{} sending {}", (Object)this.val$apnsConnection.name, sendableNotification);
                this.val$apnsConnection.pendingWriteCount += 1;
                this.val$apnsConnection.connectFuture.channel().writeAndFlush(sendableNotification).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(ChannelFuture writeFuture) {
                        if (writeFuture.isSuccess()) {
                            log.trace("{} successfully wrote notification {}", (Object)val$apnsConnection.name, (Object)sendableNotification.getSequenceNumber());
                            if (val$apnsConnection.rejectionReceived) {
                                val$apnsConnection.listener.handleUnprocessedNotifications(val$apnsConnection, Collections.singletonList(val$notification));
                            } else {
                                val$apnsConnection.sentNotificationBuffer.addSentNotification(sendableNotification);
                            }
                        } else {
                            log.trace("{} failed to write notification {}", new Object[]{val$apnsConnection.name, sendableNotification, writeFuture.cause()});
                            val$apnsConnection.listener.handleWriteFailure(val$apnsConnection, val$notification, writeFuture.cause());
                        }
                        val$apnsConnection.pendingWriteCount -= 1;
                        assert (val$apnsConnection.pendingWriteCount >= 0);
                        if (val$apnsConnection.pendingWriteCount == 0) {
                            Object object = val$apnsConnection.pendingWriteMonitor;
                            synchronized (object) {
                                val$apnsConnection.pendingWriteMonitor.notifyAll();
                            }
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPendingWritesToFinish() throws InterruptedException {
        Object object = this.pendingWriteMonitor;
        synchronized (object) {
            while (this.pendingWriteCount > 0) {
                this.pendingWriteMonitor.wait();
            }
        }
    }

    public synchronized void shutdownGracefully() {
        final ApnsConnection apnsConnection = this;
        if (this.handshakeCompleted && this.connectFuture.channel().isActive()) {
            this.connectFuture.channel().eventLoop().execute(new Runnable(){

                public void run() {
                    if (apnsConnection.shutdownNotification == null) {
                        log.debug("{} sending known-bad notification to shut down.", (Object)apnsConnection.name);
                        apnsConnection.shutdownNotification = new SendableApnsPushNotification<KnownBadPushNotification>(new KnownBadPushNotification(), apnsConnection.sequenceNumber++);
                        apnsConnection.pendingWriteCount += 1;
                        apnsConnection.connectFuture.channel().writeAndFlush((Object)apnsConnection.shutdownNotification).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void operationComplete(ChannelFuture future) {
                                if (future.isSuccess()) {
                                    log.trace("{} successfully wrote known-bad notification {}", (Object)apnsConnection.name, (Object)apnsConnection.shutdownNotification.getSequenceNumber());
                                } else {
                                    log.trace("{} failed to write known-bad notification {}", new Object[]{apnsConnection.name, apnsConnection.shutdownNotification, future.cause()});
                                    apnsConnection.shutdownNotification = null;
                                    apnsConnection.shutdownGracefully();
                                }
                                apnsConnection.pendingWriteCount -= 1;
                                assert (apnsConnection.pendingWriteCount >= 0);
                                if (apnsConnection.pendingWriteCount == 0) {
                                    Object object = apnsConnection.pendingWriteMonitor;
                                    synchronized (object) {
                                        apnsConnection.pendingWriteMonitor.notifyAll();
                                    }
                                }
                            }
                        });
                    }
                }
            });
        } else {
            this.shutdownImmediately();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdownImmediately() {
        if (this.connectFuture != null) {
            ChannelFuture channelFuture = this.connectFuture;
            synchronized (channelFuture) {
                if (this.connectFuture.channel().isRegistered()) {
                    this.connectFuture.channel().eventLoop().execute(this.getImmediateShutdownRunnable());
                } else {
                    this.closeOnRegistration = true;
                }
            }
        }
    }

    private Runnable getImmediateShutdownRunnable() {
        final ApnsConnection apnsConnection = this;
        return new Runnable(){

            public void run() {
                SslHandler sslHandler = (SslHandler)apnsConnection.connectFuture.channel().pipeline().get(SslHandler.class);
                if (apnsConnection.connectFuture.isCancellable()) {
                    apnsConnection.connectFuture.cancel(true);
                } else if (sslHandler != null && sslHandler.handshakeFuture().isCancellable()) {
                    sslHandler.handshakeFuture().cancel(true);
                } else {
                    apnsConnection.connectFuture.channel().close();
                }
            }
        };
    }

    public String toString() {
        return "ApnsConnection [name=" + this.name + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApnsConnectionHandler
    extends SimpleChannelInboundHandler<RejectedNotification> {
        private final ApnsConnection<T> apnsConnection;

        public ApnsConnectionHandler(ApnsConnection<T> clientThread) {
            this.apnsConnection = clientThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void channelRegistered(ChannelHandlerContext context) throws Exception {
            super.channelRegistered(context);
            ChannelFuture channelFuture = this.apnsConnection.connectFuture;
            synchronized (channelFuture) {
                if (this.apnsConnection.closeOnRegistration) {
                    log.debug("Channel registered for {}, but shutting down immediately.", (Object)this.apnsConnection.name);
                    context.channel().eventLoop().execute(this.apnsConnection.getImmediateShutdownRunnable());
                }
            }
        }

        protected void channelRead0(ChannelHandlerContext context, RejectedNotification rejectedNotification) {
            List unprocessedNotifications;
            boolean isKnownBadRejection;
            log.debug("APNs gateway rejected notification with sequence number {} from {} ({}).", new Object[]{rejectedNotification.getSequenceNumber(), this.apnsConnection.name, rejectedNotification.getReason()});
            this.apnsConnection.rejectionReceived = true;
            this.apnsConnection.sentNotificationBuffer.clearNotificationsBeforeSequenceNumber(rejectedNotification.getSequenceNumber());
            boolean bl = isKnownBadRejection = this.apnsConnection.shutdownNotification != null && rejectedNotification.getSequenceNumber() == this.apnsConnection.shutdownNotification.getSequenceNumber();
            if (!isKnownBadRejection && !RejectedNotificationReason.SHUTDOWN.equals((Object)rejectedNotification.getReason())) {
                Object notification = this.apnsConnection.sentNotificationBuffer.getNotificationWithSequenceNumber(rejectedNotification.getSequenceNumber());
                if (notification != null) {
                    this.apnsConnection.listener.handleRejectedNotification(this.apnsConnection, notification, rejectedNotification.getReason());
                } else {
                    log.error("{} failed to find rejected notification with sequence number {}; this may mean the sent notification buffer is too small. Please report this as a bug.", (Object)this.apnsConnection.name, (Object)rejectedNotification.getSequenceNumber());
                }
            }
            if (!(unprocessedNotifications = this.apnsConnection.sentNotificationBuffer.getAllNotificationsAfterSequenceNumber(rejectedNotification.getSequenceNumber())).isEmpty()) {
                this.apnsConnection.listener.handleUnprocessedNotifications(this.apnsConnection, unprocessedNotifications);
            }
            this.apnsConnection.sentNotificationBuffer.clearAllNotifications();
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            log.debug("{} caught an exception.", (Object)this.apnsConnection.name, (Object)cause);
        }

        public void channelInactive(ChannelHandlerContext context) throws Exception {
            super.channelInactive(context);
            if (this.apnsConnection.handshakeCompleted) {
                this.apnsConnection.listener.handleConnectionClosure(this.apnsConnection);
            }
        }

        public void channelWritabilityChanged(ChannelHandlerContext context) throws Exception {
            super.channelWritabilityChanged(context);
            this.apnsConnection.listener.handleConnectionWritabilityChange(this.apnsConnection, context.channel().isWritable());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApnsPushNotificationEncoder
    extends MessageToByteEncoder<SendableApnsPushNotification<T>> {
        private static final byte ENHANCED_PUSH_NOTIFICATION_COMMAND = 1;
        private static final int EXPIRE_IMMEDIATELY = 0;
        private final Charset utf8 = Charset.forName("UTF-8");

        private ApnsPushNotificationEncoder() {
        }

        protected void encode(ChannelHandlerContext context, SendableApnsPushNotification<T> sendablePushNotification, ByteBuf out) throws Exception {
            out.writeByte(1);
            out.writeInt(sendablePushNotification.getSequenceNumber());
            if (sendablePushNotification.getPushNotification().getDeliveryInvalidationTime() != null) {
                out.writeInt(this.getTimestampInSeconds(sendablePushNotification.getPushNotification().getDeliveryInvalidationTime()));
            } else {
                out.writeInt(0);
            }
            out.writeShort(sendablePushNotification.getPushNotification().getToken().length);
            out.writeBytes(sendablePushNotification.getPushNotification().getToken());
            byte[] payloadBytes = sendablePushNotification.getPushNotification().getPayload().getBytes(this.utf8);
            out.writeShort(payloadBytes.length);
            out.writeBytes(payloadBytes);
        }

        private int getTimestampInSeconds(Date date) {
            return (int)(date.getTime() / 1000L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RejectedNotificationDecoder
    extends ByteToMessageDecoder {
        private static final int EXPECTED_BYTES = 6;
        private static final byte EXPECTED_COMMAND = 8;

        private RejectedNotificationDecoder() {
        }

        protected void decode(ChannelHandlerContext context, ByteBuf in, List<Object> out) {
            if (in.readableBytes() >= 6) {
                byte command = in.readByte();
                byte code = in.readByte();
                int notificationId = in.readInt();
                if (command != 8) {
                    log.error("Unexpected command: {}", (Object)command);
                }
                RejectedNotificationReason errorCode = RejectedNotificationReason.getByErrorCode(code);
                out.add(new RejectedNotification(notificationId, errorCode));
            }
        }
    }
}

