/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsConnection;
import com.relayrides.pushy.apns.ApnsPushNotification;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ApnsConnectionPool<T extends ApnsPushNotification> {
    private final ArrayList<ApnsConnection<T>> connections = new ArrayList();
    private int connectionIndex = 0;

    ApnsConnectionPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(ApnsConnection<T> connection) {
        ArrayList<ApnsConnection<T>> arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.add(connection);
            this.connections.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ApnsConnection<T> connection) {
        ArrayList<ApnsConnection<T>> arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApnsConnection<T> getNextConnection() throws InterruptedException {
        ArrayList<ApnsConnection<T>> arrayList = this.connections;
        synchronized (arrayList) {
            while (this.connections.isEmpty()) {
                this.connections.wait();
            }
            return this.connections.get(Math.abs(this.connectionIndex++ % this.connections.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ApnsConnection<T>> getAll() {
        ArrayList<ApnsConnection<T>> arrayList = this.connections;
        synchronized (arrayList) {
            return new ArrayList<ApnsConnection<T>>(this.connections);
        }
    }
}

