/*
 * Decompiled with CFR 0.152.
 */
package com.relayrides.pushy.apns;

import com.relayrides.pushy.apns.ApnsConnection;
import com.relayrides.pushy.apns.ApnsConnectionListener;
import com.relayrides.pushy.apns.ApnsConnectionPool;
import com.relayrides.pushy.apns.ApnsEnvironment;
import com.relayrides.pushy.apns.ApnsPushNotification;
import com.relayrides.pushy.apns.ExpiredToken;
import com.relayrides.pushy.apns.FailedConnectionListener;
import com.relayrides.pushy.apns.FeedbackConnectionException;
import com.relayrides.pushy.apns.FeedbackServiceClient;
import com.relayrides.pushy.apns.RejectedNotificationListener;
import com.relayrides.pushy.apns.RejectedNotificationReason;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushManager<T extends ApnsPushNotification>
implements ApnsConnectionListener<T> {
    private final BlockingQueue<T> queue;
    private final LinkedBlockingQueue<T> retryQueue;
    private final ApnsEnvironment environment;
    private final SSLContext sslContext;
    private final int concurrentConnectionCount;
    private final HashSet<ApnsConnection<T>> activeConnections;
    private final ApnsConnectionPool<T> writableConnectionPool;
    private final FeedbackServiceClient feedbackServiceClient;
    private final ArrayList<RejectedNotificationListener<? super T>> rejectedNotificationListeners;
    private final ArrayList<FailedConnectionListener<? super T>> failedConnectionListeners;
    private Thread dispatchThread;
    private boolean dispatchThreadShouldContinue = true;
    private final NioEventLoopGroup eventLoopGroup;
    private final boolean shouldShutDownEventLoopGroup;
    private final ExecutorService listenerExecutorService;
    private final boolean shouldShutDownListenerExecutorService;
    private boolean shutDownStarted = false;
    private boolean shutDownFinished = false;
    private static final Logger log = LoggerFactory.getLogger(PushManager.class);

    protected PushManager(ApnsEnvironment environment, SSLContext sslContext, int concurrentConnectionCount, NioEventLoopGroup eventLoopGroup, ExecutorService listenerExecutorService, BlockingQueue<T> queue) {
        this.queue = queue != null ? queue : new LinkedBlockingQueue();
        this.retryQueue = new LinkedBlockingQueue();
        this.rejectedNotificationListeners = new ArrayList();
        this.failedConnectionListeners = new ArrayList();
        this.environment = environment;
        this.sslContext = sslContext;
        this.concurrentConnectionCount = concurrentConnectionCount;
        this.writableConnectionPool = new ApnsConnectionPool();
        this.activeConnections = new HashSet();
        if (eventLoopGroup != null) {
            this.eventLoopGroup = eventLoopGroup;
            this.shouldShutDownEventLoopGroup = false;
        } else {
            this.eventLoopGroup = new NioEventLoopGroup();
            this.shouldShutDownEventLoopGroup = true;
        }
        if (listenerExecutorService != null) {
            this.listenerExecutorService = listenerExecutorService;
            this.shouldShutDownListenerExecutorService = false;
        } else {
            this.listenerExecutorService = Executors.newSingleThreadExecutor();
            this.shouldShutDownListenerExecutorService = true;
        }
        this.feedbackServiceClient = new FeedbackServiceClient(this.environment, this.sslContext, this.eventLoopGroup);
    }

    public synchronized void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Push manager has already been started.");
        }
        if (this.isShutDown()) {
            throw new IllegalStateException("Push manager has already been shut down and may not be restarted.");
        }
        log.info("Push manager starting.");
        for (int i = 0; i < this.concurrentConnectionCount; ++i) {
            this.startNewConnection();
        }
        this.createAndStartDispatchThread();
    }

    private void createAndStartDispatchThread() {
        this.dispatchThread = this.createDispatchThread();
        this.dispatchThread.setUncaughtExceptionHandler(new DispatchThreadExceptionHandler(this));
        this.dispatchThread.start();
    }

    protected Thread createDispatchThread() {
        return new Thread(new Runnable(){

            public void run() {
                while (PushManager.this.dispatchThreadShouldContinue) {
                    try {
                        ApnsConnection<ApnsPushNotification> connection = PushManager.this.writableConnectionPool.getNextConnection();
                        ApnsPushNotification notificationToRetry = (ApnsPushNotification)PushManager.this.retryQueue.poll();
                        if (notificationToRetry != null) {
                            connection.sendNotification(notificationToRetry);
                            continue;
                        }
                        if (PushManager.this.shutDownStarted) {
                            connection.shutdownGracefully();
                            PushManager.this.writableConnectionPool.removeConnection(connection);
                            continue;
                        }
                        connection.sendNotification((ApnsPushNotification)PushManager.this.queue.take());
                    }
                    catch (InterruptedException e) {}
                }
            }
        });
    }

    public boolean isStarted() {
        if (this.isShutDown()) {
            return false;
        }
        return this.dispatchThread != null;
    }

    public boolean isShutDown() {
        return this.shutDownStarted;
    }

    public synchronized void shutdown() throws InterruptedException {
        this.shutdown(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<T> shutdown(long timeout) throws InterruptedException {
        if (this.isShutDown()) {
            log.warn("Push manager has already been shut down; shutting down multiple times is harmless, but may indicate a problem elsewhere.");
        } else {
            log.info("Push manager shutting down.");
        }
        if (this.shutDownFinished) {
            return new ArrayList<T>(this.retryQueue);
        }
        if (!this.isStarted()) {
            throw new IllegalStateException("Push manager has not yet been started and cannot be shut down.");
        }
        this.shutDownStarted = true;
        this.dispatchThread.interrupt();
        Date deadline = timeout > 0L ? new Date(System.currentTimeMillis() + timeout) : null;
        this.waitForAllConnectionsToFinish(deadline);
        this.dispatchThreadShouldContinue = false;
        this.dispatchThread.interrupt();
        this.dispatchThread.join();
        if (deadline == null) {
            assert (this.retryQueue.isEmpty());
            assert (this.activeConnections.isEmpty());
        }
        AbstractCollection abstractCollection = this.activeConnections;
        synchronized (abstractCollection) {
            for (ApnsConnection<T> connection : this.activeConnections) {
                connection.shutdownImmediately();
            }
        }
        abstractCollection = this.rejectedNotificationListeners;
        synchronized (abstractCollection) {
            this.rejectedNotificationListeners.clear();
        }
        abstractCollection = this.failedConnectionListeners;
        synchronized (abstractCollection) {
            this.failedConnectionListeners.clear();
        }
        if (this.shouldShutDownListenerExecutorService) {
            this.listenerExecutorService.shutdown();
        }
        if (this.shouldShutDownEventLoopGroup) {
            this.eventLoopGroup.shutdownGracefully().await();
        }
        this.shutDownFinished = true;
        return new ArrayList<T>(this.retryQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRejectedNotificationListener(RejectedNotificationListener<? super T> listener) {
        if (this.isShutDown()) {
            throw new IllegalStateException("Rejected notification listeners may not be registered after a push manager has been shut down.");
        }
        ArrayList<RejectedNotificationListener<? super T>> arrayList = this.rejectedNotificationListeners;
        synchronized (arrayList) {
            this.rejectedNotificationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterRejectedNotificationListener(RejectedNotificationListener<? super T> listener) {
        ArrayList<RejectedNotificationListener<? super T>> arrayList = this.rejectedNotificationListeners;
        synchronized (arrayList) {
            return this.rejectedNotificationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFailedConnectionListener(FailedConnectionListener<? super T> listener) {
        if (this.isShutDown()) {
            throw new IllegalStateException("Failed connection listeners may not be registered after a push manager has been shut down.");
        }
        ArrayList<FailedConnectionListener<? super T>> arrayList = this.failedConnectionListeners;
        synchronized (arrayList) {
            this.failedConnectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unregisterFailedConnectionListener(FailedConnectionListener<? super T> listener) {
        ArrayList<FailedConnectionListener<? super T>> arrayList = this.failedConnectionListeners;
        synchronized (arrayList) {
            return this.failedConnectionListeners.remove(listener);
        }
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    protected BlockingQueue<T> getRetryQueue() {
        return this.retryQueue;
    }

    public List<ExpiredToken> getExpiredTokens() throws InterruptedException, FeedbackConnectionException {
        return this.getExpiredTokens(1L, TimeUnit.SECONDS);
    }

    public List<ExpiredToken> getExpiredTokens(long timeout, TimeUnit timeoutUnit) throws InterruptedException, FeedbackConnectionException {
        if (!this.isStarted()) {
            throw new IllegalStateException("Push manager has not been started yet.");
        }
        if (this.isShutDown()) {
            throw new IllegalStateException("Push manager has already been shut down.");
        }
        return this.feedbackServiceClient.getExpiredTokens(timeout, timeoutUnit);
    }

    @Override
    public void handleConnectionSuccess(ApnsConnection<T> connection) {
        log.trace("Connection succeeded: {}", connection);
        if (this.dispatchThreadShouldContinue) {
            this.writableConnectionPool.addConnection(connection);
        } else {
            connection.shutdownImmediately();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnectionFailure(ApnsConnection<T> connection, final Throwable cause) {
        log.trace("Connection failed: {}", connection, (Object)cause);
        this.removeActiveConnection(connection);
        final PushManager pushManager = this;
        ArrayList<FailedConnectionListener<? super T>> arrayList = this.failedConnectionListeners;
        synchronized (arrayList) {
            for (final FailedConnectionListener<? super T> failedConnectionListener : this.failedConnectionListeners) {
                this.listenerExecutorService.submit(new Runnable(){

                    public void run() {
                        failedConnectionListener.handleFailedConnection(pushManager, cause);
                    }
                });
            }
        }
        if (this.shouldReplaceClosedConnection()) {
            this.startNewConnection();
        }
    }

    @Override
    public void handleConnectionWritabilityChange(ApnsConnection<T> connection, boolean writable) {
        log.trace("Writability for {} changed to {}", connection, (Object)writable);
        if (writable) {
            this.writableConnectionPool.addConnection(connection);
        } else {
            this.writableConnectionPool.removeConnection(connection);
            this.dispatchThread.interrupt();
        }
    }

    @Override
    public void handleConnectionClosure(final ApnsConnection<T> connection) {
        log.trace("Connection closed: {}", connection);
        this.writableConnectionPool.removeConnection(connection);
        this.dispatchThread.interrupt();
        final PushManager pushManager = this;
        this.listenerExecutorService.execute(new Runnable(){

            public void run() {
                try {
                    connection.waitForPendingWritesToFinish();
                    if (pushManager.shouldReplaceClosedConnection()) {
                        pushManager.startNewConnection();
                    }
                    PushManager.this.removeActiveConnection(connection);
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted while waiting for closed connection's pending operations to finish.");
                }
            }
        });
    }

    @Override
    public void handleWriteFailure(ApnsConnection<T> connection, T notification, Throwable cause) {
        this.retryQueue.add(notification);
        this.dispatchThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRejectedNotification(ApnsConnection<T> connection, T rejectedNotification, RejectedNotificationReason reason) {
        log.trace("{} rejected {}: {}", new Object[]{connection, rejectedNotification, reason});
        final PushManager pushManager = this;
        ArrayList<RejectedNotificationListener<? super T>> arrayList = this.rejectedNotificationListeners;
        synchronized (arrayList) {
            for (final RejectedNotificationListener<? super T> rejectedNotificationListener : this.rejectedNotificationListeners) {
                this.listenerExecutorService.execute(new Runnable((ApnsPushNotification)rejectedNotification, reason){
                    final /* synthetic */ ApnsPushNotification val$rejectedNotification;
                    final /* synthetic */ RejectedNotificationReason val$reason;
                    {
                        this.val$rejectedNotification = apnsPushNotification;
                        this.val$reason = rejectedNotificationReason;
                    }

                    public void run() {
                        rejectedNotificationListener.handleRejectedNotification(pushManager, this.val$rejectedNotification, this.val$reason);
                    }
                });
            }
        }
    }

    @Override
    public void handleUnprocessedNotifications(ApnsConnection<T> connection, Collection<T> unprocessedNotifications) {
        log.trace("{} returned {} unprocessed notifications", connection, (Object)unprocessedNotifications.size());
        this.retryQueue.addAll(unprocessedNotifications);
        this.dispatchThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewConnection() {
        HashSet<ApnsConnection<T>> hashSet = this.activeConnections;
        synchronized (hashSet) {
            ApnsConnection connection = new ApnsConnection(this.environment, this.sslContext, this.eventLoopGroup, this);
            connection.connect();
            this.activeConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeActiveConnection(ApnsConnection<T> connection) {
        HashSet<ApnsConnection<T>> hashSet = this.activeConnections;
        synchronized (hashSet) {
            boolean removedConnection = this.activeConnections.remove(connection);
            assert (removedConnection);
            if (this.activeConnections.isEmpty()) {
                this.activeConnections.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAllConnectionsToFinish(Date deadline) throws InterruptedException {
        HashSet<ApnsConnection<T>> hashSet = this.activeConnections;
        synchronized (hashSet) {
            while (!this.activeConnections.isEmpty() && !PushManager.hasDeadlineExpired(deadline)) {
                if (deadline != null) {
                    this.activeConnections.wait(PushManager.getMillisToWaitForDeadline(deadline));
                    continue;
                }
                this.activeConnections.wait();
            }
        }
    }

    private static long getMillisToWaitForDeadline(Date deadline) {
        return Math.max(deadline.getTime() - System.currentTimeMillis(), 1L);
    }

    private static boolean hasDeadlineExpired(Date deadline) {
        if (deadline != null) {
            return System.currentTimeMillis() > deadline.getTime();
        }
        return false;
    }

    private boolean shouldReplaceClosedConnection() {
        if (this.shutDownStarted) {
            if (this.dispatchThreadShouldContinue) {
                return !this.retryQueue.isEmpty();
            }
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DispatchThreadExceptionHandler<T extends ApnsPushNotification>
    implements Thread.UncaughtExceptionHandler {
        private final Logger log = LoggerFactory.getLogger(DispatchThreadExceptionHandler.class);
        final PushManager<T> manager;

        public DispatchThreadExceptionHandler(PushManager<T> manager) {
            this.manager = manager;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.log.error("Dispatch thread died unexpectedly. Please file a bug with the exception details.", e);
            if (this.manager.isStarted()) {
                ((PushManager)this.manager).createAndStartDispatchThread();
            }
        }
    }
}

