/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.sender;

import com.rollbar.api.payload.Payload;
import com.rollbar.notifier.sender.Sender;
import com.rollbar.notifier.sender.SenderFailureStrategy;
import com.rollbar.notifier.sender.SyncSender;
import com.rollbar.notifier.sender.exception.SenderException;
import com.rollbar.notifier.sender.listener.SenderListener;
import com.rollbar.notifier.sender.result.Response;
import com.rollbar.notifier.util.ObjectsUtils;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedSender
implements Sender {
    private static final int DEFAULT_BATCH_SIZE = Integer.MAX_VALUE;
    private static final long DEFAULT_FLUSH_FREQ;
    private static final long DEFAULT_INITIAL_FLUSH_DELAY;
    private static final int DEFAULT_MAX_SEND_ATTEMPT_COUNT = 30;
    private final int batchSize;
    private final int maxSendAttemptCount;
    private Sender sender;
    private Queue<Payload> queue;
    private final SenderFailureStrategy senderFailureStrategy;
    private ScheduledExecutorService executorService;
    private SendTask sendTask;
    private static Logger LOGGER;

    BufferedSender(Builder builder) {
        this(builder, Executors.newSingleThreadScheduledExecutor(new SenderThreadFactory()));
    }

    BufferedSender(Builder builder, ScheduledExecutorService executorService) {
        ObjectsUtils.requireNonNull(builder.sender, "The sender can not be null");
        ObjectsUtils.requireNonNull(builder.queue, "The queue can not be null");
        this.batchSize = builder.batchSize;
        this.maxSendAttemptCount = 30;
        this.sender = builder.sender;
        this.queue = builder.queue;
        this.senderFailureStrategy = builder.senderFailureStrategy;
        if (this.senderFailureStrategy != null) {
            FailureListener failureListener = new FailureListener(builder.senderFailureStrategy);
            this.sender.addListener(failureListener);
        }
        this.sendTask = new SendTask(this.batchSize, this.queue, this.sender, this.senderFailureStrategy);
        this.executorService = executorService;
        this.executorService.scheduleWithFixedDelay(this.sendTask, builder.initialFlushDelay, builder.flushFreq, TimeUnit.MILLISECONDS);
    }

    public Queue<Payload> queue() {
        return this.queue;
    }

    public Sender sender() {
        return this.sender;
    }

    @Override
    public void send(Payload payload) {
        try {
            this.queue.add(payload);
        }
        catch (Exception e) {
            this.notifyError(payload, new SenderException(e));
        }
    }

    @Override
    public void addListener(SenderListener listener) {
        this.sender.addListener(listener);
    }

    @Override
    public List<SenderListener> getListeners() {
        return this.sender.getListeners();
    }

    @Override
    public void close() throws IOException {
        if (this.senderFailureStrategy != null) {
            this.senderFailureStrategy.close();
        }
        this.executorService.shutdown();
        this.sender.close();
    }

    @Override
    public void close(boolean wait) throws Exception {
        if (wait) {
            this.flushQueue();
        }
        this.close();
    }

    private void notifyError(Payload payload, Exception e) {
        for (SenderListener listener : this.sender.getListeners()) {
            listener.onError(payload, e);
        }
    }

    private void flushQueue() {
        while (this.queue.size() > 0) {
            this.sendTask.run();
        }
    }

    private boolean tooManySendAttempts(Payload payload) {
        return payload.getSendAttemptCount() >= this.maxSendAttemptCount;
    }

    static /* synthetic */ long access$600() {
        return DEFAULT_INITIAL_FLUSH_DELAY;
    }

    static /* synthetic */ long access$700() {
        return DEFAULT_FLUSH_FREQ;
    }

    static {
        DEFAULT_INITIAL_FLUSH_DELAY = DEFAULT_FLUSH_FREQ = TimeUnit.SECONDS.toMillis(5L);
        LOGGER = LoggerFactory.getLogger(BufferedSender.class);
    }

    private class FailureListener
    implements SenderListener {
        private final SenderFailureStrategy senderFailureStrategy;

        public FailureListener(SenderFailureStrategy senderFailureStrategy) {
            ObjectsUtils.requireNonNull(senderFailureStrategy, "The senderFailureStrategy cannot be null");
            this.senderFailureStrategy = senderFailureStrategy;
        }

        @Override
        public void onResponse(Payload payload, Response response) {
            this.apply(payload, this.senderFailureStrategy.getAction(payload, response));
        }

        @Override
        public void onError(Payload payload, Exception error) {
            this.apply(payload, this.senderFailureStrategy.getAction(payload, error));
        }

        private void apply(Payload payload, SenderFailureStrategy.PayloadAction action) {
            switch (action) {
                case NONE: {
                    break;
                }
                case CAN_BE_RETRIED: {
                    if (BufferedSender.this.tooManySendAttempts(payload)) {
                        LOGGER.warn("Discarding payload after " + payload.getSendAttemptCount() + " attempts");
                        break;
                    }
                    BufferedSender.this.send(payload);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown action type " + (Object)((Object)action));
                }
            }
        }
    }

    static final class SenderThreadFactory
    implements ThreadFactory {
        SenderThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("rollbar-buffered_sender");
            thread.setDaemon(true);
            return thread;
        }
    }

    static final class SendTask
    implements Runnable {
        private final int batchSize;
        private final Queue<Payload> queue;
        private final Sender sender;
        private final SenderFailureStrategy senderFailureStrategy;

        public SendTask(int batchSize, Queue<Payload> queue, Sender sender, SenderFailureStrategy senderFailureStrategy) {
            this.batchSize = batchSize;
            this.queue = queue;
            this.sender = sender;
            this.senderFailureStrategy = senderFailureStrategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Payload payload = null;
            int numberOfSent = 0;
            try {
                while (numberOfSent < this.batchSize && (payload = this.getItemFromQueue()) != null) {
                    try {
                        payload.incrementSendAttemptCount();
                        this.sender.send(payload);
                    }
                    catch (Exception exception) {}
                    continue;
                    finally {
                        ++numberOfSent;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error sending the payload.", (Throwable)e);
                for (SenderListener senderListener : this.sender.getListeners()) {
                    senderListener.onError(payload, new SenderException(e));
                }
            }
            catch (Throwable e) {
                LOGGER.error("Fatal error sending the payload.", e);
            }
        }

        private Payload getItemFromQueue() {
            if (this.isSuspended()) {
                return null;
            }
            return this.queue.poll();
        }

        private boolean isSuspended() {
            if (this.senderFailureStrategy == null) {
                return false;
            }
            return this.senderFailureStrategy.isSendingSuspended();
        }
    }

    public static final class Builder {
        private int batchSize = Integer.MAX_VALUE;
        private long initialFlushDelay = BufferedSender.access$600();
        private long flushFreq = BufferedSender.access$700();
        private Queue<Payload> queue;
        private Sender sender = null;
        private SenderFailureStrategy senderFailureStrategy;

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder initialFlushDelay(long initialFlushDelay) {
            this.initialFlushDelay = initialFlushDelay;
            return this;
        }

        public Builder flushFreq(long flushFreq) {
            this.flushFreq = flushFreq;
            return this;
        }

        public Builder queue(Queue<Payload> queue) {
            this.queue = queue;
            return this;
        }

        public Builder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        public Builder senderFailureStrategy(SenderFailureStrategy strategy) {
            this.senderFailureStrategy = strategy;
            return this;
        }

        public BufferedSender build() {
            if (this.queue == null) {
                this.queue = new ConcurrentLinkedQueue<Payload>();
            }
            if (this.sender == null) {
                this.sender = new SyncSender.Builder().build();
            }
            return new BufferedSender(this);
        }
    }
}

