/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.truncation;

import com.rollbar.api.payload.Payload;
import com.rollbar.api.payload.data.Data;
import com.rollbar.api.payload.data.body.Body;
import com.rollbar.api.payload.data.body.BodyContent;
import com.rollbar.api.payload.data.body.ExceptionInfo;
import com.rollbar.api.payload.data.body.Frame;
import com.rollbar.api.payload.data.body.Trace;
import com.rollbar.api.payload.data.body.TraceChain;
import com.rollbar.notifier.truncation.FramesStrategy;
import com.rollbar.notifier.truncation.TruncationStrategy;
import java.util.ArrayList;
import java.util.List;

class MinBodyStrategy
implements TruncationStrategy {
    private static final FramesStrategy FRAMES_STRATEGY = new FramesStrategy(1, 1);
    private static final int MAX_EXCEPTION_MSG_LENGTH = 255;

    MinBodyStrategy() {
    }

    @Override
    public TruncationStrategy.TruncationResult<Payload> truncate(Payload payload) {
        if (payload == null || payload.getData() == null || payload.getData().getBody() == null) {
            return TruncationStrategy.TruncationResult.none();
        }
        BodyContent content = payload.getData().getBody().getContents();
        if (content instanceof TraceChain) {
            return this.tryTruncateChain(payload, (TraceChain)content);
        }
        if (content instanceof Trace) {
            return this.tryTruncateTrace(payload, (Trace)content);
        }
        return TruncationStrategy.TruncationResult.none();
    }

    private TruncationStrategy.TruncationResult<Payload> tryTruncateTrace(Payload payload, Trace trace) {
        TruncationStrategy.TruncationResult<Trace> traceResult = this.truncateTrace(trace);
        if (traceResult.wasTruncated) {
            return this.payloadWithContent(payload, (BodyContent)traceResult.value);
        }
        return TruncationStrategy.TruncationResult.none();
    }

    private TruncationStrategy.TruncationResult<Payload> tryTruncateChain(Payload payload, TraceChain chain) {
        boolean truncated = false;
        ArrayList<Object> newTraces = new ArrayList<Object>();
        for (Trace trace : chain.getTraces()) {
            TruncationStrategy.TruncationResult<Trace> traceResult = this.truncateTrace(trace);
            if (traceResult.wasTruncated) {
                newTraces.add(traceResult.value);
                truncated = true;
                continue;
            }
            newTraces.add(trace);
        }
        if (truncated) {
            return this.payloadWithContent(payload, (BodyContent)new TraceChain.Builder(chain).traces(newTraces).build());
        }
        return TruncationStrategy.TruncationResult.none();
    }

    private TruncationStrategy.TruncationResult<Payload> payloadWithContent(Payload payload, BodyContent newContent) {
        Body body = new Body.Builder(payload.getData().getBody()).bodyContent(newContent).build();
        Data data = new Data.Builder(payload.getData()).body(body).build();
        Payload newPayload = new Payload.Builder(payload).data(data).build();
        return TruncationStrategy.TruncationResult.truncated(newPayload);
    }

    private TruncationStrategy.TruncationResult<Trace> truncateTrace(Trace trace) {
        boolean truncated = false;
        List<Frame> frames = trace.getFrames();
        if (trace.getFrames().size() > FRAMES_STRATEGY.totalFramesToKeep()) {
            frames = FRAMES_STRATEGY.truncateFrames(trace.getFrames());
            truncated = true;
        }
        ExceptionInfo exception = trace.getException();
        TruncationStrategy.TruncationResult<ExceptionInfo> result = this.truncateException(exception);
        if (result.wasTruncated) {
            exception = (ExceptionInfo)result.value;
            truncated = true;
        }
        if (truncated) {
            Trace newTrace = new Trace.Builder(trace).frames(frames).exception(exception).build();
            return TruncationStrategy.TruncationResult.truncated(newTrace);
        }
        return TruncationStrategy.TruncationResult.none();
    }

    private TruncationStrategy.TruncationResult<ExceptionInfo> truncateException(ExceptionInfo exception) {
        if (exception != null) {
            String message;
            boolean truncated = false;
            String description = exception.getDescription();
            if (description != null) {
                description = null;
                truncated = true;
            }
            if ((message = exception.getMessage()) != null && message.length() > 255) {
                message = message.substring(0, 255);
                truncated = true;
            }
            if (truncated) {
                exception = new ExceptionInfo.Builder(exception).description(description).message(message).build();
                return TruncationStrategy.TruncationResult.truncated(exception);
            }
        }
        return TruncationStrategy.TruncationResult.none();
    }
}

