/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.Address;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.Base64Utils;
import com.sap.db.util.BufferUtils;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.SSLUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import javax.security.cert.X509Certificate;

@NotThreadSafe
public abstract class SecureSession
extends Session {
    private static final int MAX_SSL_RETRY_COUNT = 500;
    private final boolean _validateCertificate;
    private final String _hostNameInCertificate;
    private final String _keyStore;
    private final String _keyStoreType;
    private final String _keyStorePasswd;
    private final String _sslKeyStore;
    private final String _trustStore;
    private final String _trustStoreType;
    private final String _trustStorePasswd;
    private final String _sslTrustStore;
    private final String _sniHostname;
    private final boolean _sslSniRequest;
    private final String _sslMinProtocolVersion;
    private final String _sslMaxProtocolVersion;
    private final X509Certificate[] _peerCertificateChain;
    private final Certificate[] _peerCertificates;
    @GuardedBy(value="Socket._socketLock")
    private SSLEngine _sslEngine;
    @GuardedBy(value="Socket._socketLock")
    private SSLSession _sslSession;
    @GuardedBy(value="Socket._socketLock")
    private ByteBuffer _sendBuffer;
    @GuardedBy(value="Socket._socketLock")
    private ByteBuffer _receiveBuffer;
    @GuardedBy(value="Socket._socketLock")
    private ByteBuffer _applicationBuffer;

    SecureSession(ConnectionSapDB connection, Address address) throws RTEException {
        super(connection, address);
        this._validateCertificate = this._connectionProperties.getBooleanProperty(ConnectionProperty.VALIDATE_CERTIFICATE);
        this._hostNameInCertificate = this._connectionProperties.getProperty(ConnectionProperty.HOST_NAME_IN_CERTIFICATE);
        this._keyStore = this._connectionProperties.getProperty(ConnectionProperty.KEY_STORE);
        this._keyStoreType = this._connectionProperties.getProperty(ConnectionProperty.KEY_STORE_TYPE);
        this._keyStorePasswd = this._connectionProperties.getProperty(ConnectionProperty.KEY_STORE_PASSWD);
        this._sslKeyStore = this._connectionProperties.getProperty(ConnectionProperty.SSL_KEY_STORE);
        this._trustStore = this._connectionProperties.getProperty(ConnectionProperty.TRUST_STORE);
        this._trustStoreType = this._connectionProperties.getProperty(ConnectionProperty.TRUST_STORE_TYPE);
        this._trustStorePasswd = this._connectionProperties.getProperty(ConnectionProperty.TRUST_STORE_PASSWD);
        this._sslTrustStore = this._connectionProperties.getProperty(ConnectionProperty.SSL_TRUST_STORE);
        this._sniHostname = this._connectionProperties.getProperty(ConnectionProperty.SNI_HOSTNAME);
        this._sslSniRequest = this._connectionProperties.getBooleanProperty(ConnectionProperty.SSL_SNI_REQUEST);
        this._sslMinProtocolVersion = this._connectionProperties.getProperty(ConnectionProperty.SSL_MIN_PROTOCOL_VERSION);
        this._sslMaxProtocolVersion = this._connectionProperties.getProperty(ConnectionProperty.SSL_MAX_PROTOCOL_VERSION);
        Object[] obj = this._sslInit();
        if (Driver.getJavaVersion() <= 14) {
            this._peerCertificateChain = (X509Certificate[])obj;
            this._peerCertificates = null;
        } else {
            this._peerCertificateChain = null;
            this._peerCertificates = (Certificate[])obj;
        }
    }

    @Override
    protected X509Certificate[] _getPeerCertificateChain() {
        return this._peerCertificateChain;
    }

    @Override
    protected Certificate[] _getPeerCertificates() {
        return this._peerCertificates;
    }

    protected static int _convertSslProtocolVersionConnectionPropertyToTlsVersion(String sslProtocolVersion, boolean isForMax) {
        int ret;
        int defaul;
        int n = defaul = isForMax ? Integer.MAX_VALUE : 0;
        if (sslProtocolVersion == null || sslProtocolVersion.isEmpty()) {
            return defaul;
        }
        if (isForMax && sslProtocolVersion.equalsIgnoreCase("max")) {
            return defaul;
        }
        int len = sslProtocolVersion.length();
        if (len != 5 || !sslProtocolVersion.regionMatches(true, 0, "tls", 0, 3)) {
            return defaul;
        }
        try {
            ret = Integer.parseInt(sslProtocolVersion.substring(3));
        }
        catch (NumberFormatException e) {
            return defaul;
        }
        return ret;
    }

    protected static int _convertSupportedProtocolToTlsVersion(String supportedProtocol) {
        int ret;
        int defaul = -1;
        if (supportedProtocol == null || supportedProtocol.isEmpty()) {
            return defaul;
        }
        if (!supportedProtocol.startsWith("TLSv")) {
            return defaul;
        }
        int len = supportedProtocol.length();
        switch (len) {
            case 5: {
                char c1 = supportedProtocol.charAt(4);
                if (c1 < '0' || c1 > '9') {
                    return defaul;
                }
                ret = Character.getNumericValue((int)c1) * 10;
                break;
            }
            case 7: {
                char c1 = supportedProtocol.charAt(4);
                char c2 = supportedProtocol.charAt(6);
                if (c1 < '0' || c1 > '9' || c2 < '0' || c2 > '9') {
                    return defaul;
                }
                ret = Character.getNumericValue((int)c1) * 10 + Character.getNumericValue((int)c2);
                break;
            }
            default: {
                return defaul;
            }
        }
        return ret;
    }

    protected static boolean _enableProtocolVersion(String supportedProtocol, int sslMin, int sslMax) {
        int tlsVal = SecureSession._convertSupportedProtocolToTlsVersion(supportedProtocol);
        return tlsVal != -1 && tlsVal >= sslMin && tlsVal <= sslMax;
    }

    private Object[] _sslInit() throws RTEException {
        X509Certificate[] peerCertificateChain = null;
        Certificate[] peerCertificates = null;
        String host = ((Address)this._address.get()).getHost();
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        SSLContext sslContext = null;
        try {
            if (!this._validateCertificate) {
                keyManagers = null;
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(java.security.cert.X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(java.security.cert.X509Certificate[] certs, String authType) {
                    }
                }};
            } else if (this._isSystemDefaultUsed()) {
                sslContext = SSLContext.getDefault();
            } else {
                KeyManagerFactory keyManagerFactory = this._getKeyManagerFactory(host);
                TrustManagerFactory trustManagerFactory = this._getTrustManagerFactory(host);
                keyManagers = keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null;
                TrustManager[] trustManagerArray = trustManagers = trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null;
            }
            if (sslContext == null) {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
            }
            this._sslEngine = sslContext.createSSLEngine();
            this._sslEngine.setUseClientMode(true);
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            String[] supportedProtocols = this._sslEngine.getSupportedProtocols();
            int sslMin = SecureSession._convertSslProtocolVersionConnectionPropertyToTlsVersion(this._sslMinProtocolVersion, false);
            int sslMax = SecureSession._convertSslProtocolVersionConnectionPropertyToTlsVersion(this._sslMaxProtocolVersion, true);
            for (String supportedProtocol : supportedProtocols) {
                if (!SecureSession._enableProtocolVersion(supportedProtocol, sslMin, sslMax)) continue;
                enabledProtocols.add(supportedProtocol);
            }
            this._sslEngine.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            if (this._sslSniRequest) {
                SNIHostName sniServerName = new SNIHostName(this._sniHostname != null ? this._sniHostname : host);
                SSLParameters sslParameters = this._sslEngine.getSSLParameters();
                sslParameters.setServerNames(Collections.singletonList(sniServerName));
                this._sslEngine.setSSLParameters(sslParameters);
            }
            this._doHandshake();
            this._sslSession = this._sslEngine.getSession();
            int packetBufferSize = this._sslSession.getPacketBufferSize();
            int applicationBufferSize = this._sslSession.getApplicationBufferSize();
            this._sendBuffer = ByteBuffer.allocate(packetBufferSize);
            this._receiveBuffer = ByteBuffer.allocate(packetBufferSize);
            this._applicationBuffer = ByteBuffer.allocate(applicationBufferSize);
            BufferUtils.flip(this._applicationBuffer);
            try {
                peerCertificates = this._sslSession.getPeerCertificates();
                if (Driver.getJavaVersion() <= 14) {
                    peerCertificateChain = this._sslSession.getPeerCertificateChain();
                }
            }
            catch (SSLPeerUnverifiedException e) {
                peerCertificates = new Certificate[]{};
            }
            this._validateHostName(peerCertificates, host);
        }
        catch (NoSuchAlgorithmException e) {
            SQLException sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nosuchalgorithm", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", host, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (KeyManagementException e) {
            SQLException sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagementexception", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", host, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (RTEException e) {
            this._throwRTEException(e);
        }
        if (Driver.getJavaVersion() <= 14) {
            return peerCertificateChain;
        }
        return peerCertificates;
    }

    private boolean _isSystemDefaultUsed() {
        return this._keyStore == null && this._keyStoreType == null && this._keyStorePasswd == null && this._sslKeyStore == null && this._trustStore == null && this._trustStorePasswd == null && this._trustStoreType == null && this._sslTrustStore == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManagerFactory _getKeyManagerFactory(String hostName) throws RTEException {
        SQLException sqlex;
        char[] passwd;
        KeyStore ks;
        KeyManagerFactory kmf;
        block31: {
            String type;
            String algorithm;
            String keyStoreFileName = this._getKeyStoreFileName();
            if (this._sslKeyStore == null && keyStoreFileName == null) {
                return null;
            }
            kmf = null;
            ks = null;
            if (this._sslKeyStore != null) {
                algorithm = "SunX509";
                type = "JKS";
                passwd = "".toCharArray();
            } else {
                algorithm = KeyManagerFactory.getDefaultAlgorithm();
                type = this._getKeyStoreType();
                passwd = this._getKeyStorePasswd().toCharArray();
            }
            try {
                kmf = KeyManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactorynodefault", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                ks = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystore.create", type, e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                if (this._sslKeyStore != null) {
                    ks.load(null);
                    List<Certificate> certs = SecureSession._createCertificatesFromPEM(this._sslKeyStore);
                    List<PrivateKey> keys = SecureSession._createPrivateKeysFromPEM(this._sslKeyStore);
                    if (!keys.isEmpty()) {
                        ks.setKeyEntry("key-alias", keys.get(0), passwd, certs.toArray(new Certificate[0]));
                    }
                    break block31;
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(keyStoreFileName);
                    ks.load(fis, passwd);
                }
                catch (FileNotFoundException e) {
                    sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystorefilenotfound", e.getMessage());
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.nosuchalgorithm", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.certificate", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (IOException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keystoreloadfailed.ioexception", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (InvalidKeySpecException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.invalidkeyspec", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (KeyStoreException e) {
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, "Key manager initialization failed: " + e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, e);
            }
        }
        try {
            kmf.init(ks, passwd);
        }
        catch (KeyStoreException e) {
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, "Key manager initialization failed: " + e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, e);
        }
        catch (UnrecoverableKeyException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactory.unrecoverablekey", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        catch (NoSuchAlgorithmException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.keymanagerfactory.nosuchalgorithm", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        return kmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManagerFactory _getTrustManagerFactory(String hostName) throws RTEException {
        SQLException sqlex;
        KeyStore ks;
        TrustManagerFactory tmf;
        block28: {
            char[] passwd;
            String type;
            String algorithm;
            String trustStoreFileName = this._getTrustStoreFileName();
            if (this._sslTrustStore == null && trustStoreFileName == null) {
                return null;
            }
            tmf = null;
            ks = null;
            if (this._sslTrustStore != null) {
                algorithm = "SunX509";
                type = "JKS";
                passwd = null;
            } else {
                algorithm = TrustManagerFactory.getDefaultAlgorithm();
                type = this._getTrustStoreType();
                String passwdString = this._getTrustStorePasswd();
                passwd = passwdString != null ? passwdString.toCharArray() : null;
            }
            try {
                tmf = TrustManagerFactory.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactorynodefault", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                ks = KeyStore.getInstance(type);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststore.create", type, e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                if (this._sslTrustStore != null) {
                    ks.load(null);
                    List<Certificate> certs = SecureSession._createCertificatesFromPEM(this._sslTrustStore);
                    int n = certs.size();
                    for (int i = 0; i < n; ++i) {
                        ks.setCertificateEntry("cert-alias-" + i, certs.get(i));
                    }
                    break block28;
                }
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(trustStoreFileName);
                    ks.load(fis, passwd);
                }
                catch (FileNotFoundException e) {
                    sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststorefilenotfound", e.getMessage());
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (NoSuchAlgorithmException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.nosuchalgorithm", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (CertificateException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.certificate", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (IOException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.truststoreloadfailed.ioexception", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            catch (KeyStoreException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactory.keystore", e.getMessage());
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
        }
        try {
            tmf.init(ks);
        }
        catch (KeyStoreException e) {
            sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.trustmanagerfactory.keystore", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
        }
        return tmf;
    }

    private String _getKeyStoreFileName() {
        return this._keyStore != null ? this._keyStore : System.getProperty("javax.net.ssl.keyStore");
    }

    private String _getKeyStoreType() {
        return this._keyStoreType != null ? this._keyStoreType : "JKS";
    }

    private String _getKeyStorePasswd() {
        if (this._keyStorePasswd != null) {
            return this._keyStorePasswd;
        }
        String syspasswd = System.getProperty("javax.net.ssl.keyStorePassword");
        if (syspasswd != null) {
            return syspasswd;
        }
        return "";
    }

    private String _getTrustStoreFileName() {
        return this._trustStore != null ? this._trustStore : System.getProperty("javax.net.ssl.trustStore");
    }

    private String _getTrustStoreType() {
        return this._trustStoreType != null ? this._trustStoreType : "JKS";
    }

    private String _getTrustStorePasswd() {
        return this._trustStorePasswd != null ? this._trustStorePasswd : System.getProperty("javax.net.ssl.trustStorePassword");
    }

    private void _validateHostName(Certificate[] certs, String hostName) throws RTEException {
        if (!"*".equals(this._hostNameInCertificate) && this._validateCertificate) {
            SQLException sqlex;
            if (certs.length == 0) {
                sqlex = SQLExceptionSapDB.newInstance("error.ssl.nocertificatefound", new String[0]);
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
            try {
                HostnameVerifier hostnameVerifier;
                java.security.cert.X509Certificate x509cert = (java.security.cert.X509Certificate)certs[0];
                X500Principal principal = x509cert.getSubjectX500Principal();
                String rfc2253name = principal.getName("RFC2253");
                Collection<List<?>> alternativenames = x509cert.getSubjectAlternativeNames();
                if (!(SSLUtils.validateHostName(rfc2253name, alternativenames, this._hostNameInCertificate == null ? hostName : this._hostNameInCertificate) || (hostnameVerifier = Driver.getHostnameVerifier()) != null && hostnameVerifier.verify(hostName, this._sslSession))) {
                    sqlex = SQLExceptionSapDB.newInstance("error.ssl.hostnameverificationfailed", rfc2253name, this._hostNameInCertificate == null ? hostName : this._hostNameInCertificate);
                    this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
                }
            }
            catch (ClassCastException | CertificateParsingException e) {
                sqlex = SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nox509certificate", new String[0]);
                this._throwRTEException(MessageTranslator.translate("error.host.connect", hostName, sqlex.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSTART_REQUIRED, sqlex);
            }
        }
    }

    private static List<Certificate> _createCertificatesFromPEM(String pem) throws CertificateException {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        List<byte[]> certsBytes = Base64Utils.decodeCertificates(pem);
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        for (byte[] certBytes : certsBytes) {
            Certificate cert = factory.generateCertificate(new ByteArrayInputStream(certBytes));
            certs.add(cert);
        }
        return certs;
    }

    private static List<PrivateKey> _createPrivateKeysFromPEM(String pem) throws NoSuchAlgorithmException, InvalidKeySpecException {
        ArrayList<PrivateKey> keys = new ArrayList<PrivateKey>();
        List<byte[]> keysBytes = Base64Utils.decodePrivateKeys(pem);
        KeyFactory factory = KeyFactory.getInstance("RSA");
        for (byte[] keyBytes : keysBytes) {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            PrivateKey key = factory.generatePrivate(keySpec);
            keys.add(key);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void _doHandshake() throws RTEException {
        boolean on = this._tracer.on();
        SSLEngineResult.HandshakeStatus handshakeStatus = this._sslEngine.getHandshakeStatus();
        int underflowCount = 0;
        try {
            if (on) {
                this._tracer.printSSLMessage("SSL handshake: begin: " + (Object)((Object)handshakeStatus));
            }
            this._sslEngine.beginHandshake();
            handshakeStatus = this._sslEngine.getHandshakeStatus();
            if (on) {
                this._tracer.printSSLMessage("\tbeginHandshake: " + (Object)((Object)handshakeStatus));
            }
            SSLSession handshakeSession = this._sslEngine.getSession();
            int packetBufferSize = handshakeSession.getPacketBufferSize();
            int applicationBufferSize = handshakeSession.getApplicationBufferSize();
            ByteBuffer sendBuffer = ByteBuffer.allocate(packetBufferSize);
            ByteBuffer receiveBuffer = ByteBuffer.allocate(packetBufferSize);
            BufferUtils.flip(receiveBuffer);
            ByteBuffer applicationBuffer = ByteBuffer.allocate(applicationBufferSize);
            block25: while (true) {
                switch (handshakeStatus) {
                    case NOT_HANDSHAKING: 
                    case FINISHED: {
                        return;
                    }
                    case NEED_WRAP: {
                        SSLEngineResult result = this._sslEngine.wrap(applicationBuffer, sendBuffer);
                        handshakeStatus = result.getHandshakeStatus();
                        if (on) {
                            this._tracer.printSSLMessage("\twrap: " + result.toString().replace('\n', ' '));
                        }
                        switch (result.getStatus()) {
                            case OK: {
                                break;
                            }
                            case BUFFER_UNDERFLOW: {
                                throw new SSLException("Unexpected buffer underflow");
                            }
                            case BUFFER_OVERFLOW: {
                                throw new SSLException("Unexpected buffer overflow");
                            }
                            case CLOSED: {
                                if (on) {
                                    this._tracer.printSSLMessage("Unexpected closed status");
                                }
                                this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLSEND_LINE_DOWN);
                                break;
                            }
                            default: {
                                throw new SSLException("Unknown result status: " + (Object)((Object)result.getStatus()));
                            }
                        }
                        BufferUtils.flip(sendBuffer);
                        if (on) {
                            this._tracer.printSSLPacket("SSL send", sendBuffer.array(), 0, sendBuffer.limit());
                        }
                        this._writeBytes(sendBuffer.array(), sendBuffer.limit(), false);
                        BufferUtils.clear(sendBuffer);
                        continue block25;
                    }
                    case NEED_UNWRAP: {
                        int readCount;
                        SSLEngineResult result;
                        if (receiveBuffer.remaining() == 0) {
                            BufferUtils.clear(receiveBuffer);
                            readCount = this._readBytes(receiveBuffer.array(), 0, receiveBuffer.capacity(), false);
                            if (readCount == -1) {
                                this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                            }
                            if (on) {
                                this._tracer.printSSLPacket("SSL receive", receiveBuffer.array(), 0, readCount);
                            }
                            BufferUtils.position(receiveBuffer, readCount);
                            BufferUtils.flip(receiveBuffer);
                        }
                        int i = 0;
                        while (true) {
                            if (i >= 500) continue block25;
                            result = this._sslEngine.unwrap(receiveBuffer, applicationBuffer);
                            handshakeStatus = result.getHandshakeStatus();
                            if (on) {
                                this._tracer.printSSLMessage("\tunwrap: " + result.toString().replace('\n', ' '));
                            }
                            switch (result.getStatus()) {
                                case OK: {
                                    continue block25;
                                }
                                case BUFFER_UNDERFLOW: {
                                    if (on) {
                                        ++underflowCount;
                                    }
                                    receiveBuffer.compact();
                                    readCount = this._readBytes(receiveBuffer.array(), receiveBuffer.position(), receiveBuffer.capacity() - receiveBuffer.position(), false);
                                    if (readCount == -1) {
                                        this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                                    }
                                    if (on) {
                                        this._tracer.printSSLPacket("SSL receive", receiveBuffer.array(), receiveBuffer.position(), readCount);
                                    }
                                    BufferUtils.position(receiveBuffer, receiveBuffer.position() + readCount);
                                    BufferUtils.flip(receiveBuffer);
                                    break;
                                }
                                case BUFFER_OVERFLOW: {
                                    throw new SSLException("Unexpected buffer overflow");
                                }
                                case CLOSED: {
                                    if (on) {
                                        this._tracer.printSSLMessage("Unexpected closed status");
                                    }
                                    this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                                    break;
                                }
                                default: {
                                    throw new SSLException("Unknown result status: " + (Object)((Object)result.getStatus()));
                                }
                            }
                            ++i;
                        }
                    }
                    case NEED_TASK: {
                        this._sslEngine.getDelegatedTask().run();
                        handshakeStatus = this._sslEngine.getHandshakeStatus();
                        if (!on) continue block25;
                        this._tracer.printSSLMessage("\ttask: " + (Object)((Object)handshakeStatus));
                        continue block25;
                    }
                    default: {
                        throw new SSLHandshakeException("Unknown handshake status: " + (Object)((Object)handshakeStatus));
                    }
                }
                break;
            }
        }
        catch (SSLHandshakeException e) {
            SQLException sqlex = e.getMessage().contains("PKIX path building failed") ? SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.certificatepath", e.getMessage()) : SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.handshake", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", this._address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
            return;
        }
        catch (SSLException e) {
            SQLException sqlex = e.getMessage().contains("Received fatal alert: internal_error") ? SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.nosslsupport", e.getMessage()) : SQLExceptionSapDB.newInstance((Throwable)e, "error.ssl.handshake", e.getMessage());
            this._throwRTEException(MessageTranslator.translate("error.host.connect", this._address.toString(), e.getMessage(), RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode()), RteReturnCode.SQLSERVER_OR_DB_UNKNOWN, RteReturnCode.SQLSTART_REQUIRED.getCommunicationErrorCode(), sqlex);
            return;
        }
        finally {
            if (on) {
                this._tracer.printSSLMessage("SSL handshake: end: " + (Object)((Object)handshakeStatus) + " u=" + underflowCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _encodeBytes(byte[] buffer, int len, boolean isPing) throws RTEException {
        boolean on = this._tracer.on();
        SSLEngineResult.HandshakeStatus handshakeStatus = this._sslEngine.getHandshakeStatus();
        ByteBuffer src = ByteBuffer.wrap(buffer, 0, len);
        try {
            if (on) {
                this._tracer.printSSLMessage("SSL send: begin: " + (Object)((Object)handshakeStatus));
            }
            BufferUtils.clear(this._sendBuffer);
            while (src.remaining() > 0) {
                switch (handshakeStatus) {
                    case NOT_HANDSHAKING: 
                    case FINISHED: 
                    case NEED_WRAP: {
                        break;
                    }
                    case NEED_UNWRAP: 
                    case NEED_TASK: {
                        throw new SSLHandshakeException("Unexpected handshake status: " + (Object)((Object)handshakeStatus));
                    }
                    default: {
                        throw new SSLHandshakeException("Unknown handshake status: " + (Object)((Object)handshakeStatus));
                    }
                }
                SSLEngineResult result = this._sslEngine.wrap(src, this._sendBuffer);
                handshakeStatus = result.getHandshakeStatus();
                if (on) {
                    this._tracer.printSSLMessage("\t" + result.toString().replace('\n', ' '));
                }
                switch (result.getStatus()) {
                    case OK: {
                        break;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new SSLException("Unexpected buffer underflow");
                    }
                    case BUFFER_OVERFLOW: {
                        throw new SSLException("Unexpected buffer overflow");
                    }
                    case CLOSED: {
                        if (on) {
                            this._tracer.printSSLMessage("Unexpected closed status");
                        }
                        this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLSEND_LINE_DOWN);
                        break;
                    }
                    default: {
                        throw new SSLException("Unknown result status: " + (Object)((Object)result.getStatus()));
                    }
                }
                BufferUtils.flip(this._sendBuffer);
                if (on) {
                    this._tracer.printSSLPacket("SSL send", this._sendBuffer.array(), 0, this._sendBuffer.limit());
                }
                this._writeBytes(this._sendBuffer.array(), this._sendBuffer.limit(), isPing);
                BufferUtils.clear(this._sendBuffer);
            }
        }
        catch (SSLException e) {
            this._throwRTEException(MessageTranslator.translate("error.wrap.failed", e.getMessage()), RteReturnCode.SQLSEND_LINE_DOWN, e);
        }
        finally {
            if (on) {
                this._tracer.printSSLMessage("SSL send: end: " + (Object)((Object)handshakeStatus));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _decodeBytes(byte[] buffer, int off, int len) throws RTEException {
        boolean on = this._tracer.on();
        SSLEngineResult.HandshakeStatus handshakeStatus = this._sslEngine.getHandshakeStatus();
        int pos = off;
        int remaining = len;
        int underflowCount = 0;
        int overflowCount = 0;
        try {
            if (on) {
                this._tracer.printSSLMessage("SSL receive: begin: " + (Object)((Object)handshakeStatus));
            }
            BufferUtils.clear(this._receiveBuffer);
            while (remaining > 0) {
                if (this._applicationBuffer.remaining() == 0) {
                    BufferUtils.clear(this._applicationBuffer);
                    BufferUtils.clear(this._receiveBuffer);
                    int readCount = this._readBytes(this._receiveBuffer.array(), 0, this._receiveBuffer.capacity(), false);
                    if (readCount == -1) {
                        this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                    }
                    if (on) {
                        this._tracer.printSSLPacket("SSL receive", this._receiveBuffer.array(), 0, readCount);
                    }
                    BufferUtils.position(this._receiveBuffer, readCount);
                    BufferUtils.flip(this._receiveBuffer);
                    block16: while (this._receiveBuffer.remaining() > 0) {
                        block17: for (int i = 0; i < 500; ++i) {
                            handshakeStatus = this._sslEngine.getHandshakeStatus();
                            switch (handshakeStatus) {
                                case NOT_HANDSHAKING: 
                                case FINISHED: 
                                case NEED_UNWRAP: {
                                    break;
                                }
                                case NEED_WRAP: 
                                case NEED_TASK: {
                                    throw new SSLHandshakeException("Unexpected handshake status: " + (Object)((Object)handshakeStatus));
                                }
                                default: {
                                    throw new SSLHandshakeException("Unknown handshake status: " + (Object)((Object)handshakeStatus));
                                }
                            }
                            SSLEngineResult result = this._sslEngine.unwrap(this._receiveBuffer, this._applicationBuffer);
                            handshakeStatus = result.getHandshakeStatus();
                            if (on) {
                                this._tracer.printSSLMessage("\t" + result.toString().replace('\n', ' '));
                            }
                            switch (result.getStatus()) {
                                case OK: {
                                    continue block16;
                                }
                                case BUFFER_UNDERFLOW: {
                                    if (on) {
                                        ++underflowCount;
                                    }
                                    this._receiveBuffer.compact();
                                    readCount = this._readBytes(this._receiveBuffer.array(), this._receiveBuffer.position(), this._receiveBuffer.capacity() - this._receiveBuffer.position(), false);
                                    if (readCount == -1) {
                                        this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                                    }
                                    if (on) {
                                        this._tracer.printSSLPacket("SSL receive", this._receiveBuffer.array(), this._receiveBuffer.position(), readCount);
                                    }
                                    BufferUtils.position(this._receiveBuffer, this._receiveBuffer.position() + readCount);
                                    BufferUtils.flip(this._receiveBuffer);
                                    continue block17;
                                }
                                case BUFFER_OVERFLOW: {
                                    if (on) {
                                        ++overflowCount;
                                    }
                                    BufferUtils.flip(this._applicationBuffer);
                                    ByteBuffer temp = ByteBuffer.allocate(this._applicationBuffer.capacity() * 2);
                                    temp.put(this._applicationBuffer);
                                    this._applicationBuffer = temp;
                                    continue block17;
                                }
                                case CLOSED: {
                                    if (on) {
                                        this._tracer.printSSLMessage("Unexpected closed status");
                                    }
                                    this._throwRTEException(MessageTranslator.translate("error.objectisclosed", this.toString()), RteReturnCode.SQLRECEIVE_LINE_DOWN);
                                    continue block17;
                                }
                                default: {
                                    throw new SSLException("Unknown result status: " + (Object)((Object)result.getStatus()));
                                }
                            }
                        }
                    }
                    BufferUtils.flip(this._applicationBuffer);
                }
                int copiedCount = Math.min(remaining, this._applicationBuffer.remaining());
                this._applicationBuffer.get(buffer, pos, copiedCount);
                pos += copiedCount;
                remaining -= copiedCount;
            }
        }
        catch (SSLException e) {
            this._throwRTEException(MessageTranslator.translate("error.unwrap.failed", e.getMessage()), RteReturnCode.SQLRECEIVE_LINE_DOWN, e);
        }
        finally {
            if (on) {
                this._tracer.printSSLMessage("SSL receive: end: " + (Object)((Object)handshakeStatus) + " u=" + underflowCount + " o=" + overflowCount);
            }
        }
        return len;
    }
}

