/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.mapper;

import com.sdicons.json.helper.HelperRepository;
import com.sdicons.json.mapper.MapperException;
import com.sdicons.json.mapper.helper.ComplexMapperHelper;
import com.sdicons.json.mapper.helper.SimpleMapperHelper;
import com.sdicons.json.mapper.helper.impl.ArrayMapper;
import com.sdicons.json.mapper.helper.impl.BigDecimalMapper;
import com.sdicons.json.mapper.helper.impl.BigIntegerMapper;
import com.sdicons.json.mapper.helper.impl.BooleanMapper;
import com.sdicons.json.mapper.helper.impl.ByteMapper;
import com.sdicons.json.mapper.helper.impl.CharacterMapper;
import com.sdicons.json.mapper.helper.impl.CollectionMapper;
import com.sdicons.json.mapper.helper.impl.DateMapper;
import com.sdicons.json.mapper.helper.impl.DoubleMapper;
import com.sdicons.json.mapper.helper.impl.EnumMapper;
import com.sdicons.json.mapper.helper.impl.FloatMapper;
import com.sdicons.json.mapper.helper.impl.IntegerMapper;
import com.sdicons.json.mapper.helper.impl.LongMapper;
import com.sdicons.json.mapper.helper.impl.MapMapper;
import com.sdicons.json.mapper.helper.impl.ObjectMapper;
import com.sdicons.json.mapper.helper.impl.ObjectMapperDirect;
import com.sdicons.json.mapper.helper.impl.ShortMapper;
import com.sdicons.json.mapper.helper.impl.StringMapper;
import com.sdicons.json.model.JSONNull;
import com.sdicons.json.model.JSONValue;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONMapper {
    private static HelperRepository<SimpleMapperHelper> repo = new HelperRepository();

    public static Object toJava(JSONValue aValue, Class aPojoClass) throws MapperException {
        if (aValue == null) {
            String lMsg = "Mapper does not support null values.";
            throw new MapperException("Mapper does not support null values.");
        }
        if (aValue.isNull()) {
            return null;
        }
        if (aPojoClass.isArray()) {
            ArrayMapper arrayMapper = new ArrayMapper();
            return arrayMapper.toJava(aValue, aPojoClass);
        }
        if (aPojoClass == Boolean.TYPE) {
            aPojoClass = Boolean.class;
        } else if (aPojoClass == Byte.TYPE) {
            aPojoClass = Byte.class;
        } else if (aPojoClass == Short.TYPE) {
            aPojoClass = Short.class;
        } else if (aPojoClass == Integer.TYPE) {
            aPojoClass = Integer.class;
        } else if (aPojoClass == Long.TYPE) {
            aPojoClass = Long.class;
        } else if (aPojoClass == Float.TYPE) {
            aPojoClass = Float.class;
        } else if (aPojoClass == Double.TYPE) {
            aPojoClass = Double.class;
        } else if (aPojoClass == Character.TYPE) {
            aPojoClass = Character.class;
        }
        SimpleMapperHelper lHelperSimple = repo.findHelper(aPojoClass);
        if (lHelperSimple == null) {
            String lMsg = "Could not find a mapper helper for class: " + aPojoClass.getName();
            throw new MapperException(lMsg);
        }
        return lHelperSimple.toJava(aValue, aPojoClass);
    }

    public static Object toJava(JSONValue aValue, ParameterizedType aGenericType) throws MapperException {
        if (aValue == null) {
            String lMsg = "Mapper does not support null values.";
            throw new MapperException("Mapper does not support null values.");
        }
        if (aValue.isNull()) {
            return null;
        }
        Class lRawClass = (Class)aGenericType.getRawType();
        Type[] lTypes = aGenericType.getActualTypeArguments();
        SimpleMapperHelper lMapperHelper = repo.findHelper(lRawClass);
        if (lMapperHelper == null) {
            String lMsg = "Could not find a mapper helper for parameterized type: " + aGenericType;
            throw new MapperException(lMsg);
        }
        if (lMapperHelper instanceof ComplexMapperHelper) {
            return ((ComplexMapperHelper)lMapperHelper).toJava(aValue, lRawClass, lTypes);
        }
        return lMapperHelper.toJava(aValue, lRawClass);
    }

    public static Object toJava(JSONValue aValue) throws MapperException {
        if (aValue.isArray()) {
            return JSONMapper.toJava(aValue, LinkedList.class);
        }
        if (aValue.isBoolean()) {
            return JSONMapper.toJava(aValue, Boolean.class);
        }
        if (aValue.isDecimal()) {
            return JSONMapper.toJava(aValue, BigDecimal.class);
        }
        if (aValue.isInteger()) {
            return JSONMapper.toJava(aValue, BigInteger.class);
        }
        if (aValue.isString()) {
            return JSONMapper.toJava(aValue, String.class);
        }
        return JSONMapper.toJava(aValue, Object.class);
    }

    public static JSONValue toJSON(Object aPojo) throws MapperException {
        if (aPojo == null) {
            return JSONNull.NULL;
        }
        Class<?> lObjectClass = aPojo.getClass();
        if (lObjectClass.isArray()) {
            ArrayMapper arrayMapper = new ArrayMapper();
            return arrayMapper.toJSON(aPojo);
        }
        SimpleMapperHelper lHelperSimple = repo.findHelper(aPojo.getClass());
        if (lHelperSimple == null) {
            String lMsg = "Could not find a mapper helper for class: " + aPojo.getClass().getName();
            throw new MapperException(lMsg);
        }
        return lHelperSimple.toJSON(aPojo);
    }

    public static void addHelper(SimpleMapperHelper aHelper) {
        repo.addHelper(aHelper);
    }

    public static HelperRepository<SimpleMapperHelper> getRepository() {
        return repo;
    }

    public static void usePojoAccess() {
        JSONMapper.addHelper(new ObjectMapperDirect());
    }

    public static void useJavaBeanAccess() {
        JSONMapper.addHelper(new ObjectMapper());
    }

    static {
        repo.addHelper(new ObjectMapper());
        repo.addHelper(new StringMapper());
        repo.addHelper(new BooleanMapper());
        repo.addHelper(new ByteMapper());
        repo.addHelper(new ShortMapper());
        repo.addHelper(new IntegerMapper());
        repo.addHelper(new LongMapper());
        repo.addHelper(new FloatMapper());
        repo.addHelper(new DoubleMapper());
        repo.addHelper(new BigIntegerMapper());
        repo.addHelper(new BigDecimalMapper());
        repo.addHelper(new CharacterMapper());
        repo.addHelper(new DateMapper());
        repo.addHelper(new CollectionMapper());
        repo.addHelper(new MapMapper());
        repo.addHelper(new EnumMapper());
    }
}

