/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.mapper.helper.impl;

import com.sdicons.json.helper.JSONConstruct;
import com.sdicons.json.helper.JSONMap;
import com.sdicons.json.mapper.JSONMapper;
import com.sdicons.json.mapper.MapperException;
import com.sdicons.json.mapper.helper.SimpleMapperHelper;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONValue;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMapperDirect
implements SimpleMapperHelper {
    private Map<Class, AnnotatedMethods> annotatedPool = new HashMap<Class, AnnotatedMethods>();

    @Override
    public Class getHelpedClass() {
        return Object.class;
    }

    protected Method getAnnotatedSerializingMethod(Class aClass) {
        for (Method lMethod : aClass.getDeclaredMethods()) {
            if (!lMethod.isAnnotationPresent(JSONMap.class)) continue;
            lMethod.setAccessible(true);
            return lMethod;
        }
        return null;
    }

    protected Constructor getAnnotatedConstructor(Class aClass) {
        Constructor<?>[] lConstructors;
        for (Constructor<?> lCons : lConstructors = aClass.getDeclaredConstructors()) {
            if (!lCons.isAnnotationPresent(JSONConstruct.class)) continue;
            lCons.setAccessible(true);
            return lCons;
        }
        return null;
    }

    protected synchronized AnnotatedMethods getAnnotatedMethods(Class aClass) throws MapperException {
        AnnotatedMethods lResult = this.annotatedPool.get(aClass);
        if (lResult == null) {
            Constructor lCons = this.getAnnotatedConstructor(aClass);
            Method lMeth = this.getAnnotatedSerializingMethod(aClass);
            if (lMeth == null && lCons != null || lMeth != null && lCons == null) {
                throw new MapperException(String.format("ObjectMapperDirect found inconsistency in class: '%1$s'. If annotated methods are used, it should contain both @JSONConstruct and @JSONMap together.", aClass.getClass().getName()));
            }
            lResult = new AnnotatedMethods(lCons, lMeth);
            this.annotatedPool.put(aClass, lResult);
        }
        return lResult;
    }

    protected List<Field> getFieldInfo(Class aClass) {
        LinkedList<Field> lJavaFields = new LinkedList<Field>();
        for (Class lClassWalker = aClass; lClassWalker != null; lClassWalker = lClassWalker.getSuperclass()) {
            Field[] lClassFields;
            for (Field lFld : lClassFields = lClassWalker.getDeclaredFields()) {
                int lModif = lFld.getModifiers();
                if (Modifier.isTransient(lModif) || Modifier.isAbstract(lModif) || Modifier.isStatic(lModif) || Modifier.isFinal(lModif)) continue;
                lFld.setAccessible(true);
                lJavaFields.add(lFld);
            }
        }
        return lJavaFields;
    }

    @Override
    public Object toJava(JSONValue aValue, Class aRequestedClass) throws MapperException {
        if (!aValue.isObject()) {
            throw new MapperException("ObjectMapperDirect cannot map: " + aValue.getClass().getName());
        }
        JSONObject aObject = (JSONObject)aValue;
        try {
            Object lResult;
            AnnotatedMethods lAnnotated = this.getAnnotatedMethods(aRequestedClass);
            if (lAnnotated.cons != null) {
                int lCnt = lAnnotated.cons.getParameterTypes().length;
                Object[] lAttrs = new Object[lCnt];
                for (int i = 0; i < lCnt; ++i) {
                    String lFldName = "cons-" + i;
                    JSONValue lSubEl = aObject.get(lFldName);
                    try {
                        lAttrs[i] = JSONMapper.toJava(lSubEl, lAnnotated.cons.getParameterTypes()[i]);
                        continue;
                    }
                    catch (MapperException e) {
                        throw new MapperException(String.format("ObjectMapperDirect error while deserializing. Error while calling the @JSONConstruct constructor in class: '%1$s' on parameter nr: %2$d with a value of class: '%3$s'.", aRequestedClass.getName(), i, lAnnotated.cons.getParameterTypes()[i].getName()), e);
                    }
                }
                try {
                    lResult = lAnnotated.cons.newInstance(lAttrs);
                }
                catch (Exception e) {
                    throw new MapperException(String.format("ObjectMapperDirect error while deserializing. Tried to instantiate an object (using annotated constructor) of class: '%1$s'.", aRequestedClass.getName()), e);
                }
            } else {
                lResult = aRequestedClass.newInstance();
            }
            List<Field> lJavaFields = this.getFieldInfo(aRequestedClass);
            block13: for (String lPropname : aObject.getValue().keySet()) {
                JSONValue lSubEl = aObject.get(lPropname);
                for (Field lFld : lJavaFields) {
                    if (!lFld.getName().equals(lPropname)) continue;
                    Type lGenType = lFld.getGenericType();
                    Object lFldValue = lGenType instanceof ParameterizedType ? JSONMapper.toJava(lSubEl, (ParameterizedType)lGenType) : JSONMapper.toJava(lSubEl, lFld.getType());
                    try {
                        lFld.setAccessible(true);
                        lFld.set(lResult, lFldValue);
                        continue block13;
                    }
                    catch (Exception e) {
                        throw new MapperException(String.format("ObjectMapperDirect error while deserializing. Type error while trying to set the field: '%1$s' in class: '%2$s' with a value of class: '%3$s'.", lFld.getName(), aRequestedClass.getName(), lFldValue.getClass().getName()), e);
                    }
                }
            }
            if (lResult instanceof Serializable) {
                try {
                    Method lReadResolve = lResult.getClass().getDeclaredMethod("readResolve", new Class[0]);
                    if (lReadResolve != null) {
                        lReadResolve.setAccessible(true);
                        lResult = lReadResolve.invoke(lResult, new Object[0]);
                    }
                }
                catch (NoSuchMethodException e) {
                }
                catch (Exception e) {
                    throw new MapperException(String.format("ObjectMapperDirect error while creating java object. Tried to invoke 'readResolve' on instance of class: '%1$s'.", lResult.getClass().getName()), e);
                }
            }
            return lResult;
        }
        catch (IllegalAccessException e) {
            String lMsg = "IllegalAccessException while trying to instantiate bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
        catch (InstantiationException e) {
            String lMsg = "InstantiationException while trying to instantiate bean: " + aRequestedClass;
            throw new MapperException(lMsg);
        }
    }

    @Override
    public JSONValue toJSON(Object aPojo) throws MapperException {
        JSONObject lElements = new JSONObject();
        if (aPojo instanceof Serializable) {
            try {
                Method lWriteReplace = aPojo.getClass().getDeclaredMethod("writeReplace", new Class[0]);
                if (lWriteReplace != null) {
                    lWriteReplace.setAccessible(true);
                    return JSONMapper.toJSON(lWriteReplace.invoke(aPojo, new Object[0]));
                }
            }
            catch (NoSuchMethodException e) {
            }
            catch (Exception e) {
                throw new MapperException(String.format("ObjectMapperDirect error while trying to invoke 'writeReplace' on instance of class: '%1$s'.", aPojo.getClass().getName()), e);
            }
        }
        Class<?> lJavaClass = aPojo.getClass();
        List<Field> lJavaFields = this.getFieldInfo(lJavaClass);
        AnnotatedMethods lAnnotated = this.getAnnotatedMethods(lJavaClass);
        for (Field lFld : lJavaFields) {
            try {
                lFld.setAccessible(true);
                JSONValue lFieldVal = JSONMapper.toJSON(lFld.get(aPojo));
                lElements.getValue().put(lFld.getName(), lFieldVal);
            }
            catch (Exception e) {
                throw new MapperException(String.format("ObjectMapperDirect error while serializing. Error while reading field: '%1$s' from instance of class: '%2$s'.", lFld.getName(), lJavaClass.getName()), e);
            }
        }
        if (lAnnotated.serialize != null) {
            Object[] lVals;
            try {
                lVals = (Object[])lAnnotated.serialize.invoke(aPojo, new Object[0]);
            }
            catch (Exception e) {
                throw new MapperException(String.format("ObjectMapperDirect error while serializing. Error while invoking the @JSONMap method called '%1$s(...)' on an instance of class: '%2$s'.", lAnnotated.serialize.getName(), lJavaClass.getName()), e);
            }
            int i = 0;
            try {
                for (Object lVal : lVals) {
                    JSONValue lFieldVal = JSONMapper.toJSON(lVal);
                    lElements.getValue().put("cons-" + i, lFieldVal);
                    ++i;
                }
            }
            catch (MapperException e) {
                throw new MapperException(String.format("ObjectMapperDirect error while serializing. Error while serializing element nr %1$d from the @JSONMap method: '%2$s(...)' on instance of class: '%3$s'.", i, lAnnotated.serialize.getName(), lJavaClass.getName()), e);
            }
        }
        return lElements;
    }

    private static class AnnotatedMethods {
        public Constructor cons;
        public Method serialize;

        public AnnotatedMethods(Constructor aCons, Method aSerialize) {
            this.cons = aCons;
            this.serialize = aSerialize;
        }
    }
}

