/*
 * Decompiled with CFR 0.152.
 */
package com.sdicons.json.model;

import com.sdicons.json.model.JSONArray;
import com.sdicons.json.model.JSONBoolean;
import com.sdicons.json.model.JSONComplex;
import com.sdicons.json.model.JSONDecimal;
import com.sdicons.json.model.JSONInteger;
import com.sdicons.json.model.JSONNull;
import com.sdicons.json.model.JSONNumber;
import com.sdicons.json.model.JSONObject;
import com.sdicons.json.model.JSONSimple;
import com.sdicons.json.model.JSONString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public abstract class JSONValue {
    private String streamName;
    private int line = 0;
    private int col = 0;
    private Object data = null;

    public int getLine() {
        return this.line;
    }

    public void setLineCol(int line, int col) {
        this.line = line;
        this.col = col;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public int getCol() {
        return this.col;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public boolean isSimple() {
        return this instanceof JSONSimple;
    }

    public boolean isComplex() {
        return this instanceof JSONComplex;
    }

    public boolean isArray() {
        return this instanceof JSONArray;
    }

    public boolean isObject() {
        return this instanceof JSONObject;
    }

    public boolean isNumber() {
        return this instanceof JSONNumber;
    }

    public boolean isDecimal() {
        return this instanceof JSONDecimal;
    }

    public boolean isInteger() {
        return this instanceof JSONInteger;
    }

    public boolean isNull() {
        return this instanceof JSONNull;
    }

    public boolean isBoolean() {
        return this instanceof JSONBoolean;
    }

    public boolean isString() {
        return this instanceof JSONString;
    }

    public String render(boolean pretty) {
        return this.render(pretty, "");
    }

    protected abstract String render(boolean var1, String var2);

    public abstract Object strip();

    public static JSONValue decorate(Object anObject) {
        if (anObject == null) {
            return new JSONNull();
        }
        if (anObject instanceof Boolean) {
            return anObject.equals(Boolean.TRUE) ? JSONBoolean.TRUE : JSONBoolean.FALSE;
        }
        if (anObject instanceof BigDecimal) {
            return new JSONDecimal((BigDecimal)anObject);
        }
        if (anObject instanceof BigInteger) {
            return new JSONInteger((BigInteger)anObject);
        }
        if (anObject instanceof String) {
            return new JSONString((String)anObject);
        }
        if (anObject instanceof List) {
            JSONArray lArray = new JSONArray();
            for (Object lElement : (List)anObject) {
                lArray.getValue().add(JSONValue.decorate(lElement));
            }
            return lArray;
        }
        if (anObject instanceof Map) {
            JSONObject lObj = new JSONObject();
            for (Object lKey : ((Map)anObject).keySet()) {
                if (lKey instanceof String) {
                    lObj.getValue().put((String)lKey, JSONValue.decorate(((Map)anObject).get(lKey)));
                    continue;
                }
                throw new IllegalArgumentException("HashMap contains a key that is not a String: " + lKey);
            }
            return lObj;
        }
        throw new IllegalArgumentException("Cannot convert this object to a JSONValue: " + anObject);
    }
}

