/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer;

import com.github.javaparser.Position;
import com.github.javaparser.utils.Utils;
import java.text.Normalizer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.regex.Pattern;

public class SourcePrinter {
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\r\n|\r|\n");
    private final String indentation;
    private final String endOfLineCharacter;
    private int level = 0;
    private boolean indented = false;
    private final StringBuilder buf = new StringBuilder();
    private Position cursor = new Position(1, 0);
    private Deque<Position> methodChainPositions = new LinkedList<Position>();

    SourcePrinter(String indentation, String endOfLineCharacter) {
        this.indentation = indentation;
        this.endOfLineCharacter = endOfLineCharacter;
        this.pushMethodChainPosition(this.cursor);
    }

    public SourcePrinter indent() {
        ++this.level;
        return this;
    }

    public SourcePrinter unindent() {
        --this.level;
        return this;
    }

    private void makeIndent() {
        for (int i = 0; i < this.level; ++i) {
            this.bufAppend(this.indentation);
        }
    }

    public SourcePrinter print(String arg) {
        if (!this.indented) {
            this.makeIndent();
            this.indented = true;
        }
        this.bufAppend(arg);
        return this;
    }

    public SourcePrinter println(String arg) {
        this.print(arg);
        this.println();
        return this;
    }

    public SourcePrinter println() {
        this.bufAppend(this.endOfLineCharacter);
        this.indented = false;
        return this;
    }

    private StringBuilder bufAppend(String arg) {
        this.updateCursor(arg);
        return this.buf.append(arg);
    }

    private void updateCursor(String arg) {
        String[] lines = NEWLINE_PATTERN.split(arg);
        this.cursor = lines.length == 0 ? Position.pos(this.cursor.line + 1, 0) : (lines.length == 1 ? Position.pos(this.cursor.line, this.cursor.column + Normalizer.normalize(lines[0], Normalizer.Form.NFC).length()) : Position.pos(this.cursor.line + (lines.length - 1), 0 + Normalizer.normalize(lines[lines.length - 1], Normalizer.Form.NFC).length()));
    }

    public Position getCursor() {
        return this.cursor;
    }

    public void resetMethodChainPosition(Position position) {
        this.methodChainPositions.pop();
        this.methodChainPositions.push(position);
    }

    public void pushMethodChainPosition(Position position) {
        this.methodChainPositions.push(position);
    }

    public Position peekMethodChainPosition() {
        return this.methodChainPositions.peek();
    }

    public Position popMethodChainPosition() {
        return this.methodChainPositions.pop();
    }

    public void wrapToColumn(int column) {
        this.println();
        if (!this.indented) {
            this.makeIndent();
            this.indented = true;
        }
        while (this.cursor.column < column) {
            this.print(" ");
        }
    }

    public String getSource() {
        return this.buf.toString();
    }

    public String toString() {
        return this.getSource();
    }

    public String normalizeEolInTextBlock(String content) {
        return Utils.normalizeEolInTextBlock(content, this.endOfLineCharacter);
    }
}

