/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis;

import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.utils.Pair;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class JobRegistry {
    private static final JobRegistry INSTANCE = new JobRegistry();
    private Queue<Pair<String, ClassResult>> unhandledClasses = new ConcurrentLinkedQueue<Pair<String, ClassResult>>();

    private JobRegistry() {
    }

    public void analyzeResourceClass(String className, ClassResult classResult) {
        this.unhandledClasses.add(Pair.of(className, classResult));
    }

    public Pair<String, ClassResult> nextUnhandledClass() {
        return this.unhandledClasses.poll();
    }

    public static JobRegistry getInstance() {
        return INSTANCE;
    }
}

