/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.DefaultInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.DupInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.GetFieldInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.GetStaticInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeDynamicInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadStoreInstructionPlaceholder;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.NewInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.PushInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.ReturnInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.SizeChangingInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.ThrowInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.lang.reflect.Field;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.Printer;

public final class InstructionBuilder {
    private InstructionBuilder() {
        throw new UnsupportedOperationException();
    }

    public static Instruction buildFieldInstruction(int opcode, String ownerClass, String name, String desc, Label label) {
        if (Type.getObjectType(ownerClass).getClassName().equals(ownerClass.replace('.', '/'))) {
            throw new AssertionError((Object)"!");
        }
        String opcodeName = Printer.OPCODES[opcode];
        switch (opcode) {
            case 178: {
                Object value = InstructionBuilder.getStaticValue(name, ownerClass);
                return new GetStaticInstruction(ownerClass, name, desc, value, label);
            }
            case 179: {
                return new SizeChangingInstruction(opcodeName, 0, 1, label);
            }
            case 180: {
                return new GetFieldInstruction(ownerClass, name, desc, label);
            }
            case 181: {
                return new SizeChangingInstruction(opcodeName, 0, 2, label);
            }
        }
        throw new IllegalArgumentException("Opcode " + opcode + " not a field instruction");
    }

    public static Instruction buildInstruction(int opcode, Label label) {
        String opcodeName = Printer.OPCODES[opcode];
        switch (opcode) {
            case 3: {
                return new PushInstruction(0, "I", label);
            }
            case 4: {
                return new PushInstruction(1, "I", label);
            }
            case 5: {
                return new PushInstruction(2, "I", label);
            }
            case 6: {
                return new PushInstruction(3, "I", label);
            }
            case 7: {
                return new PushInstruction(4, "I", label);
            }
            case 8: {
                return new PushInstruction(5, "I", label);
            }
            case 2: {
                return new PushInstruction(-1, "I", label);
            }
            case 14: {
                return new PushInstruction(0.0, "D", label);
            }
            case 15: {
                return new PushInstruction(1.0, "D", label);
            }
            case 11: {
                return new PushInstruction(Float.valueOf(1.0f), "F", label);
            }
            case 12: {
                return new PushInstruction(Float.valueOf(1.0f), "F", label);
            }
            case 13: {
                return new PushInstruction(Float.valueOf(2.0f), "F", label);
            }
            case 9: {
                return new PushInstruction(0L, "J", label);
            }
            case 10: {
                return new PushInstruction(1L, "J", label);
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new SizeChangingInstruction(opcodeName, 1, 2, label);
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return new SizeChangingInstruction(opcodeName, 0, 3, label);
            }
            case 90: 
            case 93: {
                return new SizeChangingInstruction(opcodeName, 3, 2, label);
            }
            case 91: 
            case 94: {
                return new SizeChangingInstruction(opcodeName, 4, 3, label);
            }
            case 95: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 190: {
                return new SizeChangingInstruction(opcodeName, 1, 1, label);
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return new SizeChangingInstruction(opcodeName, 1, 2, label);
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                return new ReturnInstruction(label);
            }
            case 191: {
                return new ThrowInstruction(label);
            }
            case 0: 
            case 177: {
                return new DefaultInstruction(opcodeName, label);
            }
            case 87: 
            case 88: 
            case 194: 
            case 195: {
                return new SizeChangingInstruction(opcodeName, 0, 1, label);
            }
            case 1: {
                return new SizeChangingInstruction(opcodeName, 1, 0, label);
            }
            case 89: 
            case 92: {
                return new DupInstruction(label);
            }
        }
        throw new IllegalArgumentException("Unexpected opcode " + opcode);
    }

    public static Instruction buildLoadStoreInstruction(int opcode, int index, Label label) {
        switch (opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return new LoadStoreInstructionPlaceholder(Instruction.InstructionType.LOAD_PLACEHOLDER, index, label);
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return new LoadStoreInstructionPlaceholder(Instruction.InstructionType.STORE_PLACEHOLDER, index, label);
            }
            case 169: {
                return new DefaultInstruction(Printer.OPCODES[opcode], label);
            }
        }
        throw new IllegalArgumentException("Unexpected opcode " + opcode);
    }

    public static Instruction buildTypeInstruction(int opcode, String className, Label label) {
        String opcodeName = Printer.OPCODES[opcode];
        switch (opcode) {
            case 187: {
                return new NewInstruction(className, label);
            }
            case 189: 
            case 193: {
                return new SizeChangingInstruction(opcodeName, 1, 1, label);
            }
            case 192: {
                return new DefaultInstruction(opcodeName, label);
            }
        }
        throw new IllegalArgumentException("Unexpected opcode " + opcode);
    }

    public static InvokeInstruction buildInvokeInstruction(int opcode, String containingClass, String name, String desc, Label label) {
        switch (opcode) {
            case 182: 
            case 183: 
            case 185: {
                return new InvokeInstruction(MethodIdentifier.of(containingClass, name, desc, false), label);
            }
            case 184: {
                return new InvokeInstruction(MethodIdentifier.of(containingClass, name, desc, true), label);
            }
        }
        throw new IllegalArgumentException("Unexpected opcode " + opcode);
    }

    public static Instruction buildInvokeDynamic(String className, String name, String desc, Handle handle, Label label) {
        MethodIdentifier actualIdentifier = MethodIdentifier.of(handle.getOwner(), handle.getName(), handle.getDesc(), handle.getTag() == 6);
        MethodIdentifier dynamicIdentifier = MethodIdentifier.of(className, name, desc, true);
        return new InvokeDynamicInstruction(actualIdentifier, dynamicIdentifier, label);
    }

    public static Instruction buildJumpInstruction(int opcode, Label label) {
        String opcodeName = Printer.OPCODES[opcode];
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                return new SizeChangingInstruction(opcodeName, 0, 1, label);
            }
            case 168: {
                return new SizeChangingInstruction(opcodeName, 1, 0, label);
            }
            case 167: {
                return new DefaultInstruction(opcodeName, label);
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return new SizeChangingInstruction(opcodeName, 0, 2, label);
            }
        }
        throw new IllegalArgumentException("Unexpected opcode " + opcode);
    }

    public static Instruction buildIntInstruction(int opcode, int operand, Label label) {
        switch (opcode) {
            case 16: 
            case 17: {
                return new PushInstruction(operand, "I", label);
            }
            case 188: {
                return new SizeChangingInstruction(Printer.OPCODES[188], 1, 1, label);
            }
        }
        throw new IllegalArgumentException("Unexpected opcode " + opcode);
    }

    private static Object getStaticValue(String name, String containingClass) {
        try {
            Class<?> clazz = Class.forName(containingClass.replace('/', '.'));
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Exception e) {
            LogProvider.error("Could not access static property, reason: " + e.getMessage());
            LogProvider.debug(e);
            return null;
        }
    }
}

