/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.IdentifiableMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.util.List;
import java.util.function.BiFunction;

enum KnownJsonResultMethod implements IdentifiableMethod
{
    JSON_ARRAY_BUILDER_CREATE(MethodIdentifier.ofStatic("javax/json/Json", "createArrayBuilder", "Ljavax/json/JsonArrayBuilder;", new String[0]), (object, arguments) -> new Element("Ljavax/json/JsonArray;", new JsonArray())),
    JSON_ARRAY_BUILDER_ADD_BIG_DECIMAL(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "Ljava/math/BigDecimal;"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, "Ljava/math/BigDecimal;")),
    JSON_ARRAY_BUILDER_ADD_BIG_INTEGER(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "Ljava/math/BigInteger;"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, "Ljava/math/BigInteger;")),
    JSON_ARRAY_BUILDER_ADD_STRING(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "Ljava/lang/String;"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, "Ljava/lang/String;")),
    JSON_ARRAY_BUILDER_ADD_INT(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "I"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, "Ljava/lang/Integer;")),
    JSON_ARRAY_BUILDER_ADD_LONG(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "J"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, "Ljava/lang/Long;")),
    JSON_ARRAY_BUILDER_ADD_DOUBLE(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "D"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, "Ljava/lang/Double;")),
    JSON_ARRAY_BUILDER_ADD_BOOLEAN(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "Z"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, "Z")),
    JSON_ARRAY_BUILDER_ADD_JSON(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "Ljavax/json/JsonValue;"), KnownJsonResultMethod::addToArray),
    JSON_ARRAY_BUILDER_ADD_JSON_OBJECT(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "Ljavax/json/JsonObjectBuilder;"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, "Ljavax/json/JsonObject;")),
    JSON_ARRAY_BUILDER_ADD_JSON_ARRAY(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "add", "Ljavax/json/JsonArrayBuilder;", "Ljavax/json/JsonArrayBuilder;"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, "Ljavax/json/JsonArray;")),
    JSON_ARRAY_BUILDER_ADD_NULL(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "addNull", "Ljavax/json/JsonArrayBuilder;", new String[0]), (object, arguments) -> {
        object.getPossibleValues().stream().filter(o -> o instanceof JsonArray).map(o -> (JsonArray)o).forEach(a -> a.getElements().add(new Element("Ljava/lang/Object;", null)));
        return object;
    }),
    JSON_ARRAY_BUILDER_BUILD(MethodIdentifier.ofNonStatic("javax/json/JsonArrayBuilder", "build", "Ljavax/json/JsonArray;", new String[0]), (object, arguments) -> {
        Element json = new Element("Ljavax/json/JsonArray;", new Object[0]);
        json.getPossibleValues().addAll(object.getPossibleValues());
        return json;
    }),
    JSON_OBJECT_BUILDER_CREATE(MethodIdentifier.ofStatic("javax/json/Json", "createObjectBuilder", "Ljavax/json/JsonObjectBuilder;", new String[0]), (object, arguments) -> new Element("Ljavax/json/JsonObject;", new JsonObject())),
    JSON_OBJECT_BUILDER_ADD_BIG_DECIMAL(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "Ljava/math/BigDecimal;"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, "Ljava/math/BigDecimal;")),
    JSON_OBJECT_BUILDER_ADD_BIG_INTEGER(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "Ljava/math/BigInteger;"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, "Ljava/math/BigInteger;")),
    JSON_OBJECT_BUILDER_ADD_STRING(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "Ljava/lang/String;"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, "Ljava/lang/String;")),
    JSON_OBJECT_BUILDER_ADD_INT(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "I"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, "Ljava/lang/Integer;")),
    JSON_OBJECT_BUILDER_ADD_LONG(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "J"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, "Ljava/lang/Long;")),
    JSON_OBJECT_BUILDER_ADD_DOUBLE(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "D"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, "Ljava/lang/Double;")),
    JSON_OBJECT_BUILDER_ADD_BOOLEAN(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "Z"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, "Z")),
    JSON_OBJECT_BUILDER_ADD_JSON(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "Ljavax/json/JsonValue;"), KnownJsonResultMethod::mergeJsonStructure),
    JSON_OBJECT_BUILDER_ADD_JSON_OBJECT(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "Ljavax/json/JsonObjectBuilder;"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, "Ljavax/json/JsonObject;")),
    JSON_OBJECT_BUILDER_ADD_JSON_ARRAY(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "add", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;", "Ljavax/json/JsonArrayBuilder;"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, "Ljavax/json/JsonArray;")),
    JSON_OBJECT_BUILDER_ADD_NULL(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "addNull", "Ljavax/json/JsonObjectBuilder;", "Ljava/lang/String;"), (object, arguments) -> {
        object.getPossibleValues().stream().filter(o -> o instanceof JsonObject).map(o -> (JsonObject)o).forEach(o -> ((Element)arguments.get(0)).getPossibleValues().stream().map(s -> (String)s).forEach(s -> o.getStructure().merge((String)s, new Element("Ljava/lang/Object;", null), Element::merge)));
        return object;
    }),
    JSON_OBJECT_BUILDER_BUILD(MethodIdentifier.ofNonStatic("javax/json/JsonObjectBuilder", "build", "Ljavax/json/JsonObject;", new String[0]), (object, arguments) -> {
        Element json = new Element("Ljavax/json/JsonObject;", new Object[0]);
        json.getPossibleValues().addAll(object.getPossibleValues());
        return json;
    }),
    JSON_OBJECT_GET_BOOLEAN(MethodIdentifier.ofNonStatic("javax/json/JsonObject", "getBoolean", "Z", "Ljava/lang/String;"), (object, arguments) -> object.getPossibleValues().stream().filter(o -> o instanceof JsonObject).map(o -> (JsonObject)o).map(o -> ((Element)arguments.get(0)).getPossibleValues().stream().map(s -> (String)s).map(s -> o.getStructure().get(s)).reduce(new Element("Z", new Object[0]), Element::merge)).reduce(new Element("Z", new Object[0]), Element::merge));

    private final MethodIdentifier identifier;
    private final BiFunction<Element, List<Element>, Element> function;

    private KnownJsonResultMethod(MethodIdentifier identifier, BiFunction<Element, List<Element>, Element> function) {
        this.identifier = identifier;
        this.function = function;
    }

    @Override
    public Element invoke(Element object, List<Element> arguments) {
        if (arguments.size() != this.identifier.getParameters().size()) {
            throw new IllegalArgumentException("Method arguments do not match expected signature!");
        }
        return this.function.apply(object, arguments);
    }

    @Override
    public boolean matches(MethodIdentifier identifier) {
        return this.identifier.equals(identifier);
    }

    private static Element addToArray(Element object, List<Element> arguments) {
        return KnownJsonResultMethod.addToArray(object, arguments.get(0));
    }

    private static Element addToArray(Element object, List<Element> arguments, String typeOverride) {
        Element element = new Element(typeOverride, new Object[0]);
        element.getPossibleValues().addAll(arguments.get(0).getPossibleValues());
        return KnownJsonResultMethod.addToArray(object, element);
    }

    private static Element addToArray(Element object, Element argument) {
        object.getPossibleValues().stream().filter(o -> o instanceof JsonArray).map(o -> (JsonArray)o).forEach(a -> a.getElements().add(argument));
        return object;
    }

    private static Element mergeJsonStructure(Element object, List<Element> arguments) {
        Element element = new Element(arguments.get(1).getTypes(), new Object[0]);
        element.merge(arguments.get(1));
        return KnownJsonResultMethod.mergeJsonStructure(object, arguments.get(0), element);
    }

    private static Element mergeJsonStructure(Element object, List<Element> arguments, String typeOverride) {
        Element element = new Element(typeOverride, new Object[0]);
        element.getPossibleValues().addAll(arguments.get(1).getPossibleValues());
        return KnownJsonResultMethod.mergeJsonStructure(object, arguments.get(0), element);
    }

    private static Element mergeJsonStructure(Element object, Element key, Element argument) {
        object.getPossibleValues().stream().filter(o -> o instanceof JsonObject).map(o -> (JsonObject)o).forEach(o -> key.getPossibleValues().stream().map(s -> (String)s).forEach(s -> o.getStructure().merge((String)s, argument, Element::merge)));
        return object;
    }
}

