/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.javadoc.JavaDocParserVisitor;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.MethodComment;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class JavaDocAnalyzer {
    private final Map<MethodIdentifier, MethodComment> methodComments = new HashMap<MethodIdentifier, MethodComment>();

    public void analyze(Set<Path> projectSourcePaths, Set<ClassResult> classResults) {
        this.invokeParser(projectSourcePaths);
        this.combineResults(classResults);
    }

    private void invokeParser(Set<Path> projectSourcePaths) {
        try {
            for (Path projectSourcePath : projectSourcePaths) {
                this.invokeParser(projectSourcePath);
            }
        }
        catch (IOException e) {
            LogProvider.error("could not analyze JavaDoc, reason: " + e.getMessage());
            LogProvider.debug(e);
        }
    }

    private void invokeParser(Path sourcePath) throws IOException {
        final HashSet files = new HashSet();
        Files.walkFileTree(sourcePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(".java")) {
                    files.add(file);
                }
                return super.visitFile(file, attrs);
            }
        });
        files.forEach(path -> JavaDocAnalyzer.parseJavaDoc(path, new JavaDocParserVisitor(this.methodComments)));
    }

    private static void parseJavaDoc(Path path, JavaDocParserVisitor visitor) {
        try {
            CompilationUnit cu = JavaParser.parse(path.toFile());
            cu.accept(visitor, null);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private void combineResults(Set<ClassResult> classResults) {
        this.methodComments.forEach((key, value) -> classResults.stream().map(c -> this.findMethodResult((MethodIdentifier)key, (ClassResult)c)).filter(Objects::nonNull).forEach(m -> m.setMethodDoc((MethodComment)value)));
    }

    private MethodResult findMethodResult(MethodIdentifier identifier, ClassResult classResult) {
        if (classResult.getOriginalClass().equals(identifier.getContainingClass())) {
            return classResult.getMethods().stream().filter(methodResult -> this.equalsSimpleTypeNames(identifier, (MethodResult)methodResult)).findAny().orElse(null);
        }
        return classResult.getMethods().stream().map(MethodResult::getSubResource).filter(Objects::nonNull).map(c -> this.findMethodResult(identifier, (ClassResult)c)).filter(Objects::nonNull).findAny().orElse(null);
    }

    private boolean equalsSimpleTypeNames(MethodIdentifier identifier, MethodResult methodResult) {
        MethodIdentifier originalIdentifier = methodResult.getOriginalMethodSignature();
        return originalIdentifier.getMethodName().equals(identifier.getMethodName()) && this.matchesTypeBestEffort(originalIdentifier.getReturnType(), identifier.getReturnType()) && this.parameterMatch(originalIdentifier.getParameters(), identifier.getParameters());
    }

    private boolean parameterMatch(List<String> originalTypes, List<String> types) {
        if (originalTypes.size() != types.size()) {
            return false;
        }
        for (int i = 0; i < originalTypes.size(); ++i) {
            if (this.matchesTypeBestEffort(originalTypes.get(i), types.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean matchesTypeBestEffort(String originalType, String type) {
        if (type.contains("<")) {
            return Stream.of(type.replace(">", "").split("<")).allMatch(originalType::contains);
        }
        return JavaUtils.toClassName(originalType).contains(type);
    }
}

