/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import com.sebastian_daschner.jaxrs_analyzer.utils.StringUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

final class PathNormalizer {
    private PathNormalizer() {
        throw new UnsupportedOperationException();
    }

    static String getApplicationPath(Set<ClassResult> classResults) {
        return classResults.stream().map(ClassResult::getApplicationPath).filter(Objects::nonNull).map(PathNormalizer::normalize).findAny().orElse("");
    }

    static String getPath(MethodResult methodResult) {
        List<String> paths = PathNormalizer.determinePaths(methodResult);
        return paths.stream().map(PathNormalizer::normalize).collect(Collectors.joining("/"));
    }

    private static List<String> determinePaths(MethodResult methodResult) {
        LinkedList<String> paths;
        block1: {
            ClassResult parentClass;
            paths = new LinkedList<String>();
            MethodResult currentMethod = methodResult;
            do {
                PathNormalizer.addNonBlank(currentMethod.getPath(), paths);
                parentClass = currentMethod.getParentResource();
                if (parentClass == null) break block1;
            } while ((currentMethod = parentClass.getParentSubResourceLocator()) != null);
            PathNormalizer.addNonBlank(parentClass.getResourcePath(), paths);
        }
        Collections.reverse(paths);
        return paths;
    }

    private static void addNonBlank(String string, List<String> strings) {
        if (!StringUtils.isBlank(string) && !"/".equals(string)) {
            strings.add(string);
        }
    }

    private static String normalize(String path) {
        StringBuilder builder = new StringBuilder(path);
        int index = 0;
        int colonIndex = -1;
        char current = '\u0000';
        while (index > -1 && index < builder.length()) {
            char last = current;
            current = builder.charAt(index);
            switch (current) {
                case '}': {
                    if (last == '\\' || colonIndex == -1) break;
                    builder.delete(colonIndex, index);
                    index = colonIndex;
                    colonIndex = -1;
                    break;
                }
                case ':': {
                    if (colonIndex != -1) break;
                    colonIndex = index;
                }
            }
            if ((index == 0 || index == builder.length() - 1) && current == '/') {
                builder.deleteCharAt(index);
                if (index != builder.length()) continue;
                --index;
                continue;
            }
            ++index;
        }
        return builder.toString();
    }
}

