/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.analysis.results.DynamicTypeAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.JavaDocParameterResolver;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.JavaTypeAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.JsonMapper;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.PathNormalizer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.StringParameterResolver;
import com.sebastian_daschner.jaxrs_analyzer.model.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.ClassComment;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.MemberComment;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.MemberParameterTag;
import com.sebastian_daschner.jaxrs_analyzer.model.javadoc.MethodComment;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.core.Response;

public class ResultInterpreter {
    private JavaTypeAnalyzer javaTypeAnalyzer;
    private Resources resources;
    private DynamicTypeAnalyzer dynamicTypeAnalyzer;
    private StringParameterResolver stringParameterResolver;

    public Resources interpret(Set<ClassResult> classResults) {
        this.resources = new Resources();
        this.resources.setBasePath(PathNormalizer.getApplicationPath(classResults));
        this.javaTypeAnalyzer = new JavaTypeAnalyzer(this.resources.getTypeRepresentations());
        this.dynamicTypeAnalyzer = new DynamicTypeAnalyzer(this.resources.getTypeRepresentations());
        this.stringParameterResolver = new StringParameterResolver(this.resources.getTypeRepresentations(), this.javaTypeAnalyzer);
        classResults.stream().filter(c -> c.getResourcePath() != null).forEach(this::interpretClassResult);
        this.resources.consolidateMultiplePaths();
        return this.resources;
    }

    private void interpretClassResult(ClassResult classResult) {
        classResult.getMethods().forEach(m -> this.interpretMethodResult((MethodResult)m, classResult));
    }

    private void interpretMethodResult(MethodResult methodResult, ClassResult classResult) {
        if (methodResult.getSubResource() != null) {
            this.interpretClassResult(methodResult.getSubResource());
            return;
        }
        String path = PathNormalizer.getPath(methodResult);
        ResourceMethod resourceMethod = this.interpretResourceMethod(methodResult, classResult);
        this.resources.addMethod(path, resourceMethod);
    }

    private ResourceMethod interpretResourceMethod(MethodResult methodResult, ClassResult classResult) {
        MethodComment methodDoc = methodResult.getMethodDoc();
        String description = methodDoc != null ? methodDoc.getComment() : null;
        ResourceMethod resourceMethod = new ResourceMethod(methodResult.getHttpMethod(), description);
        this.updateMethodParameters(resourceMethod.getMethodParameters(), classResult.getClassFields());
        this.updateMethodParameters(resourceMethod.getMethodParameters(), methodResult.getMethodParameters());
        this.addParameterDescriptions(resourceMethod.getMethodParameters(), methodDoc);
        this.stringParameterResolver.replaceParametersTypes(resourceMethod.getMethodParameters());
        if (methodResult.getRequestBodyType() != null) {
            resourceMethod.setRequestBody(this.javaTypeAnalyzer.analyze(methodResult.getRequestBodyType()));
            resourceMethod.setRequestBodyDescription(this.findRequestBodyDescription(methodDoc));
        }
        this.addDefaultResponses(methodResult);
        methodResult.getResponses().forEach(r -> this.interpretResponse((HttpResponse)r, resourceMethod));
        this.addResponseComments(methodResult, resourceMethod);
        this.addMediaTypes(methodResult, classResult, resourceMethod);
        if (methodResult.isDeprecated() || classResult.isDeprecated() || this.hasDeprecationTag(methodDoc)) {
            resourceMethod.setDeprecated(true);
        }
        return resourceMethod;
    }

    private void addResponseComments(MethodResult methodResult, ResourceMethod resourceMethod) {
        MethodComment methodDoc = methodResult.getMethodDoc();
        if (methodDoc == null) {
            return;
        }
        methodDoc.getResponseComments().forEach((k, v) -> this.addResponseComment((Integer)k, (String)v, resourceMethod));
        ClassComment classDoc = methodDoc.getContainingClassComment();
        if (classDoc != null) {
            classDoc.getResponseComments().forEach((k, v) -> this.addResponseComment((Integer)k, (String)v, resourceMethod));
        }
    }

    private void addResponseComment(Integer status, String comment, ResourceMethod resourceMethod) {
        resourceMethod.getResponses().putIfAbsent(status, new Response(null, comment));
    }

    private boolean hasDeprecationTag(MethodComment doc) {
        if (doc == null) {
            return false;
        }
        return doc.isDeprecated() || this.hasClassDeprecationTag(doc.getContainingClassComment());
    }

    private boolean hasClassDeprecationTag(MemberComment doc) {
        return doc != null && doc.isDeprecated();
    }

    private void addParameterDescriptions(Set<MethodParameter> methodParameters, MethodComment methodDoc) {
        if (methodDoc == null) {
            return;
        }
        methodParameters.forEach(p -> {
            Optional<MemberParameterTag> tag = JavaDocParameterResolver.findParameterDoc(p, methodDoc);
            String description = tag.map(MemberParameterTag::getComment).orElseGet(() -> JavaDocParameterResolver.findFieldDoc(p, methodDoc.getContainingClassComment()).map(MemberParameterTag::getComment).orElse(null));
            p.setDescription(description);
        });
    }

    private String findRequestBodyDescription(MethodComment methodDoc) {
        if (methodDoc == null) {
            return null;
        }
        return JavaDocParameterResolver.findRequestBodyDoc(methodDoc).map(MemberParameterTag::getComment).orElse(null);
    }

    private void updateMethodParameters(Set<MethodParameter> parameters, Set<MethodParameter> additional) {
        additional.forEach(a -> {
            Optional<MethodParameter> existingParameter = parameters.stream().filter(p -> p.getName().equals(a.getName())).findAny();
            existingParameter.ifPresent(parameters::remove);
            parameters.add((MethodParameter)a);
        });
    }

    private void addDefaultResponses(MethodResult methodResult) {
        if (methodResult.getResponses().isEmpty()) {
            HttpResponse httpResponse = new HttpResponse();
            httpResponse.getStatuses().add(Response.Status.NO_CONTENT.getStatusCode());
            methodResult.getResponses().add(httpResponse);
            return;
        }
        methodResult.getResponses().stream().filter(r -> r.getStatuses().isEmpty()).forEach(r -> r.getStatuses().add(Response.Status.OK.getStatusCode()));
    }

    private void interpretResponse(HttpResponse httpResponse, ResourceMethod method) {
        method.getResponseMediaTypes().addAll(httpResponse.getContentTypes());
        httpResponse.getStatuses().forEach(s -> {
            Response response = httpResponse.getInlineEntities().stream().findAny().map(JsonMapper::map).map(this.dynamicTypeAnalyzer::analyze).map(Response::new).orElse(null);
            if (response == null) {
                response = httpResponse.getEntityTypes().isEmpty() ? new Response() : new Response(this.javaTypeAnalyzer.analyze(JavaUtils.determineMostSpecificType(httpResponse.getEntityTypes().toArray(new String[0]))));
            }
            response.getHeaders().addAll(httpResponse.getHeaders());
            method.getResponses().put((Integer)s, response);
        });
    }

    private void addMediaTypes(MethodResult methodResult, ClassResult classResult, ResourceMethod resourceMethod) {
        resourceMethod.getRequestMediaTypes().addAll(methodResult.getRequestMediaTypes());
        if (resourceMethod.getRequestMediaTypes().isEmpty()) {
            resourceMethod.getRequestMediaTypes().addAll(classResult.getRequestMediaTypes());
        }
        if (resourceMethod.getResponseMediaTypes().isEmpty()) {
            resourceMethod.getResponseMediaTypes().addAll(methodResult.getResponseMediaTypes());
        }
        if (resourceMethod.getResponseMediaTypes().isEmpty()) {
            resourceMethod.getResponseMediaTypes().addAll(classResult.getResponseMediaTypes());
        }
    }
}

