/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.instructions;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import org.objectweb.asm.Label;

public class LoadStoreInstructionPlaceholder
extends Instruction {
    private final Instruction.InstructionType type;
    private final int number;

    public LoadStoreInstructionPlaceholder(Instruction.InstructionType type, int number, Label label) {
        super(label);
        if (type != Instruction.InstructionType.LOAD_PLACEHOLDER && type != Instruction.InstructionType.STORE_PLACEHOLDER) {
            throw new IllegalArgumentException("Only LOAD and STORE placeholders allowed!");
        }
        this.type = type;
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    @Override
    public int getStackSizeDifference() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Instruction.InstructionType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadStoreInstructionPlaceholder that = (LoadStoreInstructionPlaceholder)o;
        if (this.number != that.number) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.number;
        return result;
    }
}

