/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.instructions;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.DefaultInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import org.objectweb.asm.Label;

public class SizeChangingInstruction
extends DefaultInstruction {
    private final int numberOfPushes;
    private final int numberOfPops;

    public SizeChangingInstruction(String description, int numberOfPushes, int numberOfPops, Label label) {
        super(description, label);
        if (numberOfPushes < 0 || numberOfPops < 0) {
            throw new IllegalArgumentException("Number of pushes and pops cannot be negative");
        }
        this.numberOfPushes = numberOfPushes;
        this.numberOfPops = numberOfPops;
    }

    public int getNumberOfPushes() {
        return this.numberOfPushes;
    }

    public int getNumberOfPops() {
        return this.numberOfPops;
    }

    @Override
    public Instruction.InstructionType getType() {
        return Instruction.InstructionType.SIZE_CHANGE;
    }

    @Override
    public int getStackSizeDifference() {
        return this.numberOfPushes - this.numberOfPops;
    }
}

