/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.rest;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class TypeIdentifier {
    public static final String DYNAMIC_TYPE_PREFIX = "$";
    private static final AtomicInteger dynamicCounter = new AtomicInteger();

    public abstract boolean equals(Object var1);

    public abstract String getType();

    public abstract String getName();

    public static TypeIdentifier ofType(String type) {
        return new JavaTypeIdentifier(type);
    }

    public static TypeIdentifier ofDynamic() {
        return new DynamicTypeIdentifier(dynamicCounter.incrementAndGet());
    }

    private static class DynamicTypeIdentifier
    extends TypeIdentifier {
        private final int number;

        public DynamicTypeIdentifier(int number) {
            this.number = number;
        }

        @Override
        public String getType() {
            return "Ljavax/json/Json;";
        }

        @Override
        public String getName() {
            return TypeIdentifier.DYNAMIC_TYPE_PREFIX + this.number;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DynamicTypeIdentifier that = (DynamicTypeIdentifier)o;
            return this.number == that.number;
        }

        public int hashCode() {
            return this.number;
        }

        public String toString() {
            return "DynamicTypeIdentifier{number=" + this.number + '}';
        }
    }

    private static class JavaTypeIdentifier
    extends TypeIdentifier {
        private final String type;

        public JavaTypeIdentifier(String type) {
            Objects.requireNonNull(type);
            this.type = type;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getName() {
            return this.type;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaTypeIdentifier that = (JavaTypeIdentifier)o;
            return this.type.equals(that.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return "JavaTypeIdentifier{type=" + this.type + '}';
        }
    }
}

