/*
 * Decompiled with CFR 0.152.
 */
package org.gm4java.engine.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.gm4java.engine.GMConnection;
import org.gm4java.engine.GMException;
import org.gm4java.engine.GMServiceException;
import org.gm4java.engine.support.ReaderWriterProcess;

class BasicGMConnection
implements GMConnection {
    private static final List<String> empty = Arrays.asList(new String[0]);
    private static final int NORMAL_BUFFER_SIZE = 4096;
    private static final String EOL = System.getProperty("line.separator");
    private static final int EOL_SIZE = EOL.length();
    private ReaderWriterProcess process;
    private final StringBuffer sb = new StringBuffer();

    public BasicGMConnection(@Nonnull ReaderWriterProcess process) throws GMServiceException {
        if (process == null) {
            throw new NullPointerException("process");
        }
        this.process = process;
    }

    @Override
    public final String execute(@Nonnull String command, String ... arguments) throws IOException, GMException, GMServiceException {
        if (command == null) {
            throw new NullPointerException("Argument 'command' must not be null");
        }
        return this.execute(command, arguments == null || arguments.length == 0 ? empty : Arrays.asList(arguments));
    }

    @Override
    public final String execute(@Nonnull List<String> command) throws IOException, GMException, GMServiceException {
        if (command == null) {
            throw new NullPointerException("Argument 'command' must not be null");
        }
        if (command.size() == 0) {
            throw new IllegalArgumentException("Argument 'command' must not be empty");
        }
        return this.execute(null, command);
    }

    @Override
    public void close() {
        if (this.process == null) {
            return;
        }
        this.process.destroy();
        this.process = null;
    }

    protected String execute(String command, @Nonnull List<String> arguments) throws IOException, GMException, GMServiceException {
        if (this.process == null) {
            throw new GMServiceException("GMConnection is already closed.");
        }
        this.sendCommand(command, arguments);
        return this.readResult();
    }

    private void sendCommand(String command, @Nonnull List<String> arguments) throws GMServiceException {
        Writer toGm = this.process.getWriter();
        try {
            if (command != null) {
                toGm.write(command);
            }
            for (String s : arguments) {
                int quote = 34;
                toGm.write(" ");
                toGm.write(34);
                int start = 0;
                int index = s.indexOf(34);
                if (index < 0) {
                    toGm.write(s);
                } else {
                    do {
                        toGm.write(s, start, ++index - start);
                        toGm.write(34);
                    } while ((index = s.indexOf(34, start = index)) >= 0);
                }
                toGm.write(34);
            }
            toGm.write(EOL);
            toGm.flush();
        }
        catch (IOException e) {
            throw new GMServiceException(e.getMessage(), e);
        }
    }

    private String readResult() throws IOException, GMServiceException, GMException {
        String line;
        BufferedReader fromGm = this.process.getReader();
        this.sb.setLength(0);
        while ((line = this.readLine(fromGm)) != null) {
            if (line.equals("OK")) {
                return this.getGMOutput();
            }
            if (line.equals("NG")) {
                String output = this.getGMOutput();
                if (output.endsWith("].")) {
                    throw new IOException(output);
                }
                throw new GMException(output);
            }
            this.sb.append(line).append(EOL);
        }
        throw new GMServiceException("Input from GraphicsMagick was closed unexpectedly after receiving: " + this.getGMOutput());
    }

    private String getGMOutput() {
        int size = this.sb.length() - EOL_SIZE;
        if (size > 0) {
            this.sb.setLength(size);
        }
        String output = this.sb.toString();
        if (this.sb.length() > 4096) {
            this.sb.setLength(0);
            this.sb.trimToSize();
        }
        return output;
    }

    private String readLine(BufferedReader reader) throws GMServiceException {
        try {
            return reader.readLine();
        }
        catch (IOException e) {
            throw new GMServiceException(e.getMessage(), e);
        }
    }
}

