/*
 * Decompiled with CFR 0.152.
 */
package org.gm4java.engine.support;

import java.io.IOException;
import java.util.Scanner;
import javax.annotation.Nonnull;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.gm4java.engine.support.GMProcessFactory;
import org.gm4java.engine.support.ReaderWriterProcess;
import org.gm4java.engine.support.ReaderWriterProcessImpl;

class GMProcessFactoryImpl
implements GMProcessFactory {
    public static final GMProcessFactory.Builder BUILDER = new GMProcessFactory.Builder(){
        private final ReaderWriterProcess.Factory factory = ReaderWriterProcessImpl.FACTORY;

        @Override
        @Nonnull
        public GMProcessFactory buildFactory(String gmPath) {
            return new GMProcessFactoryImpl(this.factory, gmPath);
        }
    };
    private static final String[] GM_COMMAND_SAFE_MODE = new String[]{"gm", "batch", "-escape", "windows", "-feedback", "on", "-pass", "OK", "-fail", "NG", "-prompt", "off", "-echo", "off", "-safe-mode", "on", "-"};
    private static final String[] GM_COMMAND = new String[]{"gm", "batch", "-escape", "windows", "-feedback", "on", "-pass", "OK", "-fail", "NG", "-prompt", "off", "-echo", "off", "-"};
    private static final DefaultArtifactVersion version_1_3_22 = new DefaultArtifactVersion("1.3.22");
    private final ReaderWriterProcess.Factory factory;
    private final String gmPath;
    private DefaultArtifactVersion version;
    private String[] gmCommand;

    GMProcessFactoryImpl(ReaderWriterProcess.Factory factory, String gmPath) {
        this.factory = factory;
        this.gmPath = gmPath;
    }

    @Override
    @Nonnull
    public DefaultArtifactVersion getVersion() {
        try {
            this.ensureFeatures();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return this.version;
    }

    @Override
    @Nonnull
    public String getGMPath() {
        return this.gmPath;
    }

    @Override
    @Nonnull
    public ReaderWriterProcess getProcess() throws IOException {
        this.ensureFeatures();
        return this.factory.getProcess(this.gmCommand);
    }

    static String[] getGMCommand(String gmPath) {
        String[] gmCommand = (String[])GM_COMMAND.clone();
        gmCommand[0] = gmPath;
        return gmCommand;
    }

    static String[] getGMCommandSafeMode(String gmPath) {
        String[] gmCommand = (String[])GM_COMMAND_SAFE_MODE.clone();
        gmCommand[0] = gmPath;
        return gmCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFeatures() throws IOException {
        if (this.gmCommand != null) {
            return;
        }
        ReaderWriterProcess proc = this.factory.getProcess(this.gmPath, "version");
        Scanner scanner = new Scanner(proc.getReader());
        try {
            if (!scanner.hasNextLine()) {
                throw new IOException(String.format("Could not detect your GraphicsMagick version, is '%s' in PATH?", this.gmPath));
            }
            String[] firstLineInWords = scanner.nextLine().split(" ");
            this.version = new DefaultArtifactVersion(firstLineInWords[1]);
            this.gmCommand = this.version.compareTo((ArtifactVersion)version_1_3_22) >= 0 ? GMProcessFactoryImpl.getGMCommand(this.gmPath) : GMProcessFactoryImpl.getGMCommandSafeMode(this.gmPath);
        }
        finally {
            scanner.close();
            proc.destroy();
        }
    }
}

