/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.phase04processclasses;

import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.CommandExecutor;
import com.simpligility.maven.plugins.android.ExecutionException;
import com.simpligility.maven.plugins.android.IncludeExcludeSet;
import com.simpligility.maven.plugins.android.InclusionExclusionResolver;
import com.simpligility.maven.plugins.android.config.ConfigHandler;
import com.simpligility.maven.plugins.android.config.ConfigPojo;
import com.simpligility.maven.plugins.android.config.PullParameter;
import com.simpligility.maven.plugins.android.configuration.Proguard;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.interpolation.os.Os;

@Mojo(name="proguard", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ProguardMojo
extends AbstractAndroidMojo {
    @ConfigPojo
    @Parameter
    protected Proguard proguard;
    @Parameter(property="android.proguard.skip")
    private Boolean proguardSkip;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedSkip;
    @PullParameter(defaultValue={"${project.basedir}/proguard.cfg"})
    private File parsedConfig;
    @PullParameter(defaultValueGetterMethod="getDefaultProguardConfigs")
    private String[] parsedConfigs;
    @Parameter(property="android.proguard.options")
    private String[] proguardOptions;
    @PullParameter(defaultValueGetterMethod="getDefaultProguardOptions")
    private String[] parsedOptions;
    @Parameter(property="android.proguard.proguardJarPath")
    private String proguardProguardJarPath;
    @PullParameter(defaultValueGetterMethod="getProguardJarPath")
    private String parsedProguardJarPath;
    @Parameter(property="android.proguard.outputDirectory")
    private File outputDirectory;
    @PullParameter(defaultValue={"${project.build.directory}/proguard"})
    private File parsedOutputDirectory;
    @Parameter(property="android.proguard.obfuscatedJar", defaultValue="${project.build.directory}/${project.build.finalName}_obfuscated.jar")
    private String obfuscatedJar;
    @Parameter(property="android.proguard.jvmArguments")
    private String[] proguardJvmArguments;
    @PullParameter(defaultValueGetterMethod="getDefaultJvmArguments")
    private String[] parsedJvmArguments;
    @Parameter(property="android.proguard.filterMavenDescriptor")
    private Boolean proguardFilterMavenDescriptor;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedFilterMavenDescriptor;
    @Parameter(property="android.proguard.filterManifest")
    private Boolean proguardFilterManifest;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedFilterManifest;
    @Parameter(property="android.proguard.customfilter")
    private String proguardCustomFilter;
    @PullParameter
    private String parsedCustomFilter;
    @Parameter(property="android.proguard.includeJdkLibs")
    private Boolean includeJdkLibs;
    @PullParameter(defaultValue={"true"})
    private Boolean parsedIncludeJdkLibs;
    @Parameter(property="android.proguard.attachMap")
    private Boolean attachMap;
    @PullParameter(defaultValue={"false"})
    private Boolean parsedAttachMap;
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    protected List<Artifact> pluginDependencies;
    @Parameter(property="skipDependencies", defaultValue="false")
    private boolean skipDependencies;
    @Parameter(property="artifactTypeSet")
    private IncludeExcludeSet artifactTypeSet;
    @Parameter(property="artifactSet")
    private IncludeExcludeSet artifactSet;
    private static final Collection<String> ANDROID_LIBRARY_EXCLUDED_FILTER = Arrays.asList("org/xml/**", "org/w3c/**", "java/**", "javax/**");
    private static final Collection<String> MAVEN_DESCRIPTOR = Arrays.asList("META-INF/maven/**");
    private static final Collection<String> META_INF_MANIFEST = Arrays.asList("META-INF/MANIFEST.MF");
    private static final String JAR_DEPENDENCY_TYPE = "jar";
    private List<ArtifactPrototype> artifactBlacklist = new LinkedList<ArtifactPrototype>();
    private List<ArtifactPrototype> artifactsToShift = new LinkedList<ArtifactPrototype>();
    private File javaHomeDir;
    private File javaLibDir;
    private File altJavaLibDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getJack().isEnabled().booleanValue()) {
            return;
        }
        ConfigHandler configHandler = new ConfigHandler((Object)this, this.session, this.execution);
        configHandler.parseConfiguration();
        if (!this.parsedSkip.booleanValue()) {
            if (this.parsedConfig.exists()) {
                this.project.getProperties().setProperty("android.proguard.obfuscatedJar", this.obfuscatedJar);
                this.executeProguard();
            } else {
                this.getLog().info((CharSequence)String.format("Proguard skipped because the configuration file doesn't exist: %s", this.parsedConfig));
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeProguard() throws MojoExecutionException {
        File proguardDir = this.parsedOutputDirectory;
        if (!proguardDir.exists() && !proguardDir.mkdir()) {
            throw new MojoExecutionException("Cannot create proguard output directory");
        }
        if (proguardDir.exists() && !proguardDir.isDirectory()) {
            throw new MojoExecutionException("Non-directory exists at " + proguardDir.getAbsolutePath());
        }
        this.getLog().info((CharSequence)"Proguarding output");
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        ArrayList<String> commands = new ArrayList<String>();
        this.collectJvmArguments(commands);
        commands.add("-jar");
        commands.add(this.parsedProguardJarPath);
        ArrayList<String> proguardCommands = new ArrayList<String>();
        proguardCommands.add("@" + this.parsedConfig + "");
        for (String config : this.parsedConfigs) {
            proguardCommands.add("@" + config);
        }
        if (this.proguardFile != null) {
            proguardCommands.add("@" + this.proguardFile.getAbsolutePath());
        }
        for (Artifact artifact : this.getTransitiveDependencyArtifacts("aar")) {
            File unpackedLibFolder = this.getUnpackedLibFolder(artifact);
            File proguardFile = new File(unpackedLibFolder, "proguard.txt");
            if (!proguardFile.exists()) continue;
            proguardCommands.add("@" + proguardFile.getAbsolutePath());
        }
        this.collectInputFiles(proguardCommands);
        proguardCommands.add("-outjars");
        proguardCommands.add(this.obfuscatedJar);
        proguardCommands.add("-dump");
        proguardCommands.add(proguardDir + File.separator + "dump.txt");
        proguardCommands.add("-printseeds");
        proguardCommands.add(proguardDir + File.separator + "seeds.txt");
        proguardCommands.add("-printusage");
        proguardCommands.add(proguardDir + File.separator + "usage.txt");
        File mapFile = new File(proguardDir, "mapping.txt");
        proguardCommands.add("-printmapping");
        proguardCommands.add(mapFile.toString());
        proguardCommands.addAll(Arrays.asList(this.parsedOptions));
        String javaExecutable = ProguardMojo.getJavaExecutable().getAbsolutePath();
        this.getLog().debug((CharSequence)(javaExecutable + " " + ((Object)commands).toString() + ((Object)proguardCommands).toString()));
        FileOutputStream tempConfigFileOutputStream = null;
        try {
            File tempConfigFile = new File(proguardDir, "temp_config.cfg");
            StringBuilder commandStringBuilder = new StringBuilder();
            for (String command : proguardCommands) {
                commandStringBuilder.append(command);
                commandStringBuilder.append(SystemUtils.LINE_SEPARATOR);
            }
            tempConfigFileOutputStream = new FileOutputStream(tempConfigFile);
            IOUtils.write((CharSequence)commandStringBuilder, (OutputStream)tempConfigFileOutputStream);
            executor.setCaptureStdOut(true);
            commands.add("@" + tempConfigFile.getAbsolutePath() + "");
            executor.executeCommand(javaExecutable, commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            try {
                throw new MojoExecutionException("", (Exception)e);
                catch (IOException e2) {
                    throw new MojoExecutionException("Error writing proguard commands to temporary file", (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(tempConfigFileOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)tempConfigFileOutputStream);
        if (this.parsedAttachMap.booleanValue()) {
            this.projectHelper.attachArtifact(this.project, "map", mapFile);
        }
    }

    private void collectJvmArguments(List<String> commands) {
        if (this.parsedJvmArguments != null) {
            for (String jvmArgument : this.parsedJvmArguments) {
                if (!jvmArgument.startsWith("-")) {
                    jvmArgument = "-" + jvmArgument;
                }
                commands.add(jvmArgument);
            }
        }
    }

    private void collectInputFiles(List<String> commands) throws MojoExecutionException {
        this.skipArtifact("commons-logging", "commons-logging", true);
        List<ProGuardInput> inJars = this.getProgramInputFiles();
        if (this.isAPKBuild()) {
            inJars.addAll(this.getProjectDependencyFiles());
        }
        for (ProGuardInput injar : inJars) {
            this.getLog().debug((CharSequence)("Added injar : " + injar));
            commands.add("-injars");
            commands.add(injar.toPath());
        }
        List<ProGuardInput> libraryJars = this.getLibraryInputFiles();
        if (!this.isAPKBuild()) {
            this.getLog().info((CharSequence)"Library project - not adding project dependencies to the obfuscated JAR");
            libraryJars.addAll(this.getProjectDependencyFiles());
        }
        for (ProGuardInput libraryjar : libraryJars) {
            this.getLog().debug((CharSequence)("Added libraryJar : " + libraryjar));
            commands.add("-libraryjars");
            commands.add(libraryjar.toPath());
        }
    }

    private static File getJavaExecutable() {
        String javaHome = System.getProperty("java.home");
        String slash = File.separator;
        return new File(javaHome + slash + "bin" + slash + "java");
    }

    private void skipArtifact(String groupId, String artifactId, boolean shiftToLibraries) throws MojoExecutionException {
        ArtifactPrototype artifact = new ArtifactPrototype(groupId, artifactId);
        this.artifactBlacklist.add(artifact);
        if (shiftToLibraries) {
            this.artifactsToShift.add(artifact);
        }
    }

    private boolean isBlacklistedArtifact(Artifact artifact) {
        for (ArtifactPrototype artifactToSkip : this.artifactBlacklist) {
            if (!artifactToSkip.groupId.equals(artifact.getGroupId()) || !artifactToSkip.artifactId.equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private boolean isShiftedArtifact(Artifact artifact) {
        for (ArtifactPrototype artifactToShift : this.artifactsToShift) {
            if (!artifactToShift.groupId.equals(artifact.getGroupId()) || !artifactToShift.artifactId.equals(artifact.getArtifactId())) continue;
            return true;
        }
        return false;
    }

    private List<ProGuardInput> getProgramInputFiles() {
        LinkedList<ProGuardInput> inJars = new LinkedList<ProGuardInput>();
        inJars.add(this.createProguardInput(this.projectOutputDirectory.getAbsolutePath()));
        return inJars;
    }

    private List<ProGuardInput> getProjectDependencyFiles() {
        HashSet<String> globalInJarExcludes = new HashSet<String>();
        LinkedList<ProGuardInput> inJars = new LinkedList<ProGuardInput>();
        if (this.parsedFilterManifest.booleanValue()) {
            globalInJarExcludes.addAll(META_INF_MANIFEST);
        }
        if (this.parsedFilterMavenDescriptor.booleanValue()) {
            globalInJarExcludes.addAll(MAVEN_DESCRIPTOR);
        }
        if (this.parsedCustomFilter != null) {
            globalInJarExcludes.addAll(Arrays.asList(this.parsedCustomFilter.split(",")));
        }
        for (Artifact artifact : InclusionExclusionResolver.filterArtifacts(this.getTransitiveDependencyArtifacts(new String[0]), this.skipDependencies, this.artifactTypeSet.getIncludes(), this.artifactTypeSet.getExcludes(), this.artifactSet.getIncludes(), this.artifactSet.getExcludes())) {
            if (this.isBlacklistedArtifact(artifact)) {
                this.getLog().debug((CharSequence)("Excluding (blacklisted) dependency as input jar : " + artifact));
                continue;
            }
            if (JAR_DEPENDENCY_TYPE.equals(artifact.getType())) {
                this.getLog().debug((CharSequence)("Including dependency as input jar : " + artifact));
                inJars.add(this.createProguardInput(artifact.getFile().getAbsolutePath(), globalInJarExcludes));
                continue;
            }
            if ("aar".equals(artifact.getType())) continue;
            this.getLog().debug((CharSequence)("Excluding dependency as input jar : " + artifact));
        }
        return inJars;
    }

    private ProGuardInput createProguardInput(String path, Collection<String> filterExpression) {
        return new ProGuardInput(path, filterExpression);
    }

    private ProGuardInput createProguardInput(String path) {
        return this.createProguardInput(path, null);
    }

    private List<ProGuardInput> getLibraryInputFiles() {
        LinkedList<ProGuardInput> libraryJars = new LinkedList<ProGuardInput>();
        if (this.parsedIncludeJdkLibs.booleanValue()) {
            File jceJar;
            File jsseJar;
            File rtJar = this.getJVMLibrary("rt.jar");
            if (rtJar == null) {
                rtJar = this.getJVMLibrary("classes.jar");
            }
            if (rtJar != null) {
                libraryJars.add(this.createProguardInput(rtJar.getPath()));
            }
            if ((jsseJar = this.getJVMLibrary("jsse.jar")) != null) {
                libraryJars.add(this.createProguardInput(jsseJar.getPath()));
            }
            if ((jceJar = this.getJVMLibrary("jce.jar")) != null) {
                libraryJars.add(this.createProguardInput(jceJar.getPath()));
            }
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if (artifact.getScope().equals("provided")) {
                if (artifact.getArtifactId().equals("android") && this.parsedIncludeJdkLibs.booleanValue()) {
                    this.getLog().debug((CharSequence)("Including dependency as (android) library jar : " + artifact));
                    libraryJars.add(this.createProguardInput(artifact.getFile().getAbsolutePath(), ANDROID_LIBRARY_EXCLUDED_FILTER));
                    continue;
                }
                this.getLog().debug((CharSequence)("Including dependency as (provided) library jar : " + artifact));
                libraryJars.add(this.createProguardInput(artifact.getFile().getAbsolutePath()));
                continue;
            }
            if (this.isShiftedArtifact(artifact)) {
                this.getLog().debug((CharSequence)("Including dependency as (shifted) library jar : " + artifact));
                libraryJars.add(this.createProguardInput(artifact.getFile().getAbsolutePath()));
                continue;
            }
            this.getLog().debug((CharSequence)("Excluding dependency as library jar : " + artifact));
        }
        return libraryJars;
    }

    private String getProguardJarPath() throws MojoExecutionException {
        return this.getProguardJarPathFromDependencies();
    }

    private String getProguardJarPathFromDependencies() throws MojoExecutionException {
        Artifact proguardArtifact = null;
        int proguardArtifactDistance = -1;
        for (Artifact artifact : this.pluginDependencies) {
            this.getLog().debug((CharSequence)("pluginArtifact: " + artifact.getFile()));
            if (!"proguard".equals(artifact.getArtifactId()) && !"proguard-base".equals(artifact.getArtifactId())) continue;
            int distance = artifact.getDependencyTrail().size();
            this.getLog().debug((CharSequence)("proguard DependencyTrail: " + distance));
            if (proguardArtifactDistance == -1) {
                proguardArtifact = artifact;
                proguardArtifactDistance = distance;
                continue;
            }
            if (distance >= proguardArtifactDistance) continue;
            proguardArtifact = artifact;
            proguardArtifactDistance = distance;
        }
        if (proguardArtifact != null) {
            this.getLog().debug((CharSequence)("proguardArtifact: " + proguardArtifact.getFile()));
            return proguardArtifact.getFile().getAbsoluteFile().toString();
        }
        return null;
    }

    private String[] getDefaultJvmArguments() {
        return new String[]{"-Xmx512M"};
    }

    private String[] getDefaultProguardConfigs() {
        return new String[0];
    }

    private String[] getDefaultProguardOptions() {
        return new String[0];
    }

    private File getJVMLibrary(String fileName) {
        File libFile = new File(this.getJavaLibDir(), fileName);
        if (!libFile.exists() && !(libFile = new File(this.getAltJavaLibDir(), fileName)).exists()) {
            libFile = null;
        }
        return libFile;
    }

    private File getJavaHomeDir() {
        if (this.javaHomeDir == null) {
            this.javaHomeDir = new File(System.getProperty("java.home"));
        }
        return this.javaHomeDir;
    }

    private File getJavaLibDir() {
        if (this.javaLibDir == null) {
            this.javaLibDir = new File(this.getJavaHomeDir(), "lib");
        }
        return this.javaLibDir;
    }

    private File getAltJavaLibDir() {
        if (this.altJavaLibDir == null) {
            this.altJavaLibDir = new File(this.getJavaHomeDir().getParent(), "Classes");
        }
        return this.altJavaLibDir;
    }

    private static class ProGuardInput {
        private String path;
        private Collection<String> excludedFilter;

        ProGuardInput(String path, Collection<String> excludedFilter) {
            this.path = path;
            this.excludedFilter = excludedFilter;
        }

        public String toPath() {
            if (this.excludedFilter != null && !this.excludedFilter.isEmpty()) {
                String endQuote;
                String middleQuote;
                if (!Os.isFamily((String)"windows")) {
                    middleQuote = "(";
                    endQuote = ")";
                } else {
                    middleQuote = "(";
                    endQuote = ")";
                }
                StringBuilder sb = new StringBuilder();
                sb.append(this.path);
                sb.append(middleQuote);
                Iterator<String> it = this.excludedFilter.iterator();
                while (it.hasNext()) {
                    sb.append('!').append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(',');
                }
                sb.append(endQuote);
                return sb.toString();
            }
            return this.path;
        }

        public String toString() {
            return "ProGuardInput{path='" + this.path + '\'' + ", excludedFilter=" + this.excludedFilter + '}';
        }
    }

    private static class ArtifactPrototype {
        private final String groupId;
        private final String artifactId;

        private ArtifactPrototype(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }
    }
}

