/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.phase09package;

import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.CommandExecutor;
import com.simpligility.maven.plugins.android.ExecutionException;
import com.simpligility.maven.plugins.android.common.AaptCommandBuilder;
import com.simpligility.maven.plugins.android.common.NativeHelper;
import com.simpligility.maven.plugins.android.config.PullParameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.archiver.zip.ZipArchiver;

@Mojo(name="aar", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE)
public class AarMojo
extends AbstractAndroidMojo {
    public static final String NATIVE_LIBRARIES_FOLDER = "jni";
    @Parameter
    private String classifier;
    @PullParameter
    @Parameter
    private String applicationMakefile;
    @PullParameter
    @Parameter(property="android.ndk.build.architecture")
    private String ndkArchitecture;
    @PullParameter
    @Parameter(property="android.ndk.build.native-classifier")
    private String ndkClassifier;
    @PullParameter
    @Parameter
    private String[] classesJarIncludes = new String[]{"**/*"};
    @PullParameter
    @Parameter
    private String[] classesJarExcludes = new String[]{"**/R.class", "**/R$*.class"};
    @Parameter
    private File[] consumerProguardFiles;
    @Parameter(property="android.proguard.obfuscatedJar", defaultValue="${project.build.directory}/${project.build.finalName}_obfuscated.jar")
    private String obfuscatedJar;
    private List<String> sourceFolders = new ArrayList<String>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        String out = this.targetDirectory.getPath();
        for (String src : this.project.getCompileSourceRoots()) {
            if (src.startsWith(out)) continue;
            this.sourceFolders.add(src);
        }
        this.getLog().info((CharSequence)("Generating AAR file : " + this.project.getArtifactId()));
        this.generateIntermediateApk();
        File outputFile = this.createAarLibraryFile(this.createAarClassesJar());
        if (this.classifier == null) {
            this.project.getArtifact().setFile(outputFile);
        } else {
            this.projectHelper.attachArtifact(this.project, "aar", this.classifier, outputFile);
        }
    }

    protected File createAarClassesJar() throws MojoExecutionException {
        File obfuscatedJarFile = new File(this.obfuscatedJar);
        if (obfuscatedJarFile.exists()) {
            this.attachJar(obfuscatedJarFile);
            return obfuscatedJarFile;
        }
        File classesJar = new File(this.targetDirectory, this.finalName + ".aar.classes.jar");
        try {
            JarArchiver jarArchiver = new JarArchiver();
            jarArchiver.setDestFile(classesJar);
            jarArchiver.addDirectory(this.projectOutputDirectory, this.classesJarIncludes, this.classesJarExcludes);
            jarArchiver.createArchive();
            this.attachJar(classesJar);
            return classesJar;
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating ." + classesJar + " file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating ." + classesJar + " file.", (Exception)e);
        }
    }

    private void attachJar(File jarFile) {
        if (this.attachJar) {
            this.projectHelper.attachArtifact(this.project, "jar", this.project.getArtifact().getClassifier(), jarFile);
        }
    }

    protected File createAarLibraryFile(File classesJar) throws MojoExecutionException {
        File aarLibrary = new File(this.targetDirectory, this.finalName + "." + "aar");
        FileUtils.deleteQuietly((File)aarLibrary);
        try {
            ZipArchiver zipArchiver;
            block15: {
                File[] overlayDirectories;
                zipArchiver = new ZipArchiver();
                zipArchiver.setDestFile(aarLibrary);
                zipArchiver.addFile(this.destinationManifestFile, "AndroidManifest.xml");
                this.addDirectory(zipArchiver, this.assetsDirectory, "assets", false);
                if (!this.resourceDirectory.exists()) {
                    this.resourceDirectory.mkdir();
                }
                this.addDirectory(zipArchiver, this.resourceDirectory, "res", true);
                zipArchiver.addFile(classesJar, "classes.jar");
                for (File resOverlayDir : overlayDirectories = this.getResourceOverlayDirectories()) {
                    if (resOverlayDir == null || !resOverlayDir.exists()) continue;
                    this.addDirectory(zipArchiver, resOverlayDir, "res", false);
                }
                if (this.consumerProguardFiles == null) break block15;
                File mergedConsumerProguardFile = new File(this.targetDirectory, "consumer-proguard.txt");
                if (mergedConsumerProguardFile.exists()) {
                    FileUtils.forceDelete((File)mergedConsumerProguardFile);
                }
                mergedConsumerProguardFile.createNewFile();
                StringBuilder mergedConsumerProguardFileBuilder = new StringBuilder();
                for (File consumerProguardFile : this.consumerProguardFiles) {
                    if (!consumerProguardFile.exists()) continue;
                    this.getLog().info((CharSequence)("Adding consumer proguard file " + consumerProguardFile));
                    FileInputStream consumerProguardFileInputStream = null;
                    try {
                        consumerProguardFileInputStream = new FileInputStream(consumerProguardFile);
                        mergedConsumerProguardFileBuilder.append(IOUtils.toString((InputStream)consumerProguardFileInputStream));
                        mergedConsumerProguardFileBuilder.append(SystemUtils.LINE_SEPARATOR);
                    }
                    catch (IOException e) {
                        try {
                            throw new MojoExecutionException("Error writing consumer proguard file ", (Exception)e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(consumerProguardFileInputStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)consumerProguardFileInputStream);
                }
                FileOutputStream mergedConsumerProguardFileOutputStream = null;
                try {
                    mergedConsumerProguardFileOutputStream = new FileOutputStream(mergedConsumerProguardFile);
                    IOUtils.write((CharSequence)mergedConsumerProguardFileBuilder, (OutputStream)mergedConsumerProguardFileOutputStream);
                }
                catch (IOException e) {
                    try {
                        throw new MojoExecutionException("Error writing consumer proguard file ", (Exception)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(mergedConsumerProguardFileOutputStream);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((OutputStream)mergedConsumerProguardFileOutputStream);
                zipArchiver.addFile(mergedConsumerProguardFile, "proguard.txt");
            }
            this.addR(zipArchiver);
            this.addNativeLibraries(zipArchiver);
            zipArchiver.createArchive();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("ArchiverException while creating .aar file.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("IOException while creating .aar file.", (Exception)e);
        }
        return aarLibrary;
    }

    private void addR(ZipArchiver zipArchiver) throws MojoExecutionException, IOException {
        File rFile = new File(this.targetDirectory, "R.txt");
        if (!rFile.exists()) {
            this.getLog().debug((CharSequence)"No resources - creating empty R.txt");
            if (!rFile.createNewFile()) {
                this.getLog().warn((CharSequence)"Unable to create R.txt in AAR");
            }
        }
        zipArchiver.addFile(rFile, "R.txt");
        this.getLog().debug((CharSequence)"Packaging R.txt in AAR");
    }

    private void addNativeLibraries(ZipArchiver zipArchiver) throws MojoExecutionException {
        try {
            if (this.nativeLibrariesDirectory.exists()) {
                this.getLog().info((CharSequence)(this.nativeLibrariesDirectory + " exists, adding libraries."));
                this.addDirectory(zipArchiver, this.nativeLibrariesDirectory, NATIVE_LIBRARIES_FOLDER, false);
            } else {
                String[] ndkArchitectures;
                this.getLog().info((CharSequence)(this.nativeLibrariesDirectory + " does not exist, looking for libraries in target directory."));
                for (String architecture : ndkArchitectures = NativeHelper.getNdkArchitectures(this.ndkArchitecture, this.applicationMakefile, this.project.getBasedir())) {
                    File ndkLibsDirectory = new File(this.ndkOutputDirectory, architecture);
                    this.addSharedLibraries(zipArchiver, ndkLibsDirectory, architecture);
                }
            }
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("IOException while creating .aar file.", (Exception)((Object)e));
        }
    }

    protected String endWithSlash(String prefix) {
        if (!(prefix = (String)StringUtils.defaultIfEmpty((CharSequence)prefix, (CharSequence)"/")).endsWith("/")) {
            prefix = prefix + "/";
        }
        return prefix;
    }

    protected void addDirectory(ZipArchiver zipArchiver, File directory, String prefix, boolean includeEmptyFolders) {
        if (directory != null && directory.exists()) {
            DefaultFileSet fileSet = new DefaultFileSet();
            fileSet.setPrefix(this.endWithSlash(prefix));
            fileSet.setDirectory(directory);
            fileSet.setIncludingEmptyDirectories(includeEmptyFolders);
            zipArchiver.addFileSet((FileSet)fileSet);
            this.getLog().debug((CharSequence)("Added files from " + directory));
        }
    }

    protected void addSharedLibraries(ZipArchiver zipArchiver, File directory, String architecture) {
        this.getLog().debug((CharSequence)("Searching for shared libraries in " + directory));
        File[] libFiles = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("lib") && name.endsWith(".so");
            }
        });
        if (libFiles != null) {
            for (File libFile : libFiles) {
                String dest = "jni/" + architecture + "/" + libFile.getName();
                this.getLog().debug((CharSequence)("Adding " + libFile + " as " + dest));
                zipArchiver.addFile(libFile, dest);
            }
        }
    }

    private void generateIntermediateApk() throws MojoExecutionException {
        ArrayList<File> dependenciesResDirectories = new ArrayList<File>();
        for (Artifact libraryArtifact : this.getTransitiveDependencyArtifacts("apklib", "aar")) {
            File apkLibResDir = this.getUnpackedLibResourceFolder(libraryArtifact);
            if (!apkLibResDir.exists()) continue;
            dependenciesResDirectories.add(apkLibResDir);
        }
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        File outputFile = new File(this.targetDirectory, this.finalName + ".ap_");
        AaptCommandBuilder.AaptPackageCommandBuilder commandBuilder = AaptCommandBuilder.packageResources(this.getLog()).makePackageDirectories().forceOverwriteExistingFiles().setPathToAndroidManifest(this.destinationManifestFile).addResourceDirectoriesIfExists(this.getResourceOverlayDirectories()).addResourceDirectoryIfExists(this.resourceDirectory).addResourceDirectoriesIfExists(dependenciesResDirectories).autoAddOverlay().addRawAssetsDirectoryIfExists(this.combinedAssets).addExistingPackageToBaseIncludeSet(this.getAndroidSdk().getAndroidJar()).setOutputApkFile(outputFile).addConfigurations(this.configurations).setResourceConstantsFolder(this.genDirectory).makeResourcesNonConstant().generateRTextFile(this.targetDirectory).setVerbose(this.aaptVerbose);
        this.getLog().debug((CharSequence)(this.getAndroidSdk().getAaptPath() + " " + commandBuilder.toString()));
        this.getLog().info((CharSequence)"Generating aar");
        try {
            executor.setCaptureStdOut(true);
            List<String> commands = commandBuilder.build();
            executor.executeCommand(this.getAndroidSdk().getAaptPath(), commands, this.project.getBasedir(), false);
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException("", (Exception)e);
        }
    }
}

