/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.scapegoat.io;

import com.sksamuel.scapegoat.Feedback;
import com.sksamuel.scapegoat.Levels$Error$;
import com.sksamuel.scapegoat.Levels$Info$;
import com.sksamuel.scapegoat.Levels$Warning$;
import com.sksamuel.scapegoat.Warning;
import com.sksamuel.scapegoat.io.ReportWriter;
import java.io.File;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class MarkdownReportWriter$
implements ReportWriter {
    public static MarkdownReportWriter$ MODULE$;

    static {
        new MarkdownReportWriter$();
    }

    @Override
    public File write(File targetDir, Feedback feedback) {
        return ReportWriter.write$(this, targetDir, feedback);
    }

    @Override
    public String fileName() {
        return "scapegoat.md";
    }

    @Override
    public String generate(Feedback reporter) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("# Scapegoat Inspections\n       |\n       |**Errors**: ").append(((Object)BoxesRunTime.boxToInteger((int)reporter.warnings(Levels$Error$.MODULE$).size())).toString()).append("\n       |\n       |**Warnings**: ").append(((Object)BoxesRunTime.boxToInteger((int)reporter.warnings(Levels$Warning$.MODULE$).size())).toString()).append("\n       |\n       |**Infos**: ").append(((Object)BoxesRunTime.boxToInteger((int)reporter.warnings(Levels$Info$.MODULE$).size())).toString()).append("\n       |\n       |## Report\n       |\n       |").append(this.renderAll(reporter)).append("\n       |").toString())).stripMargin();
    }

    private String renderAll(Feedback reporter) {
        return ((TraversableOnce)reporter.warningsWithMinimalLevel().map((Function1 & java.io.Serializable & Serializable)warning -> MODULE$.renderWarning((Warning)warning), Seq$.MODULE$.canBuildFrom())).mkString("\n");
    }

    /*
     * WARNING - void declaration
     */
    private String renderWarning(Warning warning) {
        void var3_3;
        String source = new StringBuilder(1).append(warning.sourceFileNormalized()).append(":").append(warning.line()).toString();
        String md = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(152).append("### ").append(source).append("\n         |\n         |**Level**: ").append(warning.level().toString()).append("\n         |\n         |**Inspection**: ").append(warning.inspection()).append("\n         |\n         |").append(warning.text()).append("\n         |\n         |").append(warning.explanation()).append("\n         |\n         |").append(warning.snippet().map((Function1 & java.io.Serializable & Serializable)snippet -> new StringBuilder(14).append("\n```scala\n").append((String)snippet).append("\n```").toString()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> "")).append("\n         |").toString())).stripMargin();
        return var3_3;
    }

    private MarkdownReportWriter$() {
        MODULE$ = this;
        ReportWriter.$init$(this);
    }
}

