/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.utilint.StatCaptureRepDefinitions;
import com.sleepycat.je.statcap.StatManager;
import com.sleepycat.je.utilint.StatGroup;
import java.util.Map;

public class RepStatManager
extends StatManager {
    private final StatManager.UpdateMinMax updateRepMinMaxStat = new StatManager.UpdateMinMax(this, StatCaptureRepDefinitions.minStats, StatCaptureRepDefinitions.maxStats);

    public RepStatManager(RepImpl env) {
        super(env);
    }

    public synchronized ReplicatedEnvironmentStats getRepStats(StatsConfig config, Integer contextKey) {
        StatManager.StatContext sc = (StatManager.StatContext)this.statContextMap.get(contextKey);
        if (sc == null) {
            throw EnvironmentFailureException.unexpectedState("Internal error stat context is not registered");
        }
        ReplicatedEnvironmentStats rstat = ((RepImpl)this.env).getStatsInternal(config);
        if (rstat == null) {
            return null;
        }
        Map<String, StatGroup> cur = rstat.getStatGroupsMap();
        Map<String, StatGroup> base = sc.getRepBase();
        ReplicatedEnvironmentStats intervalStats = base != null ? this.computeRepIntervalStats(cur, base) : rstat;
        if (config.getClear()) {
            for (StatManager.StatContext context : this.statContextMap.values()) {
                if (context.getRepBase() == null) continue;
                this.updateRepMinMaxStat.updateBase(context.getRepBase(), cur);
            }
            for (StatManager.StatContext context : this.statContextMap.values()) {
                if (context == sc) {
                    context.setRepBase(null);
                    continue;
                }
                if (context.getRepBase() == null) {
                    context.setRepBase(this.cloneAndNegate(cur));
                    continue;
                }
                context.setRepBase(this.computeRepIntervalStats(context.getRepBase(), cur).getStatGroupsMap());
            }
        }
        return intervalStats;
    }

    private ReplicatedEnvironmentStats computeRepIntervalStats(Map<String, StatGroup> current, Map<String, StatGroup> base) {
        ReplicatedEnvironmentStats envStats = new ReplicatedEnvironmentStats();
        for (StatGroup cg : current.values()) {
            if (base != null) {
                StatGroup bg = base.get(cg.getName());
                envStats.setStatGroup(cg.computeInterval(bg));
                continue;
            }
            envStats.setStatGroup(cg.cloneGroup(false));
        }
        return envStats;
    }
}

