/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.elections.ElectionAgentThread;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThreadFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Learner
extends ElectionAgentThread {
    private final ServiceDispatcher serviceDispatcher;
    private final List<Listener> listeners = new LinkedList<Listener>();
    private Proposer.Proposal currentProposal = null;
    private Protocol.Value currentValue = null;
    public static final String SERVICE_NAME = "Learner";

    public Learner(Protocol protocol, ServiceDispatcher serviceDispatcher) {
        this(null, protocol, serviceDispatcher);
    }

    public Learner(RepImpl repImpl, Protocol protocol, ServiceDispatcher serviceDispatcher) {
        super((EnvironmentImpl)repImpl, protocol, "Learner Thread " + protocol.getNameIdPair().getName());
        this.serviceDispatcher = serviceDispatcher;
        this.addListener(new Listener(){

            @Override
            public void notify(Proposer.Proposal proposal, Protocol.Value value) {
                LoggerUtils.logMsg(Learner.this.logger, Learner.this.envImpl, Learner.this.formatter, Level.FINE, "Learner notified. Proposal:" + proposal + " Value: " + value);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processResult(Proposer.Proposal proposal, Protocol.Value value) {
        if (this.currentProposal != null && proposal.compareTo(this.currentProposal) < 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Ignoring obsolete winner: " + proposal);
            return;
        }
        this.currentProposal = proposal;
        this.currentValue = value;
        List<Listener> list = this.listeners;
        synchronized (list) {
            for (Listener listener : this.listeners) {
                try {
                    listener.notify(this.currentProposal, this.currentValue);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.SEVERE, "Exception in Learner Listener: " + e.getMessage());
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block25: {
            this.serviceDispatcher.register("Learner", this.channelQueue);
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Learner started");
            channel = null;
            try {
                while (true) lbl-1000:
                // 8 sources

                {
                    if ((channel = this.serviceDispatcher.takeChannel("Learner", this.protocol.getReadTimeout())) == null) {
                        return;
                    }
                    in = null;
                    out = null;
                    try {
                        in = new BufferedReader(new InputStreamReader(Channels.newInputStream(channel)));
                        requestLine = in.readLine();
                        if (requestLine == null) ** GOTO lbl-1000
                        try {
                            requestMessage = this.protocol.parseRequest(requestLine);
                        }
                        catch (TextProtocol.InvalidMessageException ime) {
                            this.protocol.processIME(channel, ime);
                            Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                        }
                        op = requestMessage.getOp();
                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINEST, "learner request: " + op + " sender: " + requestMessage.getSenderId());
                        if (op == this.protocol.RESULT) {
                            result = (Protocol.Result)requestMessage;
                            this.processResult(result.getProposal(), result.getValue());
                        }
                        if (op == this.protocol.MASTER_QUERY) {
                            this.processMasterQuery(channel, requestMessage);
                        }
                        if (op == this.protocol.SHUTDOWN) {
                            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Learner thread exiting");
                            break block25;
                        }
                        message = "Malformed request: '" + requestLine + "' Unexpected op:" + op;
                        ime = new TextProtocol.InvalidMessageException(TextProtocol.MessageError.BAD_FORMAT, message);
                        this.protocol.processIME(channel, ime);
                    }
                    catch (IOException e) {
                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "IO exception: " + e.getMessage());
                    }
                    catch (Exception e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                    finally {
                        Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                if (this.isShutdown()) {
                    return;
                }
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Learner unexpected interrupted");
                throw EnvironmentFailureException.unexpectedException(e);
            }
            finally {
                this.serviceDispatcher.cancel("Learner");
                this.cleanup();
            }
            ** GOTO lbl-1000
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processMasterQuery(DataChannel channel, TextProtocol.RequestMessage requestMessage) {
        if (this.currentProposal == null || this.currentValue == null) {
            return;
        }
        if (this.envImpl == null || !((RepImpl)this.envImpl).getState().isActive()) {
            return;
        }
        try (PrintWriter out = null;){
            out = new PrintWriter(Channels.newOutputStream(channel), true);
            Protocol protocol = this.protocol;
            protocol.getClass();
            Protocol.MasterQueryResponse responseMessage = new Protocol.MasterQueryResponse(protocol, this.currentProposal, this.currentValue);
            responseMessage.setSendVersion(requestMessage.getSendVersion());
            out.println(responseMessage.wireFormat());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryForMaster(Set<InetSocketAddress> learnerSockets) {
        if (learnerSockets.size() <= 0) {
            return;
        }
        int threadPoolSize = Math.min(learnerSockets.size(), 10);
        ExecutorService pool = Executors.newFixedThreadPool(threadPoolSize, new StoppableThreadFactory("JE Learner", this.logger));
        try {
            Protocol.MasterQuery masterQuery = new Protocol.MasterQuery(this.protocol);
            Utils.FutureTrackingCompService<TextProtocol.MessageExchange> compService = Utils.broadcastMessage(learnerSockets, SERVICE_NAME, masterQuery, pool);
            new Utils.WithFutureExceptionHandler<TextProtocol.MessageExchange>(compService, (long)(2 * this.protocol.getReadTimeout()), TimeUnit.MILLISECONDS, this.logger, (RepImpl)this.envImpl, (Formatter)this.formatter){

                @Override
                protected void processResponse(TextProtocol.MessageExchange me) {
                    if (me.getResponseMessage().getOp() == Learner.this.protocol.MASTER_QUERY_RESPONSE) {
                        Protocol.MasterQueryResponse accept = (Protocol.MasterQueryResponse)me.getResponseMessage();
                        MasterValue masterValue = (MasterValue)accept.getValue();
                        if (masterValue != null && masterValue.getNameId().equals(Learner.this.protocol.getNameIdPair())) {
                            return;
                        }
                        Learner.this.processResult(accept.getProposal(), masterValue);
                    }
                }

                @Override
                protected boolean isShutdown() {
                    return Learner.this.isShutdown();
                }
            }.execute();
        }
        finally {
            pool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MasterValue findMaster(final Protocol protocol, Set<InetSocketAddress> learnerSockets, final Logger logger, final RepImpl repImpl, final Formatter formatter) throws UnknownMasterException {
        if (learnerSockets.size() <= 0) {
            return null;
        }
        int threadPoolSize = Math.min(learnerSockets.size(), 10);
        ExecutorService pool = Executors.newFixedThreadPool(threadPoolSize);
        try {
            Utils.FutureTrackingCompService<TextProtocol.MessageExchange> compService = Utils.broadcastMessage(learnerSockets, SERVICE_NAME, new Protocol.MasterQuery(protocol), pool);
            final LinkedList results = new LinkedList();
            new Utils.WithFutureExceptionHandler<TextProtocol.MessageExchange>(compService, (long)(2 * protocol.getReadTimeout()), TimeUnit.MILLISECONDS, logger, repImpl, formatter){

                @Override
                protected void processResponse(TextProtocol.MessageExchange me) {
                    TextProtocol.ResponseMessage response = me.getResponseMessage();
                    if (response.getOp() == protocol.MASTER_QUERY_RESPONSE) {
                        results.add((Protocol.MasterQueryResponse)response);
                    } else {
                        LoggerUtils.logMsg(logger, (EnvironmentImpl)repImpl, formatter, Level.WARNING, "Unexpected MasterQuery response:" + response.wireFormat());
                    }
                }

                @Override
                protected boolean isShutdown() {
                    return repImpl != null && !repImpl.isValid();
                }
            }.execute();
            Protocol.Accepted bestResponse = null;
            for (Protocol.MasterQueryResponse result : results) {
                if (bestResponse != null && result.getProposal().compareTo(bestResponse.getProposal()) <= 0) continue;
                bestResponse = result;
            }
            if (bestResponse == null) {
                throw new UnknownMasterException("Could not determine master from helpers at:" + learnerSockets.toString());
            }
            MasterValue masterValue = (MasterValue)bestResponse.getValue();
            return masterValue;
        }
        finally {
            pool.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinformLearners(Set<InetSocketAddress> learners, ExecutorService threadPool) {
        Proposer.WinningProposal winningProposal;
        Learner learner = this;
        synchronized (learner) {
            if (this.currentProposal == null || this.currentValue == null) {
                return;
            }
            winningProposal = new Proposer.WinningProposal(this.currentProposal, this.currentValue, null);
        }
        RepImpl repImpl = (RepImpl)this.envImpl;
        if (repImpl == null) {
            return;
        }
        Learner.informLearners(learners, winningProposal, this.protocol, threadPool, this.logger, repImpl, this.formatter);
    }

    public static void informLearners(Set<InetSocketAddress> learners, Proposer.WinningProposal winningProposal, Protocol protocol, ExecutorService threadPool, Logger logger, final RepImpl repImpl, Formatter formatter) {
        if (learners == null || learners.size() == 0) {
            throw EnvironmentFailureException.unexpectedState("There must be at least one learner");
        }
        LoggerUtils.logMsg(logger, (EnvironmentImpl)repImpl, formatter, Level.FINE, "Informing " + learners.size() + " learners.");
        Protocol protocol2 = protocol;
        protocol2.getClass();
        Utils.FutureTrackingCompService<TextProtocol.MessageExchange> compService = Utils.broadcastMessage(learners, SERVICE_NAME, new Protocol.Result(protocol2, winningProposal.proposal, winningProposal.chosenValue), threadPool);
        final AtomicInteger count = new AtomicInteger(0);
        new Utils.WithFutureExceptionHandler<TextProtocol.MessageExchange>(compService, (long)(2 * protocol.getReadTimeout()), TimeUnit.MILLISECONDS, logger, repImpl, formatter){

            @Override
            protected void processResponse(TextProtocol.MessageExchange me) {
                count.incrementAndGet();
            }

            @Override
            protected void processNullResponse(TextProtocol.MessageExchange me) {
                if (me.getException() == null) {
                    count.incrementAndGet();
                }
            }

            @Override
            protected boolean isShutdown() {
                return repImpl != null && !repImpl.isValid();
            }
        }.execute();
        LoggerUtils.logMsg(logger, (EnvironmentImpl)repImpl, formatter, Level.FINE, "Informed learners: " + count.get());
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    public static interface Listener {
        public void notify(Proposer.Proposal var1, Protocol.Value var2);
    }
}

