/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.UtilizationCalculator;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.CleanerFileReader;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINDelta;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHookExecute;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileProcessor
extends DaemonThread {
    private static final int PROCESS_PENDING_EVERY_N_LNS = 100;
    private static final boolean PROHIBIT_DELTAS_WHEN_FETCHING = false;
    private static final boolean DEBUG_TRACING = false;
    private EnvironmentImpl env;
    private Cleaner cleaner;
    private FileSelector fileSelector;
    private UtilizationProfile profile;
    private UtilizationCalculator calculator;
    private int fileLogVersion;
    private int nINsObsoleteThisRun = 0;
    private int nINsCleanedThisRun = 0;
    private int nINsDeadThisRun = 0;
    private int nINsMigratedThisRun = 0;
    private int nBINDeltasObsoleteThisRun = 0;
    private int nBINDeltasCleanedThisRun = 0;
    private int nBINDeltasDeadThisRun = 0;
    private int nBINDeltasMigratedThisRun = 0;
    private int nLNsObsoleteThisRun = 0;
    private int nLNsCleanedThisRun = 0;
    private int nLNsDeadThisRun = 0;
    private int nLNsLockedThisRun = 0;
    private int nLNsMigratedThisRun = 0;
    private int nLNsMarkedThisRun = 0;
    private int nLNQueueHitsThisRun = 0;
    private int nEntriesReadThisRun;
    private long nRepeatIteratorReadsThisRun;

    FileProcessor(String name, EnvironmentImpl env, Cleaner cleaner, UtilizationProfile profile, UtilizationCalculator calculator, FileSelector fileSelector) {
        super(0L, name, env);
        this.env = env;
        this.cleaner = cleaner;
        this.fileSelector = fileSelector;
        this.profile = profile;
        this.calculator = calculator;
    }

    public void clearEnv() {
        this.env = null;
        this.cleaner = null;
        this.fileSelector = null;
        this.profile = null;
        this.calculator = null;
    }

    @Override
    protected long nDeadlockRetries() {
        return this.cleaner.nDeadlockRetries;
    }

    @Override
    public void onWakeup() throws DatabaseException {
        this.doClean(true, true, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int doClean(boolean invokedFromDaemon, boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        if (this.env.isClosed()) {
            return 0;
        }
        assert (this.env.getSyncCleanerBarrier() != null);
        SortedMap<Long, FileSummary> fileSummaryMap = this.profile.getFileSummaryMap(true);
        int nOriginalLogFiles = fileSummaryMap.size();
        int nFilesCleaned = 0;
        while (true) {
            block21: {
                String traceMsg;
                Object var21_21;
                if (nFilesCleaned >= nOriginalLogFiles) {
                    LoggerUtils.logMsg(this.logger, this.env, Level.FINE, "Maximum files cleaned for one run. " + this.fileSelector);
                    return nFilesCleaned;
                }
                if (invokedFromDaemon) {
                    if (this.isPaused()) return nFilesCleaned;
                }
                if (this.env.isClosing()) {
                    return nFilesCleaned;
                }
                this.cleaner.processPending();
                this.calculator.setProtectedFiles();
                boolean needLowUtilizationSet = this.cleaner.clusterResident || this.cleaner.clusterAll;
                Long fileNum = this.fileSelector.selectFileForCleaning(this.calculator, fileSummaryMap, forceCleaning, needLowUtilizationSet, this.cleaner.maxBatchFiles);
                this.cleaner.updateReadOnlyFileCollections();
                boolean calcUtilizationOnly = false;
                if (fileNum == null) {
                    fileNum = this.fileSelector.selectFileForCorrection(this.calculator, fileSummaryMap);
                    calcUtilizationOnly = true;
                }
                if (fileNum == null) {
                    return nFilesCleaned;
                }
                FileSummary estimatedFileSummary = fileSummaryMap.containsKey(fileNum) ? ((FileSummary)fileSummaryMap.get(fileNum)).clone() : null;
                FileSummary trueFileSummary = new FileSummary();
                this.resetPerRunCounters();
                boolean finished = false;
                boolean fileDeleted = false;
                long fileNumValue = fileNum;
                this.cleaner.nCleanerRuns.increment();
                if (calcUtilizationOnly) {
                    this.cleaner.nCleanerProbeRuns.increment();
                }
                long runId = this.cleaner.nCleanerRuns.get();
                MemoryBudget budget = this.env.getMemoryBudget();
                try {
                    block20: {
                        try {
                            TestHookExecute.doHookIfSet(this.cleaner.fileChosenHook);
                            String traceMsg2 = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " begins" + " probe=" + calcUtilizationOnly + " backlog=" + this.fileSelector.getBacklog();
                            LoggerUtils.logMsg(this.logger, this.env, Level.FINE, traceMsg2);
                            if (!this.processFile(fileNum, trueFileSummary, calcUtilizationOnly)) break block20;
                            ++nFilesCleaned;
                            this.accumulatePerRunCounters();
                            finished = true;
                            if (estimatedFileSummary != null) {
                                this.calculator.adjustUtilization(fileNum, fileSummaryMap.lastKey(), estimatedFileSummary, trueFileSummary);
                            }
                        }
                        catch (FileNotFoundException e) {
                            fileDeleted = true;
                            this.profile.removeFile(fileNum, null);
                            this.fileSelector.removeAllFileReferences(fileNum, budget);
                            var21_21 = null;
                            if (!(finished || fileDeleted || calcUtilizationOnly)) {
                                this.fileSelector.putBackFileForCleaning(fileNum);
                            }
                            traceMsg = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " probe=" + calcUtilizationOnly + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " fileDeleted=" + fileDeleted + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nBINDeltasObsolete=" + this.nBINDeltasObsoleteThisRun + " nBINDeltasCleaned=" + this.nBINDeltasCleanedThisRun + " nBINDeltasDead=" + this.nBINDeltasDeadThisRun + " nBINDeltasMigrated=" + this.nBINDeltasMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNQueueHits=" + this.nLNQueueHitsThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
                            LoggerUtils.traceAndLog(this.logger, this.env, Level.FINE, traceMsg);
                            break block21;
                        }
                        catch (IOException e) {
                            LoggerUtils.traceAndLogException(this.env, "Cleaner", "doClean", "", e);
                            throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
                        }
                        catch (DatabaseException e) {
                            LoggerUtils.traceAndLogException(this.env, "Cleaner", "doClean", "", e);
                            throw e;
                        }
                    }
                    var21_21 = null;
                    if (!(finished || fileDeleted || calcUtilizationOnly)) {
                        this.fileSelector.putBackFileForCleaning(fileNum);
                    }
                    traceMsg = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " probe=" + calcUtilizationOnly + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " fileDeleted=" + fileDeleted + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nBINDeltasObsolete=" + this.nBINDeltasObsoleteThisRun + " nBINDeltasCleaned=" + this.nBINDeltasCleanedThisRun + " nBINDeltasDead=" + this.nBINDeltasDeadThisRun + " nBINDeltasMigrated=" + this.nBINDeltasMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNQueueHits=" + this.nLNQueueHitsThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
                }
                catch (Throwable throwable) {
                    var21_21 = null;
                    if (!(finished || fileDeleted || calcUtilizationOnly)) {
                        this.fileSelector.putBackFileForCleaning(fileNum);
                    }
                    traceMsg = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " probe=" + calcUtilizationOnly + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " fileDeleted=" + fileDeleted + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nBINDeltasObsolete=" + this.nBINDeltasObsoleteThisRun + " nBINDeltasCleaned=" + this.nBINDeltasCleanedThisRun + " nBINDeltasDead=" + this.nBINDeltasDeadThisRun + " nBINDeltasMigrated=" + this.nBINDeltasMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNQueueHits=" + this.nLNQueueHitsThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
                    LoggerUtils.traceAndLog(this.logger, this.env, Level.FINE, traceMsg);
                    throw throwable;
                }
                LoggerUtils.traceAndLog(this.logger, this.env, Level.FINE, traceMsg);
            }
            if (!cleanMultipleFiles) {
                return nFilesCleaned;
            }
            fileSummaryMap = this.profile.getFileSummaryMap(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processFile(Long fileNum, FileSummary fileSummary, boolean calcUtilizationOnly) throws DatabaseException, IOException {
        PackedOffsets obsoleteOffsets = this.profile.getObsoleteDetail(fileNum, true);
        PackedOffsets.Iterator obsoleteIter = obsoleteOffsets.iterator();
        long nextObsolete = -1L;
        int readBufferSize = this.cleaner.readBufferSize;
        int lookAheadCacheSize = calcUtilizationOnly ? 0 : this.cleaner.lookAheadCacheSize;
        int adjustMem = 2 * readBufferSize + obsoleteOffsets.getLogSize() + lookAheadCacheSize;
        MemoryBudget budget = this.env.getMemoryBudget();
        budget.updateAdminMemoryUsage(adjustMem);
        this.env.daemonEviction(true);
        LookAheadCache lookAheadCache = calcUtilizationOnly ? null : new LookAheadCache(lookAheadCacheSize);
        HashSet<DatabaseId> checkPendingDbSet = calcUtilizationOnly ? null : new HashSet<DatabaseId>();
        HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
        DbTree dbMapTree = this.env.getDbTree();
        HashSet<DatabaseId> databases = new HashSet<DatabaseId>();
        CleanerFileReader reader = new CleanerFileReader(this.env, readBufferSize, DbLsn.makeLsn((long)fileNum, 0), fileNum, fileSummary);
        reader.setAlwaysValidateChecksum(true);
        try {
            try {
                TreeLocation location = new TreeLocation();
                int nProcessedLNs = 0;
                while (reader.readNextEntryAllowExceptions()) {
                    this.cleaner.nEntriesRead.increment();
                    long logLsn = reader.getLastLsn();
                    long fileOffset = DbLsn.getFileOffset(logLsn);
                    boolean isLN = reader.isLN();
                    boolean isIN = reader.isIN();
                    boolean isBINDelta = reader.isBINDelta();
                    boolean isDbTree = reader.isDbTree();
                    boolean isObsolete = false;
                    DatabaseId dbId = reader.getDatabaseId();
                    DatabaseImpl db = null;
                    if (dbId != null) {
                        databases.add(dbId);
                        db = dbMapTree.getDb(dbId, this.cleaner.lockTimeout, dbCache);
                        if (db == null || db.isDeleted()) {
                            isObsolete = true;
                        }
                    }
                    if (reader.isFileHeader()) {
                        this.fileLogVersion = reader.getFileHeader().getLogVersion();
                    }
                    if (this.env.isClosing()) {
                        boolean bl = false;
                        Object var36_35 = null;
                        budget.updateAdminMemoryUsage(0 - adjustMem);
                        dbMapTree.releaseDbs(dbCache);
                        return bl;
                    }
                    int nReads = reader.getAndResetNReads();
                    if (nReads > 0) {
                        this.env.updateBackgroundReads(nReads);
                    }
                    this.env.sleepAfterBackgroundIO();
                    while (nextObsolete < fileOffset && obsoleteIter.hasNext()) {
                        nextObsolete = obsoleteIter.next();
                    }
                    if (nextObsolete == fileOffset) {
                        isObsolete = true;
                    }
                    if (!(isObsolete || isLN || isIN || isBINDelta || isDbTree)) {
                        isObsolete = true;
                    }
                    if (!isObsolete && isLN && reader.isLNDeleted() && this.fileLogVersion > 2) {
                        isObsolete = true;
                    }
                    if (isObsolete) {
                        if (!calcUtilizationOnly) {
                            if (isLN) {
                                ++this.nLNsObsoleteThisRun;
                            } else if (isBINDelta) {
                                ++this.nBINDeltasObsoleteThisRun;
                            } else if (isIN) {
                                ++this.nINsObsoleteThisRun;
                            }
                        }
                        if (checkPendingDbSet != null && dbId != null) {
                            checkPendingDbSet.add(dbId);
                        }
                        reader.countObsolete();
                        continue;
                    }
                    if (calcUtilizationOnly) continue;
                    this.env.daemonEviction(true);
                    if (isLN) {
                        LNLogEntry lnEntry = reader.getLNLogEntry();
                        lnEntry.postFetchInit(db);
                        LN targetLN = lnEntry.getLN();
                        byte[] key = lnEntry.getKey();
                        lookAheadCache.add(DbLsn.getFileOffset(logLsn), new LNInfo(targetLN, dbId, key));
                        if (lookAheadCache.isFull()) {
                            this.processLN(fileNum, location, lookAheadCache, dbCache);
                        }
                        if (++nProcessedLNs % 100 != 0) continue;
                        this.cleaner.processPending();
                        continue;
                    }
                    if (isIN) {
                        IN targetIN = reader.getIN(db);
                        targetIN.setDatabase(db);
                        this.processIN(targetIN, db, logLsn);
                        continue;
                    }
                    if (isBINDelta) {
                        BINDelta delta = reader.getBINDelta();
                        this.processBINDelta(delta, db, logLsn);
                        continue;
                    }
                    if (isDbTree) {
                        this.env.rewriteMapTreeRoot(logLsn);
                        continue;
                    }
                    assert (false);
                }
                if (lookAheadCache != null) {
                    while (!lookAheadCache.isEmpty()) {
                        this.env.daemonEviction(true);
                        this.processLN(fileNum, location, lookAheadCache, dbCache);
                        this.env.sleepAfterBackgroundIO();
                    }
                }
                if (checkPendingDbSet != null) {
                    for (DatabaseId pendingDbId : checkPendingDbSet) {
                        DatabaseImpl db = dbMapTree.getDb(pendingDbId, this.cleaner.lockTimeout, dbCache);
                        this.cleaner.addPendingDB(db);
                    }
                }
                this.nEntriesReadThisRun = reader.getNumRead();
                this.nRepeatIteratorReadsThisRun = reader.getNRepeatIteratorReads();
            }
            catch (ChecksumException e) {
                throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var36_37 = null;
            budget.updateAdminMemoryUsage(0 - adjustMem);
            dbMapTree.releaseDbs(dbCache);
            throw throwable;
        }
        Object var36_36 = null;
        budget.updateAdminMemoryUsage(0 - adjustMem);
        dbMapTree.releaseDbs(dbCache);
        if (!calcUtilizationOnly) {
            this.fileSelector.addCleanedFile(fileNum, databases, reader.getLastVLSN(), budget);
        }
        return true;
    }

    void testProcessLN(LN targetLN, long logLsn, byte[] key, DatabaseId dbId, Map<DatabaseId, DatabaseImpl> dbCache) {
        LookAheadCache lookAheadCache = new LookAheadCache(1);
        lookAheadCache.add(DbLsn.getFileOffset(logLsn), new LNInfo(targetLN, dbId, key));
        this.processLN(DbLsn.getFileNumber(logLsn), new TreeLocation(), lookAheadCache, dbCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processLN(Long fileNum, TreeLocation location, LookAheadCache lookAheadCache, Map<DatabaseId, DatabaseImpl> dbCache) throws DatabaseException {
        IN bin;
        boolean completed;
        boolean obsolete;
        boolean processedHere;
        long logLsn;
        LN ln;
        block12: {
            block11: {
                block9: {
                    block10: {
                        ++this.nLNsCleanedThisRun;
                        Long offset = lookAheadCache.nextOffset();
                        LNInfo info = lookAheadCache.remove(offset);
                        ln = info.getLN();
                        byte[] key = info.getKey();
                        logLsn = DbLsn.makeLsn((long)fileNum, offset);
                        DatabaseImpl db = this.env.getDbTree().getDb(info.getDbId(), this.cleaner.lockTimeout, dbCache);
                        processedHere = true;
                        obsolete = false;
                        completed = false;
                        bin = null;
                        try {
                            Tree tree = db.getTree();
                            assert (tree != null);
                            boolean parentFound = tree.getParentBINForChildLN(location, key, false, true, Cleaner.UPDATE_GENERATION);
                            bin = location.bin;
                            int index = location.index;
                            if (!parentFound) {
                                ++this.nLNsDeadThisRun;
                                obsolete = true;
                                completed = true;
                                Object var25_18 = null;
                                if (bin == null) break block9;
                                break block10;
                            }
                            if (bin.isEntryKnownDeleted(index)) {
                                ++this.nLNsDeadThisRun;
                                obsolete = true;
                                completed = true;
                                break block11;
                            }
                            processedHere = false;
                            this.processFoundLN(info, logLsn, bin.getLsn(index), (BIN)bin, index);
                            completed = true;
                            for (int i = 0; i < bin.getNEntries(); ++i) {
                                Long myOffset;
                                LNInfo myInfo;
                                long binLsn = bin.getLsn(i);
                                if (i == index || bin.isEntryKnownDeleted(i) || bin.isEntryPendingDeleted(i) || DbLsn.getFileNumber(binLsn) != fileNum || (myInfo = lookAheadCache.remove(myOffset = Long.valueOf(DbLsn.getFileOffset(binLsn)))) == null) continue;
                                ++this.nLNQueueHitsThisRun;
                                ++this.nLNsCleanedThisRun;
                                this.processFoundLN(myInfo, binLsn, binLsn, (BIN)bin, i);
                            }
                            break block12;
                        }
                        catch (Throwable throwable) {
                            Object var25_21 = null;
                            if (bin != null) {
                                bin.releaseLatch();
                            }
                            if (!processedHere) throw throwable;
                            this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
                            throw throwable;
                        }
                    }
                    bin.releaseLatch();
                }
                if (!processedHere) return;
                this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
                return;
            }
            Object var25_19 = null;
            if (bin != null) {
                bin.releaseLatch();
            }
            if (!processedHere) return;
            this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
            return;
        }
        Object var25_20 = null;
        if (bin != null) {
            bin.releaseLatch();
        }
        if (!processedHere) return;
        this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFoundLN(LNInfo info, long logLsn, long treeLsn, BIN bin, int index) throws DatabaseException {
        boolean completed;
        boolean lockDenied;
        boolean migrated;
        boolean obsolete;
        boolean isTemporary;
        DatabaseImpl db;
        byte[] key;
        LN lnFromLog;
        block27: {
            lnFromLog = info.getLN();
            key = info.getKey();
            db = bin.getDatabase();
            isTemporary = db.isTemporary();
            obsolete = false;
            migrated = false;
            lockDenied = false;
            completed = false;
            Locker locker = null;
            try {
                Tree tree = db.getTree();
                assert (tree != null);
                if (lnFromLog.isDeleted() && treeLsn == logLsn && this.fileLogVersion <= 2) {
                    obsolete = true;
                    ++this.nLNsDeadThisRun;
                    bin.setPendingDeleted(index);
                } else if (treeLsn == -1L) {
                    obsolete = true;
                } else if (treeLsn != logLsn && isTemporary) {
                    ++this.nLNsDeadThisRun;
                    obsolete = true;
                } else if (!(treeLsn == logLsn && this.cleaner.lazyMigration || isTemporary)) {
                    locker = BasicLocker.createBasicLocker(this.env, false);
                    locker.setPreemptable(false);
                    LockResult lockRet = locker.nonBlockingLock(treeLsn, LockType.READ, false, db);
                    if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                        ++this.nLNsLockedThisRun;
                        lockDenied = true;
                    } else if (treeLsn != logLsn) {
                        ++this.nLNsDeadThisRun;
                        obsolete = true;
                    }
                }
                if (!obsolete && !lockDenied) {
                    assert (treeLsn == logLsn);
                    if (bin.getTarget(index) == null) {
                        lnFromLog.postFetchInit(db, logLsn);
                        bin.updateNode(index, lnFromLog, key);
                    }
                    if (isTemporary) {
                        ((LN)bin.getTarget(index)).setDirty();
                        bin.setDirty(true);
                    } else if (this.cleaner.lazyMigration) {
                        bin.setMigrate(index, true);
                        bin.setDirty(true);
                    } else {
                        LN targetLn = (LN)bin.getTarget(index);
                        assert (targetLn != null);
                        long newLNLsn = targetLn.log(this.env, db, bin.getKey(index), logLsn, true, Cleaner.getMigrationRepContext(targetLn));
                        bin.updateEntry(index, newLNLsn);
                        if (lnFromLog == targetLn) {
                            bin.updateNode(index, null, null);
                        }
                        CursorImpl.lockAfterLsnChange(db, logLsn, newLNLsn, locker);
                    }
                    bin.setGeneration(CacheMode.DEFAULT);
                    ++this.nLNsMarkedThisRun;
                    migrated = true;
                }
                completed = true;
                Object var22_18 = null;
                if (locker == null) break block27;
            }
            catch (Throwable throwable) {
                Object var22_19 = null;
                if (locker != null) {
                    locker.operationEnd();
                }
                if (completed && lockDenied) {
                    assert (!isTemporary);
                    this.fileSelector.addPendingLN(treeLsn, lnFromLog, db.getId(), key);
                }
                this.cleaner.logFine("CleanLN:", lnFromLog, logLsn, completed, obsolete, migrated);
                throw throwable;
            }
            locker.operationEnd();
        }
        if (completed && lockDenied) {
            assert (!isTemporary);
            this.fileSelector.addPendingLN(treeLsn, lnFromLog, db.getId(), key);
        }
        this.cleaner.logFine("CleanLN:", lnFromLog, logLsn, completed, obsolete, migrated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processBINDelta(BINDelta deltaClone, DatabaseImpl db, long logLsn) {
        BIN treeBin;
        block7: {
            block6: {
                block5: {
                    ++this.nBINDeltasCleanedThisRun;
                    byte[] searchKey = deltaClone.getSearchKey();
                    treeBin = (BIN)db.getTree().search(searchKey, Tree.SearchType.NORMAL, null, Cleaner.UPDATE_GENERATION, null);
                    if (treeBin == null) {
                        ++this.nBINDeltasDeadThisRun;
                        return;
                    }
                    try {
                        long treeLsn = treeBin.getLastLoggedVersion();
                        if (treeLsn == -1L) {
                            ++this.nBINDeltasDeadThisRun;
                            Object var11_7 = null;
                            break block5;
                        }
                        int cmp = DbLsn.compareTo(treeLsn, logLsn);
                        if (cmp > 0) {
                            ++this.nBINDeltasDeadThisRun;
                            break block6;
                        }
                        treeBin.setDirty(true);
                        ++this.nBINDeltasMigratedThisRun;
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var11_10 = null;
                        treeBin.releaseLatch();
                        throw throwable;
                    }
                }
                treeBin.releaseLatch();
                return;
            }
            Object var11_8 = null;
            treeBin.releaseLatch();
            return;
        }
        Object var11_9 = null;
        treeBin.releaseLatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIN(IN inClone, DatabaseImpl db, long logLsn) throws DatabaseException {
        boolean obsolete = false;
        boolean dirtied = false;
        boolean completed = false;
        try {
            ++this.nINsCleanedThisRun;
            Tree tree = db.getTree();
            assert (tree != null);
            IN inInTree = this.findINInTree(tree, db, inClone, logLsn);
            if (inInTree == null) {
                ++this.nINsDeadThisRun;
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                inInTree.setDirty(true);
                inInTree.setProhibitNextDelta();
                inInTree.releaseLatch();
                dirtied = true;
            }
            completed = true;
            Object var11_9 = null;
            this.cleaner.logFine("CleanIN:", inClone, logLsn, completed, obsolete, dirtied);
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.cleaner.logFine("CleanIN:", inClone, logLsn, completed, obsolete, dirtied);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN findINInTree(Tree tree, DatabaseImpl db, IN inClone, long logLsn) throws DatabaseException {
        SearchResult result;
        block18: {
            int compareVal;
            long treeLsn;
            block17: {
                block16: {
                    block15: {
                        if (inClone.isDbRoot()) {
                            IN rootIN = this.isRoot(tree, db, inClone, logLsn);
                            if (rootIN == null) {
                                return null;
                            }
                            return rootIN;
                        }
                        inClone.latch(Cleaner.UPDATE_GENERATION);
                        result = null;
                        try {
                            result = tree.getParentINForChildIN(inClone, true, Cleaner.UPDATE_GENERATION, inClone.getLevel(), null);
                            if (result.exactParentFound) break block15;
                            IN iN = null;
                            Object var13_9 = null;
                            if (result != null && result.exactParentFound) {
                                result.parent.releaseLatch();
                            }
                            return iN;
                        }
                        catch (Throwable throwable) {
                            block19: {
                                Object var13_14 = null;
                                if (result == null || !result.exactParentFound) break block19;
                                result.parent.releaseLatch();
                            }
                            throw throwable;
                        }
                    }
                    treeLsn = result.parent.getLsn(result.index);
                    if (treeLsn != -1L) break block16;
                    IN iN = null;
                    Object var13_10 = null;
                    if (result != null && result.exactParentFound) {
                        result.parent.releaseLatch();
                    }
                    return iN;
                }
                if (treeLsn != logLsn) break block17;
                IN in = (IN)result.parent.getTarget(result.index);
                if (in == null) {
                    in = inClone;
                    in.postFetchInit(db, logLsn);
                    result.parent.updateNode(result.index, in, null);
                }
                in.latch(Cleaner.UPDATE_GENERATION);
                IN iN = in;
                Object var13_11 = null;
                if (result != null && result.exactParentFound) {
                    result.parent.releaseLatch();
                }
                return iN;
            }
            if (inClone.isBIN()) {
                IN in = (IN)result.parent.fetchTargetWithExclusiveLatch(result.index);
                treeLsn = in.getLastFullVersion();
            }
            if ((compareVal = DbLsn.compareTo(treeLsn, logLsn)) <= 0) break block18;
            IN iN = null;
            Object var13_12 = null;
            if (result != null && result.exactParentFound) {
                result.parent.releaseLatch();
            }
            return iN;
        }
        IN in = (IN)result.parent.fetchTargetWithExclusiveLatch(result.index);
        in.latch(Cleaner.UPDATE_GENERATION);
        IN iN = in;
        Object var13_13 = null;
        if (result != null && result.exactParentFound) {
            result.parent.releaseLatch();
        }
        return iN;
    }

    private IN isRoot(Tree tree, DatabaseImpl db, IN inClone, long lsn) throws DatabaseException {
        RootDoWork rdw = new RootDoWork(db, inClone, lsn);
        return tree.withRootLatchedShared(rdw);
    }

    private void resetPerRunCounters() {
        this.nINsObsoleteThisRun = 0;
        this.nINsCleanedThisRun = 0;
        this.nINsDeadThisRun = 0;
        this.nINsMigratedThisRun = 0;
        this.nLNsObsoleteThisRun = 0;
        this.nLNsCleanedThisRun = 0;
        this.nLNsDeadThisRun = 0;
        this.nLNsMigratedThisRun = 0;
        this.nLNsMarkedThisRun = 0;
        this.nLNQueueHitsThisRun = 0;
        this.nLNsLockedThisRun = 0;
        this.nEntriesReadThisRun = 0;
        this.nRepeatIteratorReadsThisRun = 0L;
    }

    private void accumulatePerRunCounters() {
        this.cleaner.nINsObsolete.add(this.nINsObsoleteThisRun);
        this.cleaner.nINsCleaned.add(this.nINsCleanedThisRun);
        this.cleaner.nINsDead.add(this.nINsDeadThisRun);
        this.cleaner.nINsMigrated.add(this.nINsMigratedThisRun);
        this.cleaner.nBINDeltasObsolete.add(this.nBINDeltasObsoleteThisRun);
        this.cleaner.nBINDeltasCleaned.add(this.nBINDeltasCleanedThisRun);
        this.cleaner.nBINDeltasDead.add(this.nBINDeltasDeadThisRun);
        this.cleaner.nBINDeltasMigrated.add(this.nBINDeltasMigratedThisRun);
        this.cleaner.nLNsObsolete.add(this.nLNsObsoleteThisRun);
        this.cleaner.nLNsCleaned.add(this.nLNsCleanedThisRun);
        this.cleaner.nLNsDead.add(this.nLNsDeadThisRun);
        this.cleaner.nLNsMigrated.add(this.nLNsMigratedThisRun);
        this.cleaner.nLNsMarked.add(this.nLNsMarkedThisRun);
        this.cleaner.nLNQueueHits.add(this.nLNQueueHitsThisRun);
        this.cleaner.nLNsLocked.add(this.nLNsLockedThisRun);
        this.cleaner.nRepeatIteratorReads.add(this.nRepeatIteratorReadsThisRun);
    }

    private static class LookAheadCache {
        private final SortedMap<Long, LNInfo> map = new TreeMap<Long, LNInfo>();
        private final int maxMem;
        private int usedMem;

        LookAheadCache(int lookAheadCacheSize) {
            this.maxMem = lookAheadCacheSize;
            this.usedMem = MemoryBudget.TREEMAP_OVERHEAD;
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }

        boolean isFull() {
            return this.usedMem >= this.maxMem;
        }

        Long nextOffset() {
            return this.map.firstKey();
        }

        void add(Long lsnOffset, LNInfo info) {
            this.map.put(lsnOffset, info);
            this.usedMem += info.getMemorySize();
            this.usedMem += MemoryBudget.TREEMAP_ENTRY_OVERHEAD;
        }

        LNInfo remove(Long offset) {
            LNInfo info = (LNInfo)this.map.remove(offset);
            if (info != null) {
                this.usedMem -= info.getMemorySize();
                this.usedMem -= MemoryBudget.TREEMAP_ENTRY_OVERHEAD;
            }
            return info;
        }
    }

    private static class RootDoWork
    implements WithRootLatched {
        private final DatabaseImpl db;
        private final IN inClone;
        private final long logLsn;

        RootDoWork(DatabaseImpl db, IN inClone, long logLsn) {
            this.db = db;
            this.inClone = inClone;
            this.logLsn = logLsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null || root.getLsn() == -1L || ((IN)root.fetchTarget(this.db, null)).getNodeId() != this.inClone.getNodeId()) {
                return null;
            }
            if (DbLsn.compareTo(root.getLsn(), this.logLsn) <= 0) {
                IN rootIN = (IN)root.fetchTarget(this.db, null);
                rootIN.latch(Cleaner.UPDATE_GENERATION);
                return rootIN;
            }
            return null;
        }
    }
}

