/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree.dupConvert;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.dupConvert.DBIN;
import com.sleepycat.je.tree.dupConvert.DIN;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import java.util.ArrayList;
import java.util.Iterator;

public class DupConvert {
    private static final boolean DEBUG = false;
    private static final PreloadConfig preloadConfig = new PreloadConfig();
    private final EnvironmentImpl envImpl;
    private final DbTree dbTree;
    private final boolean preloadAll;
    private LocalUtilizationTracker localTracker;
    private long nConverted;
    private BIN bin;
    private int index;

    public DupConvert(EnvironmentImpl envImpl, DbTree dbTree) {
        this.envImpl = envImpl;
        this.dbTree = dbTree;
        this.preloadAll = envImpl.getConfigManager().getBoolean(EnvironmentParams.ENV_DUP_CONVERT_PRELOAD_ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertDatabases() {
        if (this.preloadAll) {
            this.preloadAllDatabases();
        }
        for (DatabaseId dbId : this.dbTree.getDbNamesAndIds().keySet()) {
            Object var5_4;
            DatabaseImpl dbImpl = this.dbTree.getDb(dbId);
            try {
                if (!this.needsConversion(dbImpl)) {
                    var5_4 = null;
                    this.dbTree.releaseDb(dbImpl);
                    continue;
                }
                this.convertDatabase(dbImpl);
            }
            catch (Throwable throwable) {
                var5_4 = null;
                this.dbTree.releaseDb(dbImpl);
                throw throwable;
            }
            var5_4 = null;
            this.dbTree.releaseDb(dbImpl);
            {
            }
        }
        assert (this.noDupNodesPresent());
    }

    private boolean noDupNodesPresent() {
        for (IN in : this.envImpl.getInMemoryINs()) {
            if (!(in instanceof DIN) && !(in instanceof DBIN)) continue;
            System.out.println(in.toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void preloadAllDatabases() {
        ArrayList<DatabaseImpl> dbsToConvert;
        block14: {
            Iterator i$2;
            block13: {
                dbsToConvert = new ArrayList<DatabaseImpl>();
                try {
                    for (DatabaseId dbId : this.dbTree.getDbNamesAndIds().keySet()) {
                        Object var7_6;
                        DatabaseImpl dbImpl = this.dbTree.getDb(dbId);
                        boolean releaseDbImpl = true;
                        try {
                            if (!this.needsConversion(dbImpl)) {
                                var7_6 = null;
                                if (!releaseDbImpl) continue;
                                this.dbTree.releaseDb(dbImpl);
                                continue;
                            }
                            dbsToConvert.add(dbImpl);
                            releaseDbImpl = false;
                        }
                        catch (Throwable throwable) {
                            var7_6 = null;
                            if (releaseDbImpl) {
                                this.dbTree.releaseDb(dbImpl);
                            }
                            throw throwable;
                        }
                        var7_6 = null;
                        if (!releaseDbImpl) continue;
                        this.dbTree.releaseDb(dbImpl);
                    }
                    if (dbsToConvert.size() == 0) {
                        Object var9_8 = null;
                        i$2 = dbsToConvert.iterator();
                        break block13;
                    }
                    DatabaseImpl[] dbArray = new DatabaseImpl[dbsToConvert.size()];
                    dbsToConvert.toArray(dbArray);
                    this.envImpl.preload(dbArray, preloadConfig);
                    break block14;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    Iterator i$2 = dbsToConvert.iterator();
                    while (true) {
                        if (!i$2.hasNext()) {
                            throw throwable;
                        }
                        DatabaseImpl dbImpl = (DatabaseImpl)i$2.next();
                        this.dbTree.releaseDb(dbImpl);
                    }
                }
            }
            while (i$2.hasNext()) {
                DatabaseImpl dbImpl = (DatabaseImpl)i$2.next();
                this.dbTree.releaseDb(dbImpl);
            }
            return;
        }
        Object var9_9 = null;
        Iterator i$2 = dbsToConvert.iterator();
        while (i$2.hasNext()) {
            DatabaseImpl dbImpl = (DatabaseImpl)i$2.next();
            this.dbTree.releaseDb(dbImpl);
        }
        return;
    }

    private boolean needsConversion(DatabaseImpl dbImpl) {
        return dbImpl.getSortedDuplicates() && !dbImpl.getDupsConverted() && !dbImpl.isDeleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertDatabase(DatabaseImpl dbImpl) {
        boolean saveDeferredWrite = dbImpl.isDurableDeferredWrite();
        try {
            this.localTracker = new LocalUtilizationTracker(this.envImpl);
            dbImpl.setDeferredWrite(true);
            dbImpl.setKeyPrefixing();
            if (!this.preloadAll) {
                dbImpl.preload(preloadConfig);
            }
            this.bin = (BIN)dbImpl.getTree().getFirstNode(CacheMode.UNCHANGED);
            if (this.bin == null) {
                Object var4_3 = null;
                dbImpl.setDeferredWrite(saveDeferredWrite);
                return;
            }
            this.index = -1;
            while (this.getNextBinSlot()) {
                this.convertBinSlot();
            }
            dbImpl.setDupsConverted();
            dbImpl.sync(false);
            this.envImpl.getUtilizationProfile().flushLocalTracker(this.localTracker);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            dbImpl.setDeferredWrite(saveDeferredWrite);
            throw throwable;
        }
        Object var4_4 = null;
        dbImpl.setDeferredWrite(saveDeferredWrite);
    }

    private boolean getNextBinSlot() {
        ++this.index;
        if (this.index < this.bin.getNEntries()) {
            return true;
        }
        this.bin.compactMemory();
        assert (this.bin.verifyMemorySize());
        this.bin = this.bin.getDatabase().getTree().getNextBin(this.bin, CacheMode.UNCHANGED);
        if (this.bin == null) {
            return false;
        }
        this.index = 0;
        return true;
    }

    private void convertBinSlot() {
        if (this.isLNDeleted(this.bin, this.index)) {
            this.deleteSlot();
            return;
        }
        Node node = this.bin.fetchTarget(this.index);
        if (!node.containsDuplicates()) {
            assert (node instanceof LN);
            ++this.nConverted;
            return;
        }
        byte[] binKey = this.bin.getKey(this.index);
        this.deleteSlot();
        DIN din = (DIN)node;
        this.envImpl.getInMemoryINs().remove(din);
        this.convertDin(din, binKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLNDeleted(BIN checkBin, int checkIndex) {
        BasicLocker lockingTxn;
        block5: {
            boolean bl;
            if (!checkBin.isEntryKnownDeleted(checkIndex) && !checkBin.isEntryPendingDeleted(checkIndex)) {
                return false;
            }
            long lsn = checkBin.getLsn(checkIndex);
            if (lsn == -1L) {
                return true;
            }
            lockingTxn = BasicLocker.createBasicLocker(this.envImpl);
            lockingTxn.setPreemptable(false);
            try {
                LockResult lockRet = lockingTxn.nonBlockingLock(lsn, LockType.READ, false, checkBin.getDatabase());
                if (lockRet.getLockGrant() != LockGrantType.DENIED) break block5;
                bl = false;
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                lockingTxn.operationEnd();
                throw throwable;
            }
            lockingTxn.operationEnd();
            return bl;
        }
        boolean bl = true;
        Object var9_9 = null;
        lockingTxn.operationEnd();
        return bl;
    }

    private void deleteSlot() {
        this.bin.deleteEntry(this.index, true);
        if (this.index == 0 && this.bin.getNEntries() != 0) {
            this.bin.setIdentifierKey(this.bin.getKey(0));
        }
        --this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertDin(DIN din, byte[] binKey) {
        din.latch();
        try {
            ChildReference dupCountRef;
            for (int i = 0; i < din.getNEntries(); ++i) {
                IN child;
                block12: {
                    child = (IN)din.fetchTargetWithExclusiveLatch(i);
                    if (child instanceof DBIN) {
                        Object var8_8;
                        DBIN dbin = (DBIN)child;
                        dbin.latch();
                        try {
                            for (int j = 0; j < dbin.getNEntries(); ++j) {
                                if (this.isLNDeleted(dbin, j)) continue;
                                this.convertDbinSlot(dbin, j, binKey);
                            }
                            assert (dbin.verifyMemorySize());
                            if (dbin.getLastLoggedVersion() != -1L) {
                                this.localTracker.countObsoleteNodeInexact(dbin.getLastLoggedVersion(), dbin.getLogType(), 0, dbin.getDatabase());
                            }
                            var8_8 = null;
                        }
                        catch (Throwable throwable) {
                            var8_8 = null;
                            dbin.releaseLatch();
                            throw throwable;
                        }
                        dbin.releaseLatch();
                        {
                            break block12;
                        }
                    }
                    this.convertDin((DIN)child, binKey);
                }
                din.updateNode(i, null, null);
                this.envImpl.getInMemoryINs().remove(child);
            }
            assert (din.verifyMemorySize());
            if (din.getLastLoggedVersion() != -1L) {
                this.localTracker.countObsoleteNodeInexact(din.getLastLoggedVersion(), din.getLogType(), 0, din.getDatabase());
            }
            if ((dupCountRef = din.getDupCountLNRef()) != null && dupCountRef.getLsn() != -1L) {
                this.localTracker.countObsoleteNodeInexact(dupCountRef.getLsn(), LogEntryType.LOG_DUPCOUNTLN, 0, din.getDatabase());
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            din.releaseLatch();
            throw throwable;
        }
        din.releaseLatch();
    }

    private void convertDbinSlot(DBIN dbin, int dbinIndex, byte[] binKey) {
        ChildReference childRef;
        int newIndex;
        byte[] newKey = DupKeyData.replaceData(binKey, dbin.getKey(dbinIndex));
        if (this.bin.needsSplitting() || !this.bin.isKeyInBounds(newKey)) {
            this.bin.compactMemory();
            this.bin.releaseLatch();
            this.envImpl.daemonEviction(false);
            this.bin = (BIN)dbin.getDatabase().getTree().searchSplitsAllowed(newKey, CacheMode.UNCHANGED, null);
        }
        if (((newIndex = this.bin.insertEntry1(childRef = new ChildReference(null, newKey, dbin.getLsn(dbinIndex), dbin.getState(dbinIndex)))) & 0x20000) == 0) {
            throw EnvironmentFailureException.unexpectedState("Key not inserted: " + Key.dumpString(newKey, 0) + " DB: " + dbin.getDatabase().getId());
        }
        this.index = newIndex & 0xFFFDFFFF;
        dbin.updateNode(dbinIndex, null, null);
        ++this.nConverted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertInKeys(DatabaseImpl dbImpl, IN in) {
        if (!dbImpl.getSortedDuplicates()) {
            return;
        }
        if (in instanceof DIN || in instanceof DBIN) {
            return;
        }
        in.latch();
        try {
            for (int i = 0; i < in.getNEntries(); ++i) {
                byte[] oldKey = in.getKey(i);
                byte[] newKey = DupKeyData.makePrefixKey(oldKey, 0, oldKey.length);
                in.updateEntry(i, in.getTarget(i), in.getLsn(i), newKey);
            }
            byte[] oldKey = in.getIdentifierKey();
            byte[] newKey = DupKeyData.makePrefixKey(oldKey, 0, oldKey.length);
            in.setIdentifierKey(newKey);
            assert (in.verifyMemorySize());
            Object var6_6 = null;
            in.releaseLatch();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            in.releaseLatch();
            throw throwable;
        }
    }
}

