/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark;

import com.snowflake.snowpark.Column;
import com.snowflake.snowpark.internal.ErrorMessage$;
import com.snowflake.snowpark.internal.analyzer.Ascending$;
import com.snowflake.snowpark.internal.analyzer.CurrentRow$;
import com.snowflake.snowpark.internal.analyzer.Expression;
import com.snowflake.snowpark.internal.analyzer.Literal$;
import com.snowflake.snowpark.internal.analyzer.RangeFrame$;
import com.snowflake.snowpark.internal.analyzer.RowFrame$;
import com.snowflake.snowpark.internal.analyzer.SortOrder;
import com.snowflake.snowpark.internal.analyzer.SortOrder$;
import com.snowflake.snowpark.internal.analyzer.SpecifiedWindowFrame;
import com.snowflake.snowpark.internal.analyzer.UnboundedFollowing$;
import com.snowflake.snowpark.internal.analyzer.UnboundedPreceding$;
import com.snowflake.snowpark.internal.analyzer.WindowExpression;
import com.snowflake.snowpark.internal.analyzer.WindowFrame;
import com.snowflake.snowpark.internal.analyzer.WindowSpecDefinition;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t4Aa\u0003\u0007\u0001'!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0011!!\u0004A!A!\u0002\u0013)\u0004B\u0002\u001d\u0001\t\u0003a\u0011\bC\u0003@\u0001\u0011\u0005\u0001\tC\u0003J\u0001\u0011\u0005!\nC\u0003M\u0001\u0011\u0005Q\nC\u0003V\u0001\u0011\u0005a\u000b\u0003\u0004Z\u0001\u0011\u0005AB\u0017\u0005\u0007;\u0002!\t\u0001\u00040\u0003\u0015]Kg\u000eZ8x'B,7M\u0003\u0002\u000e\u001d\u0005A1O\\8xa\u0006\u00148N\u0003\u0002\u0010!\u0005I1O\\8xM2\f7.\u001a\u0006\u0002#\u0005\u00191m\\7\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\u001bA\f'\u000f^5uS>t7\u000b]3d!\raBe\n\b\u0003;\tr!AH\u0011\u000e\u0003}Q!\u0001\t\n\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0012BA\u0012\u0017\u0003\u001d\u0001\u0018mY6bO\u0016L!!\n\u0014\u0003\u0007M+\u0017O\u0003\u0002$-A\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\tC:\fG.\u001f>fe*\u0011A\u0006D\u0001\tS:$XM\u001d8bY&\u0011a&\u000b\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017!C8sI\u0016\u00148\u000b]3d!\raB%\r\t\u0003QIJ!aM\u0015\u0003\u0013M{'\u000f^(sI\u0016\u0014\u0018!\u00024sC6,\u0007C\u0001\u00157\u0013\t9\u0014FA\u0006XS:$wn\u001e$sC6,\u0017A\u0002\u001fj]&$h\b\u0006\u0003;yur\u0004CA\u001e\u0001\u001b\u0005a\u0001\"\u0002\u000e\u0005\u0001\u0004Y\u0002\"B\u0018\u0005\u0001\u0004\u0001\u0004\"\u0002\u001b\u0005\u0001\u0004)\u0014a\u00039beRLG/[8o\u0005f$\"AO!\t\u000b\t+\u0001\u0019A\"\u0002\t\r|Gn\u001d\t\u0004+\u00113\u0015BA#\u0017\u0005)a$/\u001a9fCR,GM\u0010\t\u0003w\u001dK!\u0001\u0013\u0007\u0003\r\r{G.^7o\u0003\u001dy'\u000fZ3s\u0005f$\"AO&\t\u000b\t3\u0001\u0019A\"\u0002\u0017I|wo\u001d\"fi^,WM\u001c\u000b\u0004u9\u001b\u0006\"B(\b\u0001\u0004\u0001\u0016!B:uCJ$\bCA\u000bR\u0013\t\u0011fC\u0001\u0003M_:<\u0007\"\u0002+\b\u0001\u0004\u0001\u0016aA3oI\u0006a!/\u00198hK\n+Go^3f]R\u0019!h\u0016-\t\u000b=C\u0001\u0019\u0001)\t\u000bQC\u0001\u0019\u0001)\u0002\u001b]LG\u000f[!hOJ,w-\u0019;f)\t15\fC\u0003]\u0013\u0001\u0007q%A\u0005bO\u001e\u0014XmZ1uK\u00069r-\u001a;XS:$wn^*qK\u000e$UMZ5oSRLwN\\\u000b\u0002?B\u0011\u0001\u0006Y\u0005\u0003C&\u0012AcV5oI><8\u000b]3d\t\u00164\u0017N\\5uS>t\u0007")
public class WindowSpec {
    private final Seq<Expression> partitionSpec;
    private final Seq<SortOrder> orderSpec;
    private final WindowFrame frame;

    public WindowSpec partitionBy(Seq<Column> cols) {
        return new WindowSpec((Seq<Expression>)((Seq)cols.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.expr(), Seq$.MODULE$.canBuildFrom())), this.orderSpec, this.frame);
    }

    public WindowSpec orderBy(Seq<Column> cols) {
        Seq sortOrder = (Seq)cols.map((Function1 & Serializable & scala.Serializable)col -> {
            Expression expression = col.expr();
            if (expression instanceof SortOrder) {
                SortOrder sortOrder = (SortOrder)expression;
                return sortOrder;
            }
            if (expression != null) {
                Expression expression2 = expression;
                return SortOrder$.MODULE$.apply(expression2, Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            }
            throw new MatchError((Object)expression);
        }, Seq$.MODULE$.canBuildFrom());
        return new WindowSpec(this.partitionSpec, (Seq<SortOrder>)sortOrder, this.frame);
    }

    public WindowSpec rowsBetween(long start, long end) {
        Expression expression;
        Expression expression2;
        long l = start;
        if (0L == l) {
            expression2 = CurrentRow$.MODULE$;
        } else if (Long.MIN_VALUE == l) {
            expression2 = UnboundedPreceding$.MODULE$;
        } else if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            expression2 = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)((int)l)));
        } else {
            throw ErrorMessage$.MODULE$.DF_WINDOW_BOUNDARY_START_INVALID(l);
        }
        CurrentRow$ boundaryStart = expression2;
        long l2 = end;
        if (0L == l2) {
            expression = CurrentRow$.MODULE$;
        } else if (Long.MAX_VALUE == l2) {
            expression = UnboundedFollowing$.MODULE$;
        } else if (Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE) {
            expression = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)((int)l2)));
        } else {
            throw ErrorMessage$.MODULE$.DF_WINDOW_BOUNDARY_END_INVALID(l2);
        }
        CurrentRow$ boundaryEnd = expression;
        return new WindowSpec(this.partitionSpec, this.orderSpec, new SpecifiedWindowFrame(RowFrame$.MODULE$, boundaryStart, boundaryEnd));
    }

    public WindowSpec rangeBetween(long start, long end) {
        long l = start;
        CurrentRow$ boundaryStart = 0L == l ? CurrentRow$.MODULE$ : (Long.MIN_VALUE == l ? UnboundedPreceding$.MODULE$ : Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)l)));
        long l2 = end;
        CurrentRow$ boundaryEnd = 0L == l2 ? CurrentRow$.MODULE$ : (Long.MAX_VALUE == l2 ? UnboundedFollowing$.MODULE$ : Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)l2)));
        return new WindowSpec(this.partitionSpec, this.orderSpec, new SpecifiedWindowFrame(RangeFrame$.MODULE$, boundaryStart, boundaryEnd));
    }

    public Column withAggregate(Expression aggregate) {
        return new Column(new WindowExpression(aggregate, this.getWindowSpecDefinition()));
    }

    public WindowSpecDefinition getWindowSpecDefinition() {
        return new WindowSpecDefinition(this.partitionSpec, this.orderSpec, this.frame);
    }

    public WindowSpec(Seq<Expression> partitionSpec, Seq<SortOrder> orderSpec, WindowFrame frame) {
        this.partitionSpec = partitionSpec;
        this.orderSpec = orderSpec;
        this.frame = frame;
    }
}

