/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark.internal;

import com.snowflake.snowpark.internal.ParameterUtils$;
import com.snowflake.snowpark.internal.ServerConnection;
import com.snowflake.snowpark.internal.analyzer.Attribute;
import com.snowflake.snowpark.internal.analyzer.Attribute$;
import com.snowflake.snowpark.internal.analyzer.package$;
import com.snowflake.snowpark.types.ArrayType;
import com.snowflake.snowpark.types.AtomicType;
import com.snowflake.snowpark.types.BinaryType$;
import com.snowflake.snowpark.types.BooleanType$;
import com.snowflake.snowpark.types.DataType;
import com.snowflake.snowpark.types.DateType$;
import com.snowflake.snowpark.types.DecimalType;
import com.snowflake.snowpark.types.DecimalType$;
import com.snowflake.snowpark.types.DoubleType$;
import com.snowflake.snowpark.types.GeographyType$;
import com.snowflake.snowpark.types.GeometryType$;
import com.snowflake.snowpark.types.IntegerType$;
import com.snowflake.snowpark.types.LongType$;
import com.snowflake.snowpark.types.MapType;
import com.snowflake.snowpark.types.StringType$;
import com.snowflake.snowpark.types.StructField;
import com.snowflake.snowpark.types.StructField$;
import com.snowflake.snowpark.types.StructType$;
import com.snowflake.snowpark.types.StructuredArrayType$;
import com.snowflake.snowpark.types.StructuredMapType$;
import com.snowflake.snowpark.types.TimeType$;
import com.snowflake.snowpark.types.TimestampType$;
import com.snowflake.snowpark.types.VariantType$;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ServerConnection$ {
    public static ServerConnection$ MODULE$;

    static {
        new ServerConnection$();
    }

    public ServerConnection apply(Map<String, String> options, boolean isScalaAPI) {
        return new ServerConnection(options, isScalaAPI, (Option<SnowflakeConnectionV1>)None$.MODULE$);
    }

    public Seq<Attribute> convertResultMetaToAttribute(ResultSetMetaData meta) {
        return (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), meta.getColumnCount()).map((Function1 & Serializable & scala.Serializable)index -> ServerConnection$.$anonfun$convertResultMetaToAttribute$1(meta, BoxesRunTime.unboxToInt((Object)index)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public DataType getDataType(int sqlType, String columnTypeName, int precision, int scale, boolean signed, List<FieldMetadata> field) {
        String string = columnTypeName;
        if ("ARRAY".equals(string)) {
            if (field.isEmpty()) {
                return new ArrayType(StringType$.MODULE$);
            }
            return StructuredArrayType$.MODULE$.apply(this.getDataType(((FieldMetadata)field.head()).getType(), ((FieldMetadata)field.head()).getTypeName(), ((FieldMetadata)field.head()).getPrecision(), ((FieldMetadata)field.head()).getScale(), true, (List<FieldMetadata>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((FieldMetadata)field.head()).getFields()).asScala()).toList()), ((FieldMetadata)field.head()).isNullable());
        }
        if ("VARIANT".equals(string)) {
            return VariantType$.MODULE$;
        }
        if ("OBJECT".equals(string)) {
            if (field.isEmpty()) {
                return new MapType(StringType$.MODULE$, StringType$.MODULE$);
            }
            if (field.size() == 2 && ((FieldMetadata)field.head()).getName().isEmpty()) {
                return StructuredMapType$.MODULE$.apply(this.getDataType(((FieldMetadata)field.head()).getType(), ((FieldMetadata)field.head()).getTypeName(), ((FieldMetadata)field.head()).getPrecision(), ((FieldMetadata)field.head()).getScale(), true, (List<FieldMetadata>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((FieldMetadata)field.head()).getFields()).asScala()).toList()), this.getDataType(((FieldMetadata)field.apply(1)).getType(), ((FieldMetadata)field.apply(1)).getTypeName(), ((FieldMetadata)field.apply(1)).getPrecision(), ((FieldMetadata)field.apply(1)).getScale(), true, (List<FieldMetadata>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((FieldMetadata)field.apply(1)).getFields()).asScala()).toList()), ((FieldMetadata)field.apply(1)).isNullable());
            }
            return StructType$.MODULE$.apply((Seq<StructField>)((Seq)field.map((Function1 & Serializable & scala.Serializable)f -> StructField$.MODULE$.apply(f.getName(), MODULE$.getDataType(f.getType(), f.getTypeName(), f.getPrecision(), f.getScale(), true, (List<FieldMetadata>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(f.getFields()).asScala()).toList()), f.isNullable()), List$.MODULE$.canBuildFrom())));
        }
        if ("GEOGRAPHY".equals(string)) {
            return GeographyType$.MODULE$;
        }
        if ("GEOMETRY".equals(string)) {
            return GeometryType$.MODULE$;
        }
        return this.getTypeFromJDBCType(sqlType, precision, scale, signed);
    }

    public List<FieldMetadata> getDataType$default$6() {
        return List$.MODULE$.empty();
    }

    private DataType getTypeFromJDBCType(int sqlType, int precision, int scale, boolean signed) {
        AtomicType atomicType;
        int n = sqlType;
        switch (n) {
            case -5: {
                if (signed) {
                    atomicType = LongType$.MODULE$;
                    break;
                }
                atomicType = new DecimalType(20, 0);
                break;
            }
            case 16: {
                atomicType = BooleanType$.MODULE$;
                break;
            }
            case 3: {
                if (precision != 0 || scale != 0) {
                    if (precision > DecimalType$.MODULE$.MAX_PRECISION()) {
                        atomicType = new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), scale + (precision - DecimalType$.MODULE$.MAX_SCALE()));
                        break;
                    }
                    atomicType = new DecimalType(precision, scale);
                    break;
                }
                atomicType = new DecimalType(38, 18);
                break;
            }
            case 8: {
                atomicType = DoubleType$.MODULE$;
                break;
            }
            case 92: {
                atomicType = TimeType$.MODULE$;
                break;
            }
            case 91: {
                atomicType = DateType$.MODULE$;
                break;
            }
            case 93: 
            case 2014: {
                atomicType = TimestampType$.MODULE$;
                break;
            }
            case 12: {
                atomicType = StringType$.MODULE$;
                break;
            }
            case -2: {
                atomicType = BinaryType$.MODULE$;
                break;
            }
            case 1: {
                atomicType = StringType$.MODULE$;
                break;
            }
            case 4: {
                if (signed) {
                    atomicType = IntegerType$.MODULE$;
                    break;
                }
                atomicType = LongType$.MODULE$;
                break;
            }
            default: {
                atomicType = null;
                break;
            }
        }
        AtomicType answer = atomicType;
        if (answer == null) {
            throw new SQLException(new StringBuilder(17).append("Unsupported type ").append(sqlType).toString());
        }
        return answer;
    }

    public String connectionString(Map<String, String> lowerCaseParameters) {
        Predef$.MODULE$.require(lowerCaseParameters.contains((Object)ParameterUtils$.MODULE$.Url()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("missing required parameter ").append(ParameterUtils$.MODULE$.Url()).toString());
        String url = ((String)lowerCaseParameters.apply((Object)ParameterUtils$.MODULE$.Url())).trim();
        String urlWithPort = "^.+:\\d+$";
        if (!url.matches(urlWithPort)) {
            url = new StringBuilder(4).append(url).append(":443").toString();
        }
        return new StringBuilder(17).append("jdbc:snowflake://").append(url).toString();
    }

    public static final /* synthetic */ Attribute $anonfun$convertResultMetaToAttribute$1(ResultSetMetaData meta$1, int index) {
        List fieldMetadata = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((SnowflakeResultSetMetaData)meta$1).getColumnFields(index)).asScala()).toList();
        String columnName = package$.MODULE$.quoteNameWithoutUpperCasing(meta$1.getColumnLabel(index));
        int dataType = meta$1.getColumnType(index);
        int fieldSize = meta$1.getPrecision(index);
        int fieldScale = meta$1.getScale(index);
        boolean isSigned = meta$1.isSigned(index);
        boolean nullable = meta$1.isNullable(index) != 0;
        String columnTypeName = meta$1.getColumnTypeName(index);
        DataType columnType = MODULE$.getDataType(dataType, columnTypeName, fieldSize, fieldScale, isSigned, (List<FieldMetadata>)fieldMetadata);
        return Attribute$.MODULE$.apply(columnName, columnType, nullable);
    }

    private ServerConnection$() {
        MODULE$ = this;
    }
}

