/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java.types;

import com.snowflake.snowpark_java.types.FractionalType;
import java.util.Objects;

public class DecimalType
extends FractionalType {
    public static final int MAX_PRECISION = 38;
    public static final int MAX_SCALE = 38;
    private final int precision;
    private final int scale;
    private final String typeName;

    DecimalType(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
        this.typeName = "Decimal(" + precision + ", " + scale + ")";
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public String toString() {
        return this.typeName;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof DecimalType) {
            DecimalType dt = (DecimalType)other;
            return this.precision == dt.precision && this.scale == dt.scale;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.precision, this.scale, this.typeName);
    }
}

