/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java;

import com.snowflake.snowpark.internal.JavaUtils;
import com.snowflake.snowpark_java.Column;
import com.snowflake.snowpark_java.CopyableDataFrame;
import com.snowflake.snowpark_java.DataFrameAsyncActor;
import com.snowflake.snowpark_java.TypedAsyncJob;
import java.util.Map;

public class CopyableDataFrameAsyncActor
extends DataFrameAsyncActor {
    private final com.snowflake.snowpark.CopyableDataFrameAsyncActor cDfAsync;

    CopyableDataFrameAsyncActor(CopyableDataFrame df) {
        super(df);
        this.cDfAsync = df.getScalaCopyableDataFrame().async();
    }

    public TypedAsyncJob<Void> copyInto(String tableName) {
        return TypedAsyncJob.createVoidJob(this.cDfAsync.copyInto(tableName), this.session);
    }

    public TypedAsyncJob<Void> copyInto(String tableName, Column[] transformations) {
        return TypedAsyncJob.createVoidJob(this.cDfAsync.copyInto(tableName, JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(transformations))), this.session);
    }

    public TypedAsyncJob<Void> copyInto(String tableName, Column[] transformations, Map<String, ?> options) {
        return TypedAsyncJob.createVoidJob(this.cDfAsync.copyInto(tableName, JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(transformations)), JavaUtils.javaStringAnyMapToScala(options)), this.session);
    }

    public TypedAsyncJob<Void> copyInto(String tableName, String[] targetColumnNames, Column[] transformations, Map<String, ?> options) {
        return TypedAsyncJob.createVoidJob(this.cDfAsync.copyInto(tableName, JavaUtils.stringArrayToStringSeq(targetColumnNames), JavaUtils.columnArrayToSeq(Column.toScalaColumnArray(transformations)), JavaUtils.javaStringAnyMapToScala(options)), this.session);
    }
}

