/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.snowpark_java.types;

import com.snowflake.snowpark_java.types.DataType;
import java.util.Objects;

public class MapType
extends DataType {
    private final DataType keyType;
    private final DataType valueType;
    private final String typeName;

    MapType(DataType keyType, DataType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.typeName = "MapType[" + keyType.typeName() + ", " + valueType.typeName() + "]";
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    @Override
    public String toString() {
        return this.typeName;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof MapType) {
            MapType mt = (MapType)other;
            return this.keyType.equals(mt.keyType) && this.valueType.equals(mt.valueType);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType, this.typeName);
    }
}

